package io.agora.push;

import io.agora.push.common.PushUtil;

/**
 * \~english
 * The push settings class for customized push.
 */
public abstract class PushListener {
    public abstract void onError(PushType pushType, long errorCode);

    public boolean isSupportPush(PushType pushType, PushConfig pushConfig) {
        return PushUtil.isSupportPush(pushType, pushConfig);
    }

    /**
     * \~english
     * Gets the FCM device token.
     * @param pushType      The push type.
     * @param pushConfig    The push configs.
     * @return              Returns the device token to register.
     */
    public String getPushToken(PushType pushType,PushConfig pushConfig) {
        return "";
    }
}
