package io.agora.push.platform;

import android.content.Context;

import io.agora.push.PushConfig;
import io.agora.push.PushType;
import io.agora.push.PushListener;

public abstract class IPush {
    private static final String TAG = "IPush";

    private String notifierName;

    public void register(Context context, PushConfig config, PushListener pushListener) {
        notifierName = onGetNotifierName(config);
        onRegister(context, config, pushListener);
    }

    public void unregister(Context context) {
        onUnregister(context);
    }

    public String getNotifierName() {
        return notifierName;
    }

    public abstract PushType getPushType();

    public abstract void onRegister(Context context, PushConfig config, PushListener pushListener);

    public abstract void onUnregister(Context context);

    public abstract String onGetNotifierName(PushConfig config);
}
