/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.hardware.display.DisplayManager;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLES20;
import android.os.Build;
import android.view.Display;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import java.nio.IntBuffer;

public class HdrUtil {
    private static final String TAG = "HdrUtil";
    private static final String EGL_EXT_GL_COLORSPACE_DISPLAY_P3 = "EGL_EXT_gl_colorspace_display_p3";
    private static final String EXTENSION_COLORSPACE_BT2020_PQ = "EGL_EXT_gl_colorspace_bt2020_pq";
    private static final String EGL_EXT_SURFACE_SMPTE2086_METADATA = "EGL_EXT_surface_SMPTE2086_metadata";
    private static final boolean isScreenSupportHdrVision = HdrUtil.isBt2020PqExtensionSupported() && HdrUtil.isScreenSupportHdrVision();

    public static boolean is10BitLumaDepth(int transfer) {
        return transfer == VideoFrame.ColorSpace.Transfer.SMPTEST2084.getTransfer() || transfer == VideoFrame.ColorSpace.Transfer.ARIB_STD_B67.getTransfer();
    }

    public static boolean isNeedTransToSdrVision(int transfer) {
        return HdrUtil.is10BitLumaDepth(transfer) && !HdrUtil.isDisplayHdrVision(transfer);
    }

    public static boolean isSupportedEGL3() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return true;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return true;
        }
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        if (configurationInfo == null) {
            return true;
        }
        return configurationInfo.reqGlEsVersion >= 196608;
    }

    public static boolean isNeedTransToHdrVision(int transfer) {
        return !HdrUtil.is10BitLumaDepth(transfer) && HdrUtil.isDisplayHdrVision(transfer);
    }

    public static boolean isNeedHdrSdrTrans(int transfer) {
        return HdrUtil.isNeedTransToSdrVision(transfer) || HdrUtil.isNeedTransToHdrVision(transfer);
    }

    public static boolean isDisplayHdrVision(int transfer) {
        int transform = HdrUtil.nativeHdrSdrTransform();
        return isScreenSupportHdrVision && (HdrUtil.is10BitLumaDepth(transfer) && transform != 1 || transform == 2);
    }

    public static boolean isBt2020PqExtensionSupported() {
        String eglExtensions = null;
        if (Build.VERSION.SDK_INT >= 17) {
            EGLDisplay display = EGL14.eglGetDisplay((int)0);
            eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        }
        boolean supportedBt2020PqExtension = eglExtensions != null && eglExtensions.contains(EGL_EXT_GL_COLORSPACE_DISPLAY_P3) && eglExtensions.contains(EXTENSION_COLORSPACE_BT2020_PQ) && eglExtensions.contains(EGL_EXT_SURFACE_SMPTE2086_METADATA);
        Logging.i(TAG, "supportedBt2020PqExtension: " + supportedBt2020PqExtension);
        return supportedBt2020PqExtension;
    }

    public static boolean isScreenSupportHdrVision() {
        Display display;
        boolean supportsDolbyVision = false;
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT < 17) {
            return supportsDolbyVision;
        }
        if (context == null) {
            return true;
        }
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        Display display2 = display = displayManager != null ? displayManager.getDisplay(0) : null;
        if (Build.VERSION.SDK_INT >= 26 && display != null && display.isHdr()) {
            int[] supportedHdrTypes;
            for (int hdrType : supportedHdrTypes = display.getHdrCapabilities().getSupportedHdrTypes()) {
                if (hdrType != 2 && hdrType != 3 && hdrType != 4 && hdrType != 1) continue;
                supportsDolbyVision = true;
                break;
            }
        }
        Logging.i(TAG, "supportedDolbyVision: " + supportsDolbyVision);
        return supportsDolbyVision;
    }

    public static boolean CheckIs10bitTexture(int textureID, int width, int height, VideoFrame.TextureBuffer.Type type) {
        boolean is10bit = false;
        try {
            int[] oldFboId = new int[1];
            GLES20.glGetIntegerv((int)36006, (IntBuffer)IntBuffer.wrap(oldFboId));
            int[] framebuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])framebuffers, (int)0);
            int framebufferId = framebuffers[0];
            GLES20.glBindFramebuffer((int)36160, (int)framebufferId);
            int[] renderbuffers = new int[1];
            GLES20.glGenRenderbuffers((int)1, (int[])renderbuffers, (int)0);
            int renderId = renderbuffers[0];
            GLES20.glBindRenderbuffer((int)36161, (int)renderId);
            GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)(type == VideoFrame.TextureBuffer.Type.OES ? 36197 : 3553), (int)textureID, (int)0);
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)renderId);
            if (GLES20.glCheckFramebufferStatus((int)36160) != 36053) {
                is10bit = true;
            }
            GLES20.glDeleteRenderbuffers((int)1, (IntBuffer)IntBuffer.wrap(framebuffers));
            GLES20.glDeleteFramebuffers((int)1, (IntBuffer)IntBuffer.allocate(framebufferId));
            GLES20.glBindFramebuffer((int)36160, (int)oldFboId[0]);
            return is10bit;
        }
        catch (Exception e) {
            Logging.e(TAG, e.toString());
            return is10bit;
        }
    }

    public static native byte[] nativeGetLut10Buffer(int var0, boolean var1);

    public static native int nativeHdrSdrTransform();

    public static enum LumaBitDepth {
        Invalid(0),
        LUMA8BIT(1),
        LUMA10BIT(2);

        private final int depth;

        private LumaBitDepth(int lumaBitDepth) {
            this.depth = lumaBitDepth;
        }

        public int depth() {
            return this.depth;
        }
    }
}

