/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import androidx.annotation.Nullable;
import io.agora.base.JavaI010Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.YuvHelper;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class VideoFrameDrawer {
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    @Nullable
    private VideoFrame lastI420Frame;
    @Nullable
    private VideoFrame lastConvertFrame;
    @Nullable
    private VideoFrame lastI1010Frame;
    private final Matrix renderMatrix = new Matrix();

    public static void drawTexture(RendererCommon.GlDrawer drawer, VideoFrame.TextureBuffer buffer, int alphaTexture, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer, int alphaStitchMode) {
        TextureBufferPool.waitFenceSignal2(buffer.getFenceObject(), "VideoFrameDrawer");
        Matrix finalMatrix = new Matrix(buffer.getTransformMatrix());
        finalMatrix.preConcat(renderMatrix);
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(finalMatrix);
        switch (buffer.getType()) {
            case OES: {
                drawer.drawOes(buffer.getTextureId(), alphaTexture, finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, transfer, alphaStitchMode);
                break;
            }
            case RGB: {
                drawer.drawRgb(buffer.getTextureId(), alphaTexture, finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, transfer, alphaStitchMode);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    public static void drawTexture(RendererCommon.GlDrawer drawer, VideoFrame.TextureBuffer buffer, int alphaTexture, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int transfer) {
        VideoFrameDrawer.drawTexture(drawer, buffer, alphaTexture, renderMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, transfer, VideoFrame.AlphaStitchMode.ALPHA_NO_STITCH.value());
    }

    public void doLut10Frame(RendererCommon.GlDrawer drawer, byte[] data) {
        drawer.setLut10Texture(data);
    }

    private static int distance(float x0, float y0, float x1, float y1) {
        return (int)Math.round(Math.hypot(x1 - x0, y1 - y0));
    }

    private void calculateTransformedRenderSize(int frameWidth, int frameHeight, @Nullable Matrix renderMatrix) {
        if (renderMatrix == null) {
            this.renderWidth = frameWidth;
            this.renderHeight = frameHeight;
            return;
        }
        renderMatrix.mapPoints(this.dstPoints, srcPoints);
        for (int i = 0; i < 3; ++i) {
            int n = i * 2 + 0;
            this.dstPoints[n] = this.dstPoints[n] * (float)frameWidth;
            int n2 = i * 2 + 1;
            this.dstPoints[n2] = this.dstPoints[n2] * (float)frameHeight;
        }
        this.renderWidth = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
        this.renderHeight = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer) {
        this.drawFrame(frame, drawer, null);
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, Matrix additionalRenderMatrix) {
        this.drawFrame(frame, drawer, additionalRenderMatrix, 0, 0, frame.getRotatedWidth(), frame.getRotatedHeight(), false);
    }

    public void convertByDrawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int width = viewportWidth;
        int height = viewportHeight;
        this.calculateTransformedRenderSize(width, height, additionalRenderMatrix);
        boolean isTextureFrame = frame.getBuffer() instanceof VideoFrame.TextureBuffer;
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (!isTextureFrame) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate(0.0f);
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            this.renderMatrix.preConcat(additionalRenderMatrix);
        }
        int alphaTexture = 0;
        if (isTextureFrame) {
            VideoFrameDrawer.drawTexture(drawer, (VideoFrame.TextureBuffer)frame.getBuffer(), alphaTexture, this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight, frame.getColorSpace().getTransfer().getTransfer());
        } else {
            if (frame != this.lastConvertFrame) {
                this.lastConvertFrame = frame;
                VideoFrame.I420Buffer i420Buffer = frame.getBuffer().toI420();
                GLES20.glPixelStorei((int)3317, (int)1);
                this.yuvUploader.uploadFromBuffer(i420Buffer);
                i420Buffer.release();
            }
            drawer.drawYuv(this.yuvUploader.getYuvTextures(), alphaTexture, RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight, frame.getColorSpace(), frame.getColorSpace().getTransfer().getTransfer());
        }
    }

    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight, boolean enableAlphaMask) {
        int width = frame.getRotatedWidth();
        int height = frame.getRotatedHeight();
        this.calculateTransformedRenderSize(width, height, additionalRenderMatrix);
        boolean isTextureFrame = frame.getBuffer() instanceof VideoFrame.TextureBuffer;
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (!isTextureFrame) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)frame.getRotation());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            this.renderMatrix.preConcat(additionalRenderMatrix);
        }
        int alphaTexture = 0;
        if (isTextureFrame) {
            this.lastI420Frame = null;
            this.lastI1010Frame = null;
            if (frame.getAlphaBuffer() != null && enableAlphaMask) {
                alphaTexture = this.yuvUploader.uploadAlphaData(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getAlphaBuffer(), isTextureFrame);
            }
            VideoFrameDrawer.drawTexture(drawer, (VideoFrame.TextureBuffer)frame.getBuffer(), alphaTexture, this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight, frame.getColorSpace().getTransfer().getTransfer(), frame.getAlphaStitchMode());
        } else {
            if (frame.getBuffer() instanceof JavaI010Buffer && frame != this.lastI1010Frame) {
                this.lastI1010Frame = frame;
                JavaI010Buffer i1010Buffer = (JavaI010Buffer)frame.getBuffer();
                if (i1010Buffer != null) {
                    i1010Buffer.retain();
                    this.yuvUploader.uploadI1010FromBuffer(i1010Buffer);
                    i1010Buffer.release();
                }
            } else if (frame != this.lastI420Frame) {
                this.lastI420Frame = frame;
                VideoFrame.I420Buffer i420Buffer = frame.getBuffer().toI420();
                this.yuvUploader.uploadFromBuffer(i420Buffer);
                i420Buffer.release();
                if (frame.getAlphaBuffer() != null && enableAlphaMask) {
                    alphaTexture = this.yuvUploader.uploadAlphaData(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getAlphaBuffer(), isTextureFrame);
                }
            } else if (enableAlphaMask) {
                alphaTexture = this.yuvUploader.getAlphaTexture();
            }
            if (frame.getAlphaStitchMode() == VideoFrame.AlphaStitchMode.ALPHA_NO_STITCH.value()) {
                drawer.drawYuv(this.yuvUploader.getYuvTextures(), alphaTexture, RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight, frame.getColorSpace(), frame.getColorSpace().getTransfer().getTransfer());
            } else {
                drawer.drawAlphaStitchGraph(this.yuvUploader.getYuvTextures(), alphaTexture, RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight, frame.getColorSpace(), frame.getColorSpace().getTransfer().getTransfer(), frame.getAlphaStitchMode());
            }
        }
    }

    public void disableNegativeAlphaData() {
        if (this.yuvUploader != null) {
            this.yuvUploader.disableNegativeAlphaData();
        }
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
        this.lastI1010Frame = null;
        this.lastConvertFrame = null;
    }

    private static class YuvUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private ByteBuffer copyAlphaBuffer;
        @Nullable
        private int[] yuvTextures;
        private int alphaTexture = 0;
        private boolean enableNegativeAlphaData = true;

        private YuvUploader() {
        }

        public void disableNegativeAlphaData() {
            this.enableNegativeAlphaData = false;
        }

        public int getAlphaTexture() {
            return this.alphaTexture;
        }

        @Nullable
        public int[] uploadYuvData(int width, int height, int[] strides, ByteBuffer[] planes, boolean is8BitLumaDepth) {
            int i;
            int[] planeWidths = new int[]{width, width / 2, width / 2};
            int[] planeHeights = new int[]{height, height / 2, height / 2};
            int copyCapacityNeeded = 0;
            for (i = 0; i < 3; ++i) {
                if (strides[i] <= planeWidths[i]) continue;
                copyCapacityNeeded = is8BitLumaDepth ? Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i]) : Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i] * 2);
            }
            if (copyCapacityNeeded > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < copyCapacityNeeded)) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (i = 0; i < 3; ++i) {
                    this.yuvTextures[i] = GlUtil.generateTexture(3553);
                    GlUtil.checkNoGLES2Error("generateTexture");
                }
            }
            for (i = 0; i < 3; ++i) {
                ByteBuffer packedByteBuffer;
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[i]);
                if (strides[i] == planeWidths[i]) {
                    packedByteBuffer = planes[i];
                } else {
                    if (is8BitLumaDepth) {
                        YuvHelper.copyPlane(planes[i], strides[i], this.copyBuffer, planeWidths[i], planeWidths[i], planeHeights[i]);
                    } else {
                        YuvHelper.copyPlane16(planes[i], strides[i], this.copyBuffer, planeWidths[i], planeWidths[i], planeHeights[i]);
                    }
                    packedByteBuffer = this.copyBuffer;
                }
                if (is8BitLumaDepth) {
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)planeWidths[i], (int)planeHeights[i], (int)0, (int)6409, (int)5121, (Buffer)packedByteBuffer);
                } else {
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6410, (int)planeWidths[i], (int)planeHeights[i], (int)0, (int)6410, (int)5121, (Buffer)packedByteBuffer);
                }
                GlUtil.checkNoGLES2Error("glTexImage2D");
            }
            return this.yuvTextures;
        }

        public int uploadAlphaData(int width, int height, ByteBuffer alphaBuffer, boolean isTexture) {
            boolean needNegativeAlphaData;
            if (this.alphaTexture == 0) {
                this.alphaTexture = GlUtil.generateTexture(3553);
            }
            if (width <= 0 || height <= 0) {
                return 0;
            }
            int copyCapacityNeeded = width * height;
            boolean bl = needNegativeAlphaData = isTexture && this.enableNegativeAlphaData;
            if (needNegativeAlphaData) {
                if (this.copyAlphaBuffer == null || this.copyAlphaBuffer.capacity() < copyCapacityNeeded) {
                    this.copyAlphaBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
                }
                YuvHelper.copyPlane(alphaBuffer, width, this.copyAlphaBuffer, width, width, -height);
            }
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)this.alphaTexture);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6406, (int)width, (int)height, (int)0, (int)6406, (int)5121, (Buffer)(needNegativeAlphaData ? this.copyAlphaBuffer : alphaBuffer));
            return this.alphaTexture;
        }

        @Nullable
        public int[] uploadFromBuffer(VideoFrame.I420Buffer buffer) {
            int[] strides = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
            ByteBuffer[] planes = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
            return this.uploadYuvData(buffer.getWidth(), buffer.getHeight(), strides, planes, true);
        }

        @Nullable
        public int[] uploadI1010FromBuffer(JavaI010Buffer buffer) {
            int[] strides = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
            ByteBuffer[] planes = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
            return this.uploadYuvData(buffer.getWidth(), buffer.getHeight(), strides, planes, false);
        }

        @Nullable
        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            this.copyAlphaBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
            if (this.alphaTexture > 0) {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this.alphaTexture}, (int)0);
                this.alphaTexture = 0;
            }
        }
    }
}

