/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.VideoFrameMetaInfo;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.rtc2.video.CoordinatesTransform;
import io.agora.rtc2.video.FocalLengthInfo;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureCamera;
import io.agora.rtc2.video.VideoCaptureFactory;
import io.agora.rtc2.video.VideoCaptureFormat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

@TargetApi(value=23)
public class VideoCaptureCamera2
extends VideoCaptureCamera {
    private static final String TAG = VideoCaptureCamera2.class.getSimpleName();
    private ImageReader xiaomiReader;
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){
        private long mLastFocusedTs;

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            Long exposure_time_value = (Long)result.get(CaptureResult.SENSOR_EXPOSURE_TIME);
            if (exposure_time_value != null) {
                VideoCaptureCamera2.this.mLastExposureTimeNs = exposure_time_value;
            }
            if (VideoCaptureCamera2.this.mEnableAutoFaceFocus && VideoCaptureCamera2.this.isAutoFaceFocusSupported()) {
                this.process((CaptureResult)result);
            }
            if (VideoCaptureCamera2.this.mEnableFaceDetection) {
                this.notifyFaceDetection((Rect)result.get(CaptureResult.SCALER_CROP_REGION), (Face[])result.get(CaptureResult.STATISTICS_FACES));
            }
        }

        private void process(CaptureResult result) {
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            if (faces != null && faces.length > 0) {
                if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                    if (faces[0].getScore() > 20) {
                        Rect cropRegion = (Rect)result.get(CaptureResult.SCALER_CROP_REGION);
                        Rect rect = faces[0].getBounds();
                        if (rect != null && !rect.equals((Object)VideoCaptureCamera2.this.lastFocusAreaRect)) {
                            this.notifyCameraFocusAreaChanged(cropRegion, rect);
                        }
                        VideoCaptureCamera2.this.lastFocusAreaRect = rect;
                    }
                    return;
                }
                if (faces[0].getScore() <= 50) {
                    return;
                }
                Rect rect = VideoCaptureCamera2.this.clampFace(faces[0].getBounds());
                if (rect.width() <= 0 || rect.height() <= 0) {
                    return;
                }
                this.addRegionsToCaptureRequestBuilder(VideoCaptureCamera2.this.mPreviewRequestBuilder, new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
                if (VideoCaptureCamera2.this.mCameraState != 2) {
                    return;
                }
                try {
                    Rect cropRegion = (Rect)result.get(CaptureResult.SCALER_CROP_REGION);
                    Logging.d(TAG, "cropRegion = " + cropRegion);
                    Logging.d(TAG, "capture size wxh = " + VideoCaptureCamera2.this.mCaptureFormat.getWidth() + " x " + VideoCaptureCamera2.this.mCaptureFormat.getHeight());
                    this.notifyCameraFocusAreaChanged(cropRegion, rect);
                    VideoCaptureCamera2.this.mPreviewSession.capture(VideoCaptureCamera2.this.mPreviewRequestBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, null);
                }
                catch (Exception ex) {
                    Logging.e(TAG, "capture: " + ex);
                    return;
                }
                VideoCaptureCamera2.this.createCaptureRequest();
                this.mLastFocusedTs = System.currentTimeMillis();
            }
        }

        private void notifyCameraFocusAreaChanged(Rect cropRegion, Rect faceRect) {
            RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(faceRect), cropRegion.width(), cropRegion.height(), VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, true);
            if ((translated = CoordinatesTransform.normalizedToView(translated, VideoCaptureCamera2.this.mRenderView.getWidth(), VideoCaptureCamera2.this.mRenderView.getHeight(), VideoCaptureCamera2.this.mCaptureFormat.getWidth(), VideoCaptureCamera2.this.mCaptureFormat.getHeight(), VideoCaptureCamera2.this.mId == 1, (VideoCaptureCamera2.this.mId == 1 ? 1 : -1) * VideoCaptureCamera2.this.getCameraRotation(), VideoCaptureCamera2.this.mRenderMode)) == null) {
                Logging.w(TAG, "Failed to translate coordinate from normalized to view!!");
                return;
            }
            Rect rect = new Rect();
            translated.round(rect);
            VideoCaptureCamera2.this.notifyCameraFocusAreaChanged(rect);
        }

        private void notifyFaceDetection(Rect cropRegion, Face[] faces) {
            ArrayList<RectF> rectArray = new ArrayList<RectF>();
            ArrayList<Double> distanceArray = new ArrayList<Double>();
            for (Face face : faces) {
                RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(face.getBounds()), cropRegion.width(), cropRegion.height(), VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, true);
                if (translated == null) continue;
                distanceArray.add(VideoCaptureCamera2.this.mId == 1 ? 11.237 * Math.pow(translated.width(), -0.958) : 14.719 * Math.pow(translated.height(), -0.971));
                translated = CoordinatesTransform.normalizedToView(translated, VideoCaptureCamera2.this.mRenderView.getWidth(), VideoCaptureCamera2.this.mRenderView.getHeight(), VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, VideoCaptureCamera2.this.mId == 1, (VideoCaptureCamera2.this.mId == 1 ? 1 : -1) * VideoCaptureCamera2.this.getCameraRotation(), VideoCaptureCamera2.this.mRenderMode);
                if (translated == null) {
                    distanceArray.remove(distanceArray.size() - 1);
                    continue;
                }
                rectArray.add(translated);
            }
            if (rectArray.isEmpty()) {
                return;
            }
            VideoCaptureCamera2.this.notifyFaceDetection(VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, rectArray, distanceArray);
        }

        private void addRegionsToCaptureRequestBuilder(CaptureRequest.Builder builder, MeteringRectangle[] regions) {
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            builder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)regions);
            builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)regions);
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (null == afState) {
                return;
            }
            if (4 == afState || 5 == afState) {
                VideoCaptureCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                VideoCaptureCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                VideoCaptureCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                try {
                    VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(VideoCaptureCamera2.this.mPreviewRequestBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, VideoCaptureCamera2.this.mCameraThreadHandler);
                }
                catch (CameraAccessException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (SecurityException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (NoClassDefFoundError e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };
    private static int IMAGE_FORMAT = 35;
    private static final double kNanosecondsPerSecond = 1.0E9;
    private static final long kNanosecondsPer100Microsecond = 100000L;
    private static final String[] AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST = new String[]{"Pixel 3", "Pixel 3 XL", "SDM845"};
    private static final SparseIntArray COLOR_TEMPERATURES_MAP = new SparseIntArray();
    static Map<Integer, CameraCharacteristics> cameraCharacteristicMaps;
    private final Object mSwitchLock = new Object();
    private final Object mCameraStateLock = new Object();
    private final Object mImageReaderLock = new Object();
    @Nullable
    private String mCameraId;
    @Nullable
    private String mPhysicalId;
    @Nullable
    private CameraDevice mCameraDevice;
    @Nullable
    private CameraCaptureSession mPreviewSession;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    @Nullable
    private Surface mSurface;
    private ImageReader mImageReader;
    private Handler mCameraThreadHandler;
    private ThreadUtils.ConditionVariable mWaitForDeviceClosedConditionVariable = new ThreadUtils.ConditionVariable();
    private Range<Integer> mAeFpsRange;
    private int mCameraState = 4;
    private float mMaxZoom = 1.0f;
    private Rect mCropRect = new Rect();
    private int mFocusMode = 4;
    private float mCurrentFocusDistance = 1.0f;
    private int mExposureMode = 4;
    private long mLastExposureTimeNs;
    private MeteringRectangle mAreaOfInterest;
    private int mColorTemperature = -1;
    private int mIso;
    private boolean mRedEyeReduction;
    private int mFillLightMode = 1;
    private ThreadUtils.ThreadChecker mThreadChecker;
    private static final float ZOOM_UNSUPPORTED_DEFAULT_VALUE = 0.5f;
    private static final float DEFAULT_VALUE = -1.0f;
    private float mLastZoomRatio = -1.0f;
    private Rect mSensorRect = null;
    private boolean mFaceDetectSupported = false;
    private int mFaceDetectMode;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_LEGACY = 1;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_EXTERNAL = 2;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_LIMITED = 3;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_FULL = 4;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_3 = 5;
    static final int ANDROID_CAMERA_HARDWARE_NOT_SUPPORT = Integer.MIN_VALUE;
    static final SparseIntArray ANDROID_CAMERA_HARDWARE_LEVEL_MAP;

    Rect clampFace(Rect rect) {
        return new Rect(CoordinatesTransform.clamp(rect.left, 0, rect.right), CoordinatesTransform.clamp(rect.top, 0, rect.bottom), CoordinatesTransform.clamp(rect.right, 0, rect.right), CoordinatesTransform.clamp(rect.bottom, 0, rect.bottom));
    }

    static int getCamera2SupportedLevel(int index) {
        if (Build.VERSION.SDK_INT < 21) {
            return 2;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return 2;
        }
        Integer ret = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (ret == null) {
            Logging.w(TAG, "get camera hardware level fail!");
            return 2;
        }
        return ret;
    }

    static boolean getCamera2SupportedAutoFocus(int index) {
        boolean autoFocus;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return false;
        }
        int[] availableFocusModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (availableFocusModes == null) {
            return false;
        }
        for (int fdMode : availableFocusModes) {
            Logging.i(TAG, "Auto-focus mode: " + fdMode);
        }
        boolean bl = autoFocus = VideoCaptureCamera2.isSupported(3, availableFocusModes) || VideoCaptureCamera2.isSupported(4, availableFocusModes);
        if (!autoFocus) {
            Logging.i(TAG, "Auto-focus is not available.");
        }
        return autoFocus;
    }

    static boolean getCamera2SupportedNoise(int index) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        String cameraId = VideoCaptureCamera2.indexConvertCameraId(index);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(cameraId);
        if (cameraCharacteristics == null) {
            return false;
        }
        int[] noiseReductionModes = (int[])cameraCharacteristics.get(CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES);
        Logging.i(TAG, "noise_reduction_mode_high_quality supported: " + VideoCaptureCamera2.isSupported(2, noiseReductionModes));
        boolean supported = VideoCaptureCamera2.isSupported(1, noiseReductionModes);
        Logging.i(TAG, "noise_reduction_mode_fast supported: " + supported);
        return supported;
    }

    static int getCamera2SupportedFaceDetect(int index) {
        if (Build.VERSION.SDK_INT < 21) {
            return 0;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return 0;
        }
        boolean faceDetectSupported = false;
        int faceDetectMode = 0;
        int[] availableFDModes = (int[])cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        Integer maxFDCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (availableFDModes != null && availableFDModes.length > 1 && maxFDCount != null && maxFDCount > 0) {
            faceDetectSupported = true;
            int modeSum = 0;
            for (int fdMode : availableFDModes) {
                Logging.d(TAG, "fdMode: " + fdMode);
                modeSum += fdMode;
            }
            faceDetectMode = modeSum % 2 != 0 ? 1 : 2;
        }
        Logging.i(TAG, "faceDetectSupported: " + faceDetectSupported + " ,faceDetectMode: " + faceDetectMode);
        return faceDetectMode;
    }

    @Nullable
    private static CameraCharacteristics getCameraCharacteristics(int index) {
        CameraCharacteristics cameraCharacteristics;
        boolean cacheNumbers = VideoCaptureFactory.ChromiumCameraInfo.getCameraCacheNumbers();
        if (cacheNumbers && (cameraCharacteristics = cameraCharacteristicMaps.get(index)) != null) {
            return cameraCharacteristics;
        }
        if (ContextUtils.getApplicationContext() == null) {
            return null;
        }
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        if (manager == null) {
            return null;
        }
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (index >= cameraIdList.length) {
                Logging.i(TAG, "physical camera Index: " + index);
            }
            cameraCharacteristics = manager.getCameraCharacteristics(cameraIdList[index]);
            if (cacheNumbers) {
                cameraCharacteristicMaps.put(index, cameraCharacteristics);
            }
            return cameraCharacteristics;
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (AssertionError ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ((Throwable)((Object)ex)).getMessage());
        }
        catch (Exception ex) {
            Logging.e(TAG, "getNumberOfCameras: got exception: " + ex);
        }
        return null;
    }

    @Nullable
    private static CameraCharacteristics getCameraCharacteristics(String cameraId) {
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (cameraIdList.length == 0) {
                return null;
            }
            boolean foundCamera = false;
            for (String id : cameraIdList) {
                if (!id.contains(cameraId)) continue;
                foundCamera = true;
                break;
            }
            if (!foundCamera) {
                Logging.i(TAG, "physical cameraId: " + cameraId);
            }
            return manager.getCameraCharacteristics(cameraId);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (AssertionError ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ((Throwable)((Object)ex)).getMessage());
        }
        catch (Exception ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        return null;
    }

    private void createPreviewObjectsAndStartPreviewOrFailWith(int androidVideoCaptureError) {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mCaptureToTexture ? this.createTexturePreviewObjectsAndStartPreview() : this.createBufferPreviewObjectsAndStartPreview()) {
            return;
        }
        this.changeCameraStateAndNotify(4);
        this.onError(androidVideoCaptureError, "Error starting or restarting preview");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private boolean createBufferPreviewObjectsAndStartPreview() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mCameraDevice == null) {
            return false;
        }
        Object object = this.mImageReaderLock;
        synchronized (object) {
            this.mImageReader = ImageReader.newInstance((int)this.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)this.mCaptureFormat.getPixelFormat(), (int)2);
            CrPreviewReaderListener imageReaderListener = new CrPreviewReaderListener();
            try {
                this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)imageReaderListener, this.mCameraThreadHandler);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "setOnImageAvailableListener error", e);
            }
        }
        return this.createPreviewObjectsAndStartPreview(this.mImageReader.getSurface());
    }

    private boolean createTexturePreviewObjectsAndStartPreview() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mCameraDevice == null || this.mSurfaceTextureHelper == null) {
            return false;
        }
        try {
            this.mSurfaceTextureHelper.setTextureSize(this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight());
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "setTextureSize:", ex);
            return false;
        }
        this.mSurface = new Surface(this.mSurfaceTextureHelper.getSurfaceTexture());
        TextureVideoSinkListener textureVideoSinkListener = new TextureVideoSinkListener();
        this.mSurfaceTextureHelper.startListening(textureVideoSinkListener);
        return this.createPreviewObjectsAndStartPreview(this.mSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createPreviewObjectsAndStartPreview(Surface surface) {
        try {
            int templateType = this.mCameraTemplateType == 0 ? 1 : 3;
            Logging.i(TAG, "createCaptureRequest templateType: " + (this.mCameraTemplateType == 0 ? "preview" : "record"));
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(templateType);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "createCaptureRequest: " + ex.getMessage());
            return false;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "createCaptureRequest: " + ex.getMessage());
            return false;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "createCaptureRequest: " + ex.getMessage());
            return false;
        }
        if (this.mPreviewRequestBuilder == null) {
            Logging.e(TAG, "mPreviewRequestBuilder error");
            return false;
        }
        this.mPreviewRequestBuilder.addTarget(surface);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        this.configureCommonCaptureSettings(this.mPreviewRequestBuilder);
        if (this.mEnableFaceDetection || this.mCameraAutoFaceFocus) {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)1);
        }
        this.requestFaceDetection(this.mPreviewRequestBuilder, this.mFaceDetectMode);
        if (!this.mIsCameraTorchStarted && this.mTorchMode != 0) {
            this.setTorchMode(this.mTorchMode == 1);
        }
        if (!this.mIsmCameraExposureStarted && this.mCameraExposurePositions[0] > 0.0f && this.mCameraExposurePositions[1] > 0.0f) {
            this.setExposure(this.mCameraExposurePositions[0], this.mCameraExposurePositions[1]);
        }
        if (!this.mIsmCameraFocusStarted && this.mCameraFocusPositions[0] > 0.0f && this.mCameraFocusPositions[1] > 0.0f) {
            this.setFocus(this.mCameraFocusPositions[0], this.mCameraFocusPositions[1]);
        }
        if (!this.mIsmCameraZoomStarted && this.mCameraZoomFactor > 0.0f) {
            this.setZoom(this.mCameraZoomFactor);
        }
        if (!this.mIsExposureCompensationStarted && this.mCameraExposureCompensation != 0) {
            this.setExposureCompensation(this.mCameraExposureCompensation);
        }
        if (!this.mIsNoiseReducationStarted && this.mCameraNoiseReduction != 0) {
            this.setNoiseReductionMode(this.mCameraNoiseReduction);
        }
        if (!this.mAutoFaceDetectFocusStarted && this.mCameraAutoFaceFocus) {
            this.setAutoFaceFocus(this.mCameraAutoFaceFocus);
        }
        List<Surface> surfaces = null;
        if (this.mCameraExtraSurface || Build.MODEL.equalsIgnoreCase("redmi note 8") || Build.MODEL.equalsIgnoreCase("redmi note 8 pro")) {
            Object object = this.mImageReaderLock;
            synchronized (object) {
                this.xiaomiReader = ImageReader.newInstance((int)this.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)this.mCaptureFormat.getPixelFormat(), (int)2);
            }
            surfaces = Arrays.asList(surface, this.xiaomiReader.getSurface());
            Logging.e(TAG, "createCaptureSession add extra surface.");
        } else {
            surfaces = Collections.singletonList(surface);
        }
        try {
            this.mCameraDevice.createCaptureSession(surfaces, (CameraCaptureSession.StateCallback)new CrPreviewSessionListener(), null);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "createCaptureSession: " + ex.getMessage());
            return false;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "createCaptureSession: " + ex.getMessage());
            return false;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "createCaptureSession: " + ex.getMessage());
            return false;
        }
        catch (NoClassDefFoundError e) {
            Logging.e(TAG, "createCaptureSession: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isSupportedFocusMode(CameraCharacteristics cameraCharacteristics, int focusMode) {
        if (cameraCharacteristics == null) {
            return false;
        }
        int[] availableFocusModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (availableFocusModes == null) {
            return false;
        }
        for (int mode : availableFocusModes) {
            Logging.i(TAG, "availableFocusModes: " + mode);
            if (mode != focusMode) continue;
            return true;
        }
        Logging.i(TAG, "Auto-focus is not available.");
        return false;
    }

    private void configureCommonCaptureSettings(CaptureRequest.Builder requestBuilder) {
        this.mThreadChecker.checkIsOnValidThread();
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return;
        }
        if (this.mFocusMode == 4) {
            if (this.isSupportedFocusMode(cameraCharacteristics, 3) && (this.mCameraFocusMode == 2 || this.mCameraFocusMode == 1)) {
                requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            } else if (this.isSupportedFocusMode(cameraCharacteristics, 4) && (this.mCameraFocusMode == 3 || this.mCameraFocusMode == 1)) {
                requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            }
            requestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        } else if (this.mFocusMode == 2) {
            requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            requestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            requestBuilder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(1.0f / this.mCurrentFocusDistance));
        }
        if (this.mExposureMode == 1 || this.mExposureMode == 2) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)0);
            if (this.mLastExposureTimeNs != 0L) {
                requestBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)(this.mLastExposureTimeNs / 100000L));
            } else if (cameraCharacteristics != null) {
                Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
                requestBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)(((Long)range.getLower() + ((Long)range.getUpper() + (Long)range.getLower()) / 2L) / 100000L));
            }
        } else {
            requestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            if (!VideoCaptureCamera2.shouldSkipSettingAeTargetFpsRange()) {
                requestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mAeFpsRange);
            }
        }
        if (this.mIsCameraTorchStarted) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)(this.mExposureMode == 4 ? 1 : 0));
            requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
        } else {
            switch (this.mFillLightMode) {
                case 1: {
                    requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                case 2: {
                    requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)(this.mRedEyeReduction ? 4 : 2));
                    break;
                }
                case 3: {
                    requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                    requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
                    break;
                }
            }
            requestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
        }
        if (this.mColorTemperature > 0) {
            int colorSetting = -1;
            if (cameraCharacteristics != null) {
                colorSetting = VideoCaptureCamera2.getClosestWhiteBalance(this.mColorTemperature, (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES));
            }
            Logging.d(TAG, String.format(Locale.US, " Color temperature (%d ==> %d)", this.mColorTemperature, colorSetting));
            if (colorSetting != -1) {
                requestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)colorSetting);
            }
        }
        int[] whiteBalanceModes = null;
        if (cameraCharacteristics != null) {
            whiteBalanceModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        }
        if (whiteBalanceModes != null && whiteBalanceModes.length > 0) {
            Logging.i(TAG, "Camera " + this.mCameraId + " supports white balance, " + Arrays.toString(whiteBalanceModes));
            if (this.mCameraAutoWhiteBalance && VideoCaptureCamera2.isSupported(1, whiteBalanceModes)) {
                requestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
            }
        } else {
            Logging.i(TAG, "Camera " + this.mCameraId + " does not support white balance");
        }
        if (this.mAreaOfInterest != null) {
            MeteringRectangle[] array = new MeteringRectangle[]{this.mAreaOfInterest};
            Logging.i(TAG, String.format(Locale.US, "Area of interest %s", this.mAreaOfInterest.toString()));
            requestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)array);
            requestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)array);
            requestBuilder.set(CaptureRequest.CONTROL_AWB_REGIONS, (Object)array);
        }
        if (!this.mCropRect.isEmpty()) {
            requestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.mCropRect);
        }
        if (this.mIso > 0) {
            requestBuilder.set(CaptureRequest.SENSOR_SENSITIVITY, (Object)this.mIso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(int state) {
        Logging.i(TAG, "changeCameraStateAndNotify() " + state);
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = state;
            this.mCameraStateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFaceDetection(CaptureRequest.Builder requestBuilder, int faceDetectMode) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                Logging.w(TAG, "face detect not ready");
                return;
            }
            if (requestBuilder == null) {
                Logging.e(TAG, "face detect requestBuilder error");
                return;
            }
            if (!this.mFaceDetectSupported) {
                Logging.w(TAG, "face detect not supported");
                return;
            }
        }
        if (this.mEnableAutoFaceFocus || this.mEnableFaceDetection) {
            if (faceDetectMode != 0 && !this.mIsFaceDetectionStarted) {
                this.mIsFaceDetectionStarted = true;
                Logging.i(TAG, "requestFaceDetection = " + faceDetectMode);
                requestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)faceDetectMode);
            } else if (faceDetectMode == 0) {
                this.mIsFaceDetectionStarted = false;
                Logging.i(TAG, "requestFaceDetection = 0");
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                this.mPerFrameFaceDetectionInfoQueue.clear();
            }
        }
    }

    private static boolean shouldSkipSettingAeTargetFpsRange() {
        for (String buggyDevice : AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST) {
            if (!Build.MODEL.contains(buggyDevice)) continue;
            return true;
        }
        return false;
    }

    private static int findInIntArray(int[] hayStack, int needle) {
        for (int i = 0; i < hayStack.length; ++i) {
            if (needle != hayStack[i]) continue;
            return i;
        }
        return -1;
    }

    private static int getClosestWhiteBalance(int colorTemperature, int[] supportedTemperatures) {
        int minDiff = Integer.MAX_VALUE;
        int matchedTemperature = -1;
        for (int i = 0; i < COLOR_TEMPERATURES_MAP.size(); ++i) {
            int diff;
            if (VideoCaptureCamera2.findInIntArray(supportedTemperatures, COLOR_TEMPERATURES_MAP.valueAt(i)) == -1 || (diff = Math.abs(colorTemperature - COLOR_TEMPERATURES_MAP.keyAt(i))) >= minDiff) continue;
            minDiff = diff;
            matchedTemperature = COLOR_TEMPERATURES_MAP.valueAt(i);
        }
        return matchedTemperature;
    }

    public static boolean isLegacyDevice(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.indexConvertCameraId(index));
        return cameraCharacteristics != null && VideoCaptureCamera2.getCamera2SupportedLevel(index) == 2;
    }

    public static int getNumberOfCameras() {
        CameraIdListTask listTask = new CameraIdListTask();
        if (listTask.getCameraIdList() == null) {
            return 0;
        }
        return listTask.getCameraIdList().length;
    }

    public static int getCaptureApiType(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.indexConvertCameraId(index));
        if (cameraCharacteristics == null) {
            return 11;
        }
        int supportedHWLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (supportedHWLevel == 2) {
            return 7;
        }
        int[] capabilities = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean backwardCompatible = false;
        for (int cap : capabilities) {
            if (cap != 0) continue;
            backwardCompatible = true;
            break;
        }
        if (!backwardCompatible) {
            return 11;
        }
        switch (supportedHWLevel) {
            case 1: {
                return 8;
            }
            case 0: {
                return 9;
            }
        }
        return 7;
    }

    public static int getFacingMode(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.indexConvertCameraId(index));
        if (cameraCharacteristics == null) {
            return 0;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        switch (facing) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    @Nullable
    public static String getName(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.indexConvertCameraId(index));
        if (cameraCharacteristics == null) {
            Logging.e(TAG, "getName: " + index + " , failed to getCameraCharacteristics.");
            return null;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        String facing_string = null;
        switch (facing) {
            case 0: {
                facing_string = "front";
                break;
            }
            case 1: {
                facing_string = "back";
                break;
            }
            case 2: {
                facing_string = "extra";
                break;
            }
            default: {
                Logging.e(TAG, "Invalid camera facing value, and fallback to back: " + facing);
                facing_string = "back";
            }
        }
        return "camera2 " + index + ", facing " + facing_string;
    }

    @Nullable
    static String getDeviceId(int index) {
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (index >= cameraIdList.length) {
                Logging.e(TAG, "Invalid camera index: " + index);
            }
            return cameraIdList[index];
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "manager.getCameraIdList: " + (Object)((Object)ex));
            return null;
        }
        catch (Exception ex) {
            Logging.e(TAG, "manager.getCameraIdList: " + ex);
            return null;
        }
    }

    @Nullable
    static List<VideoCaptureFormat> getDeviceSupportedFormats(int index) {
        Logging.i(TAG, "getDeviceSupportedFormats() " + index);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(VideoCaptureCamera2.indexConvertCameraId(index));
        if (cameraCharacteristics == null) {
            return null;
        }
        return VideoCaptureCamera2.getFormatsFromParemeters(cameraCharacteristics, IMAGE_FORMAT);
    }

    @NonNull
    private static List<VideoCaptureFormat> getFormatsFromParemeters(@NonNull CameraCharacteristics cameraCharacteristics, int filterImageForamt) {
        int[] capabilities = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean minFrameDurationAvailable = false;
        for (int cap : capabilities) {
            if (cap != 1) continue;
            minFrameDurationAvailable = true;
            break;
        }
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        try {
            int[] formats;
            StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            for (int format : formats = streamMap.getOutputFormats()) {
                Size[] sizes;
                if (format != filterImageForamt || (sizes = streamMap.getOutputSizes(format)) == null) continue;
                for (Size size : sizes) {
                    long minFrameDurationInNanoseconds;
                    if (VideoCaptureCamera2.shouldExcludeSize(size.getWidth(), size.getHeight())) continue;
                    double minFrameRate = 0.0;
                    int defaultFPS = 30;
                    minFrameRate = minFrameDurationAvailable ? ((minFrameDurationInNanoseconds = streamMap.getOutputMinFrameDuration(format, size)) == 0L ? (double)defaultFPS : 1.0E9 / (double)minFrameDurationInNanoseconds) : (double)defaultFPS;
                    formatList.add(new VideoCaptureFormat(size.getWidth(), size.getHeight(), (int)minFrameRate, format));
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to catch device supported video formats: ", e);
        }
        return formatList;
    }

    VideoCaptureCamera2(int index, long nativeVideoCaptureAndroid, boolean captureToTexture, boolean enableTextureCopy, int captureTextureBufferCount, boolean pqFirst, int skipControl, EglBase.Context sharedContext, int templateType, int noiseReduction, int focusMode, boolean autoFaceDetect, boolean extraSurface, boolean autoWhiteBalance, boolean fpsRangeEnable, int focalLengthType, int physicalId, boolean enableRefocus) {
        super(index, nativeVideoCaptureAndroid, captureToTexture, enableTextureCopy, captureTextureBufferCount, pqFirst, skipControl, sharedContext, templateType, noiseReduction, focusMode, autoFaceDetect, extraSurface, autoWhiteBalance, fpsRangeEnable, focalLengthType, physicalId, enableRefocus);
        HandlerThread thread = new HandlerThread("VideoCaptureCamera2_CameraThread");
        thread.start();
        if (physicalId >= 0) {
            this.mPhysicalId = physicalId + "";
        }
        this.mCameraThreadHandler = new Handler(thread.getLooper());
        this.mThreadChecker = new ThreadUtils.ThreadChecker((Thread)thread);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics != null) {
            this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        }
        if (this.mSkipControl == 1) {
            this.mExposureMode = 1;
        }
        if (this.mSkipControl == 2) {
            this.mFocusMode = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCameraAvailable(String cameraId) {
        Logging.i(TAG, "onCameraAvailable " + cameraId + " mCameraId: " + this.mCameraId);
        if (!cameraId.equals(this.mCameraId)) {
            return;
        }
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState != 3) {
                Logging.i(TAG, "onCameraAvailable, Wrong state " + this.mCameraState);
                return;
            }
        }
        this.onAvailable(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCameraUnavailable(String cameraId) {
        if (!cameraId.equals(this.mCameraId)) {
            return;
        }
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState != 3) {
                Logging.i(TAG, "onCameraUnavailable, Wrong state " + this.mCameraState);
                return;
            }
        }
        this.onAvailable(1);
    }

    @VisibleForTesting
    Handler getCameraThreadHandler() {
        return this.mCameraThreadHandler;
    }

    @VisibleForTesting
    public void setCameraThreadHandler() {
        HandlerThread thread = new HandlerThread("VideoCaptureCamera2_CameraThread");
        thread.start();
        this.mCameraThreadHandler = new Handler(thread.getLooper());
        this.mThreadChecker = new ThreadUtils.ThreadChecker((Thread)thread);
    }

    public void finalize() {
        if (this.mCameraThreadHandler != null) {
            this.mCameraThreadHandler.removeCallbacksAndMessages(null);
            this.mCameraThreadHandler.getLooper().quitSafely();
            this.mCameraThreadHandler = null;
        }
    }

    @Override
    public boolean needFallback() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocate(@NonNull VideoCaptureFormat req) {
        Logging.i(TAG, String.format(Locale.US, "allocate: requested (%d x %d) @%dfps", req.getWidth(), req.getHeight(), req.getFramerate()));
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState == 0 || this.mCameraState == 1) {
                Logging.e(TAG, "allocate() invoked while Camera is busy opening/configuring.");
                return false;
            }
        }
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.e(TAG, "failed to getCameraCharacteristics.");
            return false;
        }
        List<VideoCaptureFormat> formatList = VideoCaptureCamera2.getFormatsFromParemeters(cameraCharacteristics, IMAGE_FORMAT);
        Logging.i(TAG, "format list: " + Arrays.toString(formatList.toArray()));
        this.mCaptureFormat = VideoCaptureCamera2.FindBestMatchedCapability(formatList, req);
        if (this.mCaptureFormat == null) {
            Logging.e(TAG, "failed to match capability");
            return false;
        }
        List<Object> fpsRanges = Arrays.asList((Object[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES));
        Logging.i(TAG, "fpsRanges: " + Arrays.toString(fpsRanges.toArray()));
        if (fpsRanges.isEmpty()) {
            Logging.e(TAG, "No supported framerate ranges.");
            return false;
        }
        ArrayList<VideoCapture.FramerateRange> framerateRanges = new ArrayList<VideoCapture.FramerateRange>(fpsRanges.size());
        int fpsUnitFactor = (Integer)((Range)fpsRanges.get(0)).getUpper() > 1000 ? 1 : 1000;
        for (Range range : fpsRanges) {
            framerateRanges.add(new VideoCapture.FramerateRange((Integer)range.getLower() * fpsUnitFactor, (Integer)range.getUpper() * fpsUnitFactor));
        }
        VideoCapture.FramerateRange aeFramerateRange = VideoCaptureCamera2.findBestFrameRateRange(framerateRanges, this.mCaptureFormat.getFramerate() * 1000, this.mPQFirst);
        if (aeFramerateRange == null) {
            Logging.e(TAG, "No matched framerate ranges.");
            return false;
        }
        float f = 0.0f;
        float[] focalLengths = (float[])cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        if (focalLengths != null && focalLengths.length > 0) {
            f = focalLengths[0];
            for (float f2 : focalLengths) {
                f = Math.min(f2, f);
            }
        }
        this.mAeFpsRange = new Range((Comparable)Integer.valueOf(aeFramerateRange.min / fpsUnitFactor), (Comparable)Integer.valueOf(aeFramerateRange.max / fpsUnitFactor));
        Logging.i(TAG, String.format(Locale.US, "allocate: matched (%d x %d) @[%d - %d], %dmm", this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mAeFpsRange.getLower(), this.mAeFpsRange.getUpper(), (int)(10.0f * f)));
        this.mCameraNativeOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mInvertDeviceOrientationReadings = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
        int[] availableFDModes = (int[])cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        Integer maxFDCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (availableFDModes != null && availableFDModes.length > 1 && maxFDCount != null && maxFDCount > 0) {
            this.mFaceDetectSupported = true;
            int modeSum = 0;
            for (int fdMode : availableFDModes) {
                modeSum += fdMode;
            }
            this.mFaceDetectMode = modeSum % 2 != 0 ? 1 : 2;
        }
        Logging.i(TAG, "allocate() face detection: " + this.mFaceDetectMode + " " + maxFDCount + " " + this.mFaceDetectSupported);
        return true;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        Logging.i(TAG, "startCaptureMaybeAsync, use Texture: " + this.mCaptureToTexture);
        this.changeCameraStateAndNotify(0);
        if (ContextUtils.getApplicationContext() == null || this.mProxyThreadHandler == null) {
            Logging.w(TAG, "context or proxyThread unavailable");
            return false;
        }
        final CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        if (manager == null) {
            return false;
        }
        final CrStateListener stateListener = new CrStateListener();
        this.notifyInjector((Object)stateListener);
        try {
            Boolean openCamera = ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, 2000L, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean physicalCameraInVaild = false;
                    try {
                        String[] cameraIdList = manager.getCameraIdList();
                        if (VideoCaptureCamera2.this.mPhysicalId != null) {
                            Logging.i(TAG, "allocate openCamera camera name:" + VideoCaptureCamera2.this.mPhysicalId);
                            manager.openCamera(VideoCaptureCamera2.this.mPhysicalId, (CameraDevice.StateCallback)stateListener, VideoCaptureCamera2.this.mCameraThreadHandler);
                            VideoCaptureCamera2.this.mCameraId = VideoCaptureCamera2.this.mPhysicalId;
                        } else {
                            if (VideoCaptureCamera2.this.mId >= cameraIdList.length) {
                                Logging.e(TAG, "Invalid camera Id: " + VideoCaptureCamera2.this.mId);
                                return false;
                            }
                            Logging.i(TAG, "allocate openCamera: " + VideoCaptureCamera2.this.mId + " camera name:" + cameraIdList[VideoCaptureCamera2.this.mId]);
                            manager.openCamera(cameraIdList[VideoCaptureCamera2.this.mId], (CameraDevice.StateCallback)stateListener, VideoCaptureCamera2.this.mCameraThreadHandler);
                            VideoCaptureCamera2.this.mCameraId = cameraIdList[VideoCaptureCamera2.this.mId];
                        }
                    }
                    catch (CameraAccessException ex) {
                        Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
                        if (VideoCaptureCamera2.this.mPhysicalId == null) {
                            return false;
                        }
                        physicalCameraInVaild = true;
                    }
                    catch (IllegalArgumentException ex) {
                        Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
                        if (VideoCaptureCamera2.this.mPhysicalId == null) {
                            return false;
                        }
                        physicalCameraInVaild = true;
                    }
                    catch (SecurityException ex) {
                        Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
                        if (VideoCaptureCamera2.this.mPhysicalId == null) {
                            return false;
                        }
                        physicalCameraInVaild = true;
                    }
                    if (physicalCameraInVaild && !VideoCaptureCamera2.this.physicalFallback(manager, stateListener)) {
                        return false;
                    }
                    return true;
                }
            });
            if (openCamera == null || !openCamera.booleanValue()) {
                this.changeCameraStateAndNotify(4);
                return false;
            }
            this.registerCameraAvailableCallback(manager);
            return openCamera;
        }
        catch (Exception e) {
            this.changeCameraStateAndNotify(4);
            return false;
        }
    }

    private boolean physicalFallback(CameraManager manager, CrStateListener stateListener) {
        try {
            this.mPhysicalId = null;
            Logging.d(TAG, "allocate physical camera failure, try logical camera.");
            String[] cameraIdList = manager.getCameraIdList();
            if (this.mId >= cameraIdList.length) {
                Logging.e(TAG, "Invalid camera Id: " + this.mId);
                return false;
            }
            Logging.d(TAG, "allocate open logicalCamera: " + this.mId + " camera name:" + cameraIdList[this.mId]);
            manager.openCamera(cameraIdList[this.mId], (CameraDevice.StateCallback)stateListener, this.mCameraThreadHandler);
            this.mCameraId = cameraIdList[this.mId];
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
            return false;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
            return false;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCaptureAndBlockUntilStopped() {
        Logging.i(TAG, "stopCaptureAndBlockUntilStopped()");
        this.unRegisterAvailabilityCallback();
        if (null == this.mProxyThreadHandler) {
            Logging.w(TAG, "proxyThread unavailable");
            return;
        }
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.mProxyThreadHandler, 2000L, new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Object object = VideoCaptureCamera2.this.mCameraStateLock;
                    synchronized (object) {
                        while (VideoCaptureCamera2.this.mCameraState != 2 && VideoCaptureCamera2.this.mCameraState != 4 && VideoCaptureCamera2.this.mCameraState != 3) {
                            try {
                                VideoCaptureCamera2.this.mCameraStateLock.wait();
                            }
                            catch (InterruptedException ex) {
                                Logging.e(TAG, "CaptureStartedEvent: " + ex.getMessage());
                            }
                        }
                        if (VideoCaptureCamera2.this.mCameraState == 4 || VideoCaptureCamera2.this.mCameraState == 3) {
                            if (VideoCaptureCamera2.this.mSurfaceTextureHelper != null) {
                                VideoCaptureCamera2.this.mSurfaceTextureHelper.stopListening();
                                VideoCaptureCamera2.this.mSurfaceTextureHelper.dispose();
                                VideoCaptureCamera2.this.mSurfaceTextureHelper = null;
                            }
                            return null;
                        }
                    }
                    try {
                        VideoCaptureCamera2.this.requestFaceDetection(VideoCaptureCamera2.this.mPreviewRequestBuilder, 0);
                        VideoCaptureCamera2.this.mCameraThreadHandler.postAtFrontOfQueue((Runnable)new StopCaptureTask());
                        if (!VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.opened()) {
                            VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.block();
                        }
                        Logging.i(TAG, "releaseCamera done!");
                    }
                    catch (Exception e) {
                        try {
                            VideoCaptureCamera2.this.mCameraDevice.close();
                            VideoCaptureCamera2.this.mCameraDevice = null;
                        }
                        catch (Exception ex) {
                            Logging.e(TAG, "cameraDevice close error", e);
                        }
                    }
                    finally {
                        if (VideoCaptureCamera2.this.mSurfaceTextureHelper != null) {
                            VideoCaptureCamera2.this.mSurfaceTextureHelper.stopListening();
                            VideoCaptureCamera2.this.mSurfaceTextureHelper.dispose();
                            VideoCaptureCamera2.this.mSurfaceTextureHelper = null;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "stopCaptureAndBlockUntilStopped fail: " + e.getMessage());
        }
        Object object = this.mImageReaderLock;
        synchronized (object) {
            if (this.mImageReader != null) {
                try {
                    this.mImageReader.setOnImageAvailableListener(null, null);
                    this.mImageReader.close();
                }
                catch (IllegalStateException ex) {
                    Logging.e(TAG, "ImageReader Close():" + ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    Logging.e(TAG, "ImageReader Close():" + ex.getMessage());
                }
                this.mImageReader = null;
            }
            if (this.xiaomiReader != null) {
                try {
                    this.xiaomiReader.setOnImageAvailableListener(null, null);
                    this.xiaomiReader.close();
                }
                catch (IllegalStateException ex) {
                    Logging.e(TAG, "ImageReader Close():" + ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    Logging.e(TAG, "ImageReader Close():" + ex.getMessage());
                }
                this.xiaomiReader = null;
            }
        }
        if (this.mCameraThreadHandler != null) {
            this.mCameraThreadHandler.removeCallbacksAndMessages(null);
            this.mCameraThreadHandler.getLooper().quitSafely();
            this.mCameraThreadHandler = null;
        }
        if (this.mSurfaceTextureHelper != null) {
            Logging.d(TAG, "waiting camera device close failed after 2000ms");
            this.mSurfaceTextureHelper.stopListening();
            this.mSurfaceTextureHelper.dispose();
            this.mSurfaceTextureHelper = null;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        this.mIsFaceDetectionStarted = false;
        this.mIsCameraTorchStarted = false;
        this.mIsmCameraExposureStarted = false;
        this.mIsmCameraFocusStarted = false;
        this.mIsmCameraZoomStarted = false;
        this.mIsExposureCompensationStarted = false;
        this.mIsAntiBandingStarted = false;
        this.mIsEdgeEnhanceStarted = false;
        this.mIsStabilityStarted = false;
        this.mIsNoiseReducationStarted = false;
        this.mAutoFaceDetectFocusStarted = false;
        this.mPerFrameFaceDetectionInfoQueue.clear();
        Logging.i(TAG, "stopCaptureAndBlockUntilStopped done.");
    }

    @Override
    public void deallocate() {
        Logging.i(TAG, "deallocate()");
    }

    @Override
    public boolean isZoomSupported() {
        if (this.mMaxZoom > 1.0f) {
            return true;
        }
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics != null) {
            this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        }
        return this.mMaxZoom > 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setZoom(float zoomValue) {
        boolean needZoom;
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mCameraZoomFactor = zoomValue;
                return 0;
            }
            if (this.mIsmCameraZoomStarted && (double)Math.abs(this.mCameraZoomFactor - zoomValue) < 0.1) {
                return 0;
            }
            this.mCameraZoomFactor = zoomValue;
        }
        Logging.i(TAG, "setCameraZoom api2 called zoomValue =" + zoomValue);
        if (zoomValue <= 0.0f) {
            return -1;
        }
        if (this.mSensorRect == null) {
            CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1;
            }
            this.mSensorRect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        }
        if (Math.abs(this.mMaxZoom - 0.5f) < 0.001f) {
            Logging.e(TAG, "Camera " + this.mId + " does not support camera zoom");
            return -1;
        }
        boolean bl = needZoom = zoomValue >= 0.5f && zoomValue <= this.mMaxZoom && zoomValue != this.mLastZoomRatio;
        if (!needZoom) {
            Logging.e(TAG, "needZoom! ");
            return -2;
        }
        Rect zoomRect = this.cropRegionForZoom(zoomValue);
        this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoomRect);
        this.mLastZoomRatio = zoomValue;
        if (this.mPreviewSession != null) {
            try {
                this.mIsmCameraZoomStarted = true;
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -3;
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -4;
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -4;
            }
        }
        Logging.i(TAG, "setCameraZoom api2 called success!");
        return 0;
    }

    @Override
    public float getMaxZoom() {
        CameraCharacteristics cameraCharacteristics;
        if (this.mMaxZoom <= 1.0f && (cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId)) != null) {
            this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        }
        return this.mMaxZoom;
    }

    @Override
    public boolean isFocusSupported() {
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] availableModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (availableModes != null) {
            for (int i = 0; i < availableModes.length; ++i) {
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFocus(float valX, float valY) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null || this.mRenderView.getWidth() == 0 || this.mRenderView.getHeight() == 0) {
                this.mCameraFocusPositions[0] = valX;
                this.mCameraFocusPositions[1] = valY;
                return 0;
            }
            if (this.mIsmCameraFocusStarted && (double)Math.abs(this.mCameraFocusPositions[0] - valX) < 0.1 && (double)Math.abs(this.mCameraFocusPositions[1] - valY) < 0.1) {
                return 0;
            }
            this.mCameraFocusPositions[0] = valX;
            this.mCameraFocusPositions[1] = valY;
        }
        Logging.i(TAG, "setFocus " + valX + " - " + valY);
        if (valX < 0.0f || valX > (float)this.mRenderView.getWidth() || valY < 0.0f || valY > (float)this.mRenderView.getHeight()) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        Rect cropRegion = (Rect)this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (cropRegion == null) {
            return -1;
        }
        int cropWidth = cropRegion.width();
        int cropHeight = cropRegion.height();
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(valX, valY, valX, valY), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.i(TAG, "setFocus coordinate " + valX + " - " + valY + " out of image bounds!!");
            return -1;
        }
        float tempX = startRect.left;
        float tempY = startRect.top;
        float tapAreaRatio = 0.1f;
        RectF rectf = new RectF();
        rectf.left = CoordinatesTransform.clamp(tempX - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.right = CoordinatesTransform.clamp(tempX + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.top = CoordinatesTransform.clamp(tempY - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.bottom = CoordinatesTransform.clamp(tempY + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        startRect = CoordinatesTransform.normalizedToSensor(rectf, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, cropWidth, cropHeight, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), true);
        if (startRect == null) {
            Logging.w(TAG, "Failed to translate input coordinate");
            return -1;
        }
        Rect rect = new Rect();
        if (startRect.width() == 0.0f || startRect.height() == 0.0f) {
            rect = new Rect(0, 0, 0, 0);
        } else {
            startRect.round(rect);
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mCameraThreadHandler != null) {
            if (this.mPreviewSession != null) {
                try {
                    this.mIsmCameraFocusStarted = true;
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), VideoCaptureCamera2.shouldSkipRefocus() ? null : this.mAfCaptureCallback, this.mCameraThreadHandler);
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                    return -1;
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                    return -1;
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                    return -1;
                }
            }
            RectF translated = CoordinatesTransform.sensorToNormalized(startRect, cropWidth, cropHeight, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, true);
            if ((translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode)) == null) {
                Logging.w(TAG, "Failed to translate coordinate from normalized to view!!");
                return -1;
            }
            translated.round(rect);
            this.notifyCameraFocusAreaChanged(rect);
        }
        return 0;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (!this.isFocusSupported()) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer maxFaceCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        return maxFaceCount != null && maxFaceCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setAutoFaceFocus(boolean enable) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mEnableAutoFaceFocus == enable) {
                Logging.w(TAG, "face detect no change");
                return 0;
            }
            this.mEnableAutoFaceFocus = enable;
            if (!this.mFaceDetectSupported) {
                Logging.w(TAG, "face detect not supported");
                return 0;
            }
            if (this.mPreviewSession == null || this.mCameraThreadHandler == null || this.mPreviewRequestBuilder == null) {
                Logging.w(TAG, "face detect not ready");
                return 0;
            }
            if (this.mEnableAutoFaceFocus) {
                if (!this.mIsFaceDetectionStarted) {
                    this.mIsFaceDetectionStarted = true;
                    this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
                }
            } else {
                if (this.mEnableFaceDetection) {
                    Logging.w(TAG, "face detect did not turn off due to faceDistance on");
                    return 0;
                }
                this.mIsFaceDetectionStarted = false;
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                this.mPerFrameFaceDetectionInfoQueue.clear();
            }
        }
        if (this.mPreviewSession != null) {
            try {
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                return 0;
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFaceDetection(boolean enable) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mEnableFaceDetection == enable) {
                Logging.w(TAG, "face detect no change");
                return 0;
            }
            this.mEnableFaceDetection = enable;
            if (!this.mFaceDetectSupported) {
                Logging.w(TAG, "face detect not supported");
                return 0;
            }
            if (this.mPreviewSession == null || this.mCameraThreadHandler == null || this.mPreviewRequestBuilder == null) {
                Logging.w(TAG, "face detect not ready");
                return 0;
            }
            if (this.mEnableFaceDetection) {
                if (!this.mIsFaceDetectionStarted) {
                    this.mIsFaceDetectionStarted = true;
                    this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
                }
            } else {
                if (this.mEnableAutoFaceFocus) {
                    Logging.w(TAG, "face detect did not turn off due to autoFocus on");
                    return 0;
                }
                this.mIsFaceDetectionStarted = false;
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                this.mPerFrameFaceDetectionInfoQueue.clear();
            }
        }
        if (this.mCameraThreadHandler != null && this.mPreviewRequestBuilder != null && this.mPreviewSession != null) {
            try {
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return 0;
    }

    @Override
    public int setVideoEdgeMode(int mode) {
        int[] edgeEnhanceModes;
        if (this.mPreviewRequestBuilder == null) {
            Logging.i(TAG, "setVideoEdgeMode mPreviewRequestBuilder return.");
            return -1;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        int mVideoEdgeMode = this.toCamera2EdgeEnhanceMode(mode);
        if (VideoCaptureCamera2.isSupported(mVideoEdgeMode, edgeEnhanceModes = (int[])cameraCharacteristics.get(CameraCharacteristics.EDGE_AVAILABLE_EDGE_MODES)) && this.mPreviewSession != null) {
            try {
                Logging.i(TAG, "setVideoEdgeMode = " + mode);
                this.mPreviewRequestBuilder.set(CaptureRequest.EDGE_MODE, (Object)mode);
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                return 0;
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        Logging.e(TAG, "not supported VideoEdge Mode = " + mode);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setVideoStabilityMode(int mode) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mCameraVideoStabilityMode = mode;
                return 0;
            }
            if (this.mIsStabilityStarted && this.mCameraVideoStabilityMode == mode) {
                return 0;
            }
            this.mCameraVideoStabilityMode = mode;
        }
        if (this.mPreviewRequestBuilder == null) {
            Logging.i(TAG, "setVideoStabilityMode mPreviewRequestBuilder return.");
            return -1;
        }
        int mVideoStabilityMode = this.toCamera2VideoStabilityMode(mode);
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        int[] videoStabilityModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        if (this.isSupportedStability(mVideoStabilityMode, videoStabilityModes) && this.mPreviewSession != null) {
            try {
                Logging.i(TAG, "setVideoStabilityMode = " + mode);
                this.mIsStabilityStarted = true;
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)mVideoStabilityMode);
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                return 0;
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        Logging.e(TAG, "not supported VideoStability Mode = " + mode);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setEdgeEnhanceMode(int mode) {
        int[] edgeEnhanceModes;
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mCamerEdgeEnhanceMode = mode;
                return 0;
            }
            if (this.mIsEdgeEnhanceStarted && this.mCamerEdgeEnhanceMode == mode) {
                return 0;
            }
            this.mCamerEdgeEnhanceMode = mode;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        if (mode < 0 || mode > 3) {
            mode = 0;
        }
        if (VideoCaptureCamera2.isSupported(mode, edgeEnhanceModes = (int[])cameraCharacteristics.get(CameraCharacteristics.EDGE_AVAILABLE_EDGE_MODES)) && this.mPreviewSession != null) {
            this.mPreviewRequestBuilder.set(CaptureRequest.EDGE_MODE, (Object)mode);
            try {
                Logging.i(TAG, "setEdgeEnhanceMode = " + mode);
                this.mIsEdgeEnhanceStarted = true;
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                return 0;
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        Logging.e(TAG, "not supported EdgeEnhance Mode = " + mode);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setAntiBandingMode(int mode) {
        int[] availableBandingModes;
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mCameraAntiBandingMode = mode;
                return 0;
            }
            if (this.mIsAntiBandingStarted && this.mCameraAntiBandingMode == mode) {
                return 0;
            }
            this.mCameraAntiBandingMode = mode;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        if (mode < 0 || mode > 3) {
            mode = 3;
        }
        if (null != (availableBandingModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_ANTIBANDING_MODES)) && availableBandingModes.length > 0) {
            for (int bdMode : availableBandingModes) {
                if (bdMode != mode) continue;
                if (this.mPreviewSession != null) {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_ANTIBANDING_MODE, (Object)mode);
                    try {
                        Logging.i(TAG, "setAntiBandingMode = " + mode);
                        this.mIsAntiBandingStarted = true;
                        this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                        return 0;
                    }
                    catch (CameraAccessException e) {
                        ThrowableExtension.printStackTrace((Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        ThrowableExtension.printStackTrace((Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        ThrowableExtension.printStackTrace((Throwable)e);
                    }
                }
                Logging.i(TAG, "AgoraVideo set anti-banding = " + mode);
                return -1;
            }
        }
        Logging.e(TAG, "not supported anti-banding = " + mode);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setNoiseReductionMode(int mode) {
        int[] noiseReductionModes;
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mCameraNoiseReductionMode = mode;
                return 0;
            }
            if (this.mIsNoiseReducationStarted && this.mCameraNoiseReduction == mode) {
                return -1;
            }
            this.mCameraNoiseReductionMode = mode;
        }
        this.mCameraNoiseReduction = mode;
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        if (mode < 0 || mode > 4) {
            mode = 0;
        }
        if (VideoCaptureCamera2.isSupported(mode, noiseReductionModes = (int[])cameraCharacteristics.get(CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES))) {
            if (this.mPreviewSession != null) {
                try {
                    Logging.i(TAG, "setNoiseReductionMode = " + mode);
                    this.mIsNoiseReducationStarted = true;
                    this.mPreviewRequestBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)mode);
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                    return 0;
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
            }
        } else if (mode == 2 && VideoCaptureCamera2.isSupported(1, noiseReductionModes) && this.mPreviewSession != null) {
            try {
                this.mCameraNoiseReduction = 1;
                Logging.i(TAG, "setNoiseReductionMode = " + mode + " ,by fallback.");
                this.mIsNoiseReducationStarted = true;
                this.mPreviewRequestBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)this.mCameraNoiseReduction);
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                return 0;
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExposureCompensation(int value) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mCameraExposureCompensation = value;
                return 0;
            }
            if (this.mIsExposureCompensationStarted && this.mCameraExposureCompensation == value) {
                return 0;
            }
            this.mCameraExposureCompensation = value;
        }
        Logging.i(TAG, "setExposureCompensation:" + value);
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            return -1;
        }
        Rational step = (Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        if (range == null || step == null) {
            return -1;
        }
        int max = (Integer)range.getUpper();
        int min = (Integer)range.getLower();
        Logging.i(TAG, "compensation step=" + step + ", min=" + min + ", max=" + max);
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        if (this.mPreviewSession != null) {
            try {
                this.mIsExposureCompensationStarted = true;
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)value);
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                return 0;
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return -1;
    }

    private static boolean isSupported(int value, int[] supported) {
        if (supported == null) {
            return false;
        }
        for (int i : supported) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    private int toCamera2EdgeEnhanceMode(int mode) {
        if (mode < 0 || mode > 3) {
            return 0;
        }
        return mode;
    }

    private int toCamera2VideoStabilityMode(int mode) {
        if (mode < 0 || mode > 1) {
            return 0;
        }
        return mode;
    }

    private boolean isSupportedStability(int value, int[] supported) {
        if (supported == null) {
            return false;
        }
        for (int i : supported) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    private static String indexConvertCameraId(int index) {
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (index >= cameraIdList.length) {
                Logging.d(TAG, "physical camera Index: " + index);
            }
            return cameraIdList[index];
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (AssertionError ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ((Throwable)((Object)ex)).getMessage());
        }
        catch (Exception ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        return null;
    }

    @Override
    public boolean isFaceDetectSupported() {
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer maxFaceCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        int numDetectedFaces = maxFaceCount == null ? 0 : maxFaceCount;
        Logging.i(TAG, "face dedect, numDetectedFaces: " + numDetectedFaces);
        return numDetectedFaces > 0;
    }

    @Override
    public boolean isTorchSupported() {
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Boolean available = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        return available == null ? false : available;
    }

    public static boolean queryLogicalFocalLengths(CameraManager manager, String[] cameraIdList, FocalLengthInfo[] focalLengthInfos) {
        if (cameraIdList == null || cameraIdList.length == 0) {
            return false;
        }
        boolean found = false;
        for (String cameraId : cameraIdList) {
            CameraCharacteristics characteristics = null;
            try {
                characteristics = manager.getCameraCharacteristics(cameraId);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                continue;
            }
            if (!VideoCaptureCamera2.getFocalLengthInfo(characteristics, cameraId, 1, focalLengthInfos)) continue;
            found = true;
        }
        return found;
    }

    public static boolean queryZoomFocalLengths(CameraCharacteristics cameraCharacteristics, String id, FocalLengthInfo[] focalLengthInfos) {
        if (cameraCharacteristics == null) {
            return false;
        }
        Range<Float> frontFocalLengthRange = VideoCaptureCamera2.getZoomRationRange(cameraCharacteristics);
        Integer facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        if (facing == null) {
            return false;
        }
        boolean front = facing == 0;
        int cameraDirection = front ? 1 : 0;
        int index = 12 + (front ? 0 : 3);
        if (focalLengthInfos[index] == null) {
            Logging.d(TAG, "Zoom FocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 0 + " front: " + front);
            focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, Integer.parseInt(id), 0);
        }
        if (frontFocalLengthRange == null || ((Float)frontFocalLengthRange.getLower()).floatValue() >= 1.0f) {
            return false;
        }
        boolean ret = VideoCaptureCamera2.getFocalLengthInfo(cameraCharacteristics, id, 3, focalLengthInfos);
        if (!ret) {
            FocalLengthInfo lengthInfo;
            index = 12 + (front ? 0 : 3) + 1;
            Logging.d(TAG, "Zoom FocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 1 + " front: " + front);
            focalLengthInfos[index] = lengthInfo = new FocalLengthInfo(cameraDirection, index, Integer.parseInt(id), 1);
        }
        return true;
    }

    private static boolean getFocalLengthInfo(CameraCharacteristics cameraCharacteristics, String id, int type, FocalLengthInfo[] focalLengthInfos) {
        Integer facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        if (facing == null) {
            return false;
        }
        boolean front = facing == 0;
        int cameraDirection = front ? 1 : 0;
        float[] focalLengths = (float[])cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        int index = 6 * (type - 1) + (front ? 0 : 3) + 0;
        if (focalLengthInfos[index] == null) {
            Logging.d(TAG, "getFocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 0 + " front: " + front);
            focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, Integer.parseInt(id), 0);
        }
        if (focalLengths == null || focalLengths.length == 0) {
            return false;
        }
        float minFocalLength = focalLengths[0];
        for (float focalLength : focalLengths) {
            minFocalLength = Math.min(focalLength, minFocalLength);
        }
        Logging.d(TAG, "The " + (front ? "front Camera " : "rear Camera ") + "minimum supported value is: " + 10.0f * minFocalLength + "mm");
        if (minFocalLength >= 2.4f && minFocalLength < 3.5f) {
            index = 6 * (type - 1) + (front ? 0 : 3) + 1;
            Logging.d(TAG, "getFocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 1 + " front: " + front);
            focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, Integer.parseInt(id), 1);
            return true;
        }
        if (minFocalLength < 2.4f && (double)minFocalLength > 0.1) {
            index = 6 * (type - 1) + (front ? 0 : 3) + 2;
            Logging.d(TAG, "getFocalLengthInfo cameraDirection " + cameraDirection + " index: " + index + " id: " + id + " focalLengthType: " + 2 + " front: " + front);
            focalLengthInfos[index] = new FocalLengthInfo(cameraDirection, index, Integer.parseInt(id), 2);
            return true;
        }
        return false;
    }

    @Nullable
    public static List<FocalLengthInfo> queryCameraFocalLengthCapability(boolean skip_physical_camera) {
        String[] cameraIdList;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (ContextUtils.getApplicationContext() == null) {
            return null;
        }
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        if (manager == null) {
            return null;
        }
        try {
            cameraIdList = manager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            ThrowableExtension.printStackTrace((Throwable)e);
            return null;
        }
        FocalLengthInfo[] logicalLengthInfos = new FocalLengthInfo[18];
        boolean found = VideoCaptureCamera2.queryLogicalFocalLengths(manager, cameraIdList, logicalLengthInfos);
        if (!found) {
            Logging.w(TAG, "Logical Camera, FocalLengths empty!");
        } else {
            Logging.d(TAG, "Logical Camera, FocalLengths available.");
        }
        CameraCharacteristics characteristicsOfIndex0 = null;
        CameraCharacteristics characteristicsOfIndex1 = null;
        try {
            characteristicsOfIndex0 = manager.getCameraCharacteristics("0");
            characteristicsOfIndex1 = manager.getCameraCharacteristics("1");
        }
        catch (CameraAccessException e) {
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        catch (Exception e) {
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        found = false;
        if (!skip_physical_camera) {
            if (VideoCaptureCamera2.queryPhysicalFocalLengths(manager, characteristicsOfIndex0, cameraIdList, logicalLengthInfos)) {
                found = true;
            }
            if (VideoCaptureCamera2.queryPhysicalFocalLengths(manager, characteristicsOfIndex1, cameraIdList, logicalLengthInfos)) {
                found = true;
            }
        } else {
            Logging.w(TAG, "Skip find physical camera focalLength capability.");
        }
        if (!found) {
            Logging.w(TAG, "Physical Camera, FocalLengths empty!");
        } else {
            Logging.d(TAG, "Physical Camera, FocalLengths available.");
        }
        found = false;
        if (characteristicsOfIndex0 != null && VideoCaptureCamera2.queryZoomFocalLengths(characteristicsOfIndex0, "0", logicalLengthInfos)) {
            found = true;
        }
        if (characteristicsOfIndex1 != null && VideoCaptureCamera2.queryZoomFocalLengths(characteristicsOfIndex1, "1", logicalLengthInfos)) {
            found = true;
        }
        if (!found) {
            Logging.w(TAG, "Scaling less than 1.0 magnification is not supported.");
        } else {
            Logging.d(TAG, "Supports scaling of less than 1.0 magnification, FocalLengths available.");
        }
        ArrayList<FocalLengthInfo> focalLengthInfoList = new ArrayList<FocalLengthInfo>();
        for (FocalLengthInfo focalLengthInfo : logicalLengthInfos) {
            if (focalLengthInfoList.contains(focalLengthInfo)) continue;
            focalLengthInfoList.add(focalLengthInfo);
        }
        return focalLengthInfoList;
    }

    private static boolean queryPhysicalFocalLengths(CameraManager manager, CameraCharacteristics characteristics, String[] cameraIdList, FocalLengthInfo[] focalLengthInfos) {
        if (Build.VERSION.SDK_INT < 28) {
            return false;
        }
        if (cameraIdList == null || cameraIdList.length == 0 || characteristics == null) {
            return false;
        }
        int[] capabilities = (int[])characteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean physicalCameraAvailable = false;
        if (capabilities != null) {
            for (int cap : capabilities) {
                if (cap != 11) continue;
                physicalCameraAvailable = true;
                break;
            }
        }
        Logging.d(TAG, "physicalCamera Available: " + physicalCameraAvailable);
        if (!physicalCameraAvailable) {
            return false;
        }
        Set physicalCameraIds = characteristics.getPhysicalCameraIds();
        if (physicalCameraIds.isEmpty()) {
            return false;
        }
        boolean found = false;
        for (String cameraId : physicalCameraIds) {
            CameraCharacteristics physicalCharacteristics;
            try {
                physicalCharacteristics = manager.getCameraCharacteristics(cameraId);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                continue;
            }
            if (!VideoCaptureCamera2.getFocalLengthInfo(physicalCharacteristics, cameraId, 2, focalLengthInfos)) continue;
            found = true;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setTorchMode(boolean isOn) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            int mode;
            int n = mode = isOn ? 1 : -1;
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null) {
                this.mTorchMode = mode;
                return 0;
            }
            if (this.mIsCameraTorchStarted && this.mTorchMode == mode) {
                return 0;
            }
            this.mTorchMode = mode;
        }
        Logging.i(TAG, "setTorchMode called camera api2, isOn: " + isOn);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1;
        }
        Boolean available = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean isFlashSupported = available == null ? false : available;
        Logging.w(TAG, "setTorchMode isFlashSupported: " + (isFlashSupported ? "true" : "false"));
        if (isFlashSupported) {
            if (isOn) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            if (this.mPreviewSession != null) {
                try {
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), null, this.mCameraThreadHandler);
                    this.mIsCameraTorchStarted = true;
                    return 0;
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
            }
        } else {
            Logging.w(TAG, "flash is not supported");
        }
        return -1;
    }

    @Override
    public boolean isExposureSupported() {
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] availableModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (availableModes != null) {
            for (int i = 0; i < availableModes.length; ++i) {
                Logging.i(TAG, "isExposureSupported AE mode = " + availableModes[i]);
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCameraExposureSupported() {
        CameraCharacteristics cameraCharacteristics = this.mPhysicalId != null ? VideoCaptureCamera2.getCameraCharacteristics(this.mPhysicalId) : VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Rational step = (Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        if (range == null || step == null) {
            return false;
        }
        int max = (Integer)range.getUpper();
        int min = (Integer)range.getLower();
        Logging.i(TAG, "isCameraExposureSupported compensation min: " + min + " max: " + max);
        return min < 0 && max > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExposure(float positionXinView, float positionYinView) {
        Object object = this.mSwitchLock;
        synchronized (object) {
            if (this.mPreviewSession == null || this.mPreviewRequestBuilder == null || this.mRenderView.getWidth() == 0 || this.mRenderView.getHeight() == 0) {
                this.mCameraExposurePositions[0] = positionXinView;
                this.mCameraExposurePositions[1] = positionYinView;
                return 0;
            }
            if (this.mIsmCameraExposureStarted && (double)Math.abs(this.mCameraExposurePositions[0] - positionXinView) < 0.1 && (double)Math.abs(this.mCameraExposurePositions[1] - positionYinView) < 0.1) {
                return 0;
            }
            this.mCameraExposurePositions[0] = positionXinView;
            this.mCameraExposurePositions[1] = positionYinView;
        }
        Logging.i(TAG, "setExposure called camera api2 " + positionXinView + "x" + positionYinView);
        if (positionXinView < 0.0f || positionXinView > (float)this.mRenderView.getWidth() || positionYinView < 0.0f || positionYinView > (float)this.mRenderView.getHeight()) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        Rect cropRegion = (Rect)this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (cropRegion == null) {
            return -1;
        }
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(positionXinView, positionYinView, positionXinView, positionYinView), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.i(TAG, "setExposure coordinate " + positionXinView + " - " + positionYinView + " out of image bounds!!");
            return -1;
        }
        float tempX = startRect.left;
        float tempY = startRect.top;
        float tapAreaRatio = 0.1f;
        RectF rectf = new RectF();
        rectf.left = CoordinatesTransform.clamp(tempX - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.right = CoordinatesTransform.clamp(tempX + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.top = CoordinatesTransform.clamp(tempY - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.bottom = CoordinatesTransform.clamp(tempY + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        startRect = CoordinatesTransform.normalizedToSensor(rectf, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, cropRegion.width(), cropRegion.height(), (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), true);
        if (startRect == null) {
            Logging.w(TAG, "Failed to translate input coordinate");
            return -1;
        }
        Rect rect = new Rect();
        if (startRect.width() == 0.0f || startRect.height() == 0.0f) {
            rect = new Rect(0, 0, 0, 0);
        } else {
            startRect.round(rect);
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mPreviewSession != null) {
            try {
                this.mIsmCameraExposureStarted = true;
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), null, this.mCameraThreadHandler);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
            catch (NoClassDefFoundError e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
        }
        RectF translated = CoordinatesTransform.sensorToNormalized(new RectF((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom), cropRegion.width(), cropRegion.height(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, true);
        if ((translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode)) == null) {
            Logging.w(TAG, "Failed to translate coordinate from normalized to view!!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraExposureAreaChanged(rect);
        return 0;
    }

    private static float getMaxZoom(CameraCharacteristics cameraCharacteristics) {
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1.0f;
        }
        Float maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom == null) {
            Logging.w(TAG, "warning get max zoom return null");
            return -1.0f;
        }
        return maxZoom.floatValue();
    }

    private static Range<Float> getZoomRationRange(CameraCharacteristics cameraCharacteristics) {
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return null;
        }
        Range<Float> floatRange = null;
        if (Build.VERSION.SDK_INT >= 30) {
            return null;
        }
        if (floatRange == null) {
            return null;
        }
        return floatRange;
    }

    private Rect cropRegionForZoom(float ratio) {
        int xCenter = this.mSensorRect.width() / 2;
        int yCenter = this.mSensorRect.height() / 2;
        int xDelta = (int)(0.5f * (float)this.mSensorRect.width() / ratio);
        int yDelta = (int)(0.5f * (float)this.mSensorRect.height() / ratio);
        return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
    }

    private int createCaptureRequest() {
        try {
            this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, null);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -1;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -2;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -3;
        }
        catch (IllegalStateException ex) {
            Logging.e(TAG, "capture:" + ex);
            return -4;
        }
        catch (NoClassDefFoundError e) {
            return -1;
        }
        return 0;
    }

    static {
        COLOR_TEMPERATURES_MAP.append(2850, 2);
        COLOR_TEMPERATURES_MAP.append(2950, 4);
        COLOR_TEMPERATURES_MAP.append(4250, 3);
        COLOR_TEMPERATURES_MAP.append(4600, 7);
        COLOR_TEMPERATURES_MAP.append(5000, 5);
        COLOR_TEMPERATURES_MAP.append(6000, 6);
        COLOR_TEMPERATURES_MAP.append(7000, 8);
        cameraCharacteristicMaps = new ConcurrentHashMap<Integer, CameraCharacteristics>();
        ANDROID_CAMERA_HARDWARE_LEVEL_MAP = new SparseIntArray();
        if (Build.VERSION.SDK_INT >= 21) {
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(2, 1);
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(0, 3);
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(1, 4);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(4, 2);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(3, 5);
        }
    }

    static class CameraIdListTask
    implements Runnable {
        static String[] cameraIdList;
        final CountDownLatch countDown = new CountDownLatch(1);

        CameraIdListTask() {
        }

        @Override
        public void run() {
            try {
                if (ContextUtils.getApplicationContext() == null) {
                    return;
                }
                CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
                if (manager == null) {
                    return;
                }
                cameraIdList = manager.getCameraIdList();
            }
            catch (IllegalArgumentException ex) {
                Logging.e(TAG, "getSystemService(Context.CAMERA_SERVICE): " + ex.getMessage());
            }
            catch (CameraAccessException ex) {
                Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ex.getMessage());
            }
            catch (SecurityException ex) {
                Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ex.getMessage());
            }
            catch (AssertionError ex) {
                Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ((Throwable)((Object)ex)).getMessage());
            }
            catch (Exception ex) {
                Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ex.getMessage());
            }
            finally {
                this.countDown.countDown();
            }
        }

        public String[] getCameraIdList() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.countDown, 2000L)) {
                Logging.e(TAG, "checkBackgroundSafe timeout");
            }
            return cameraIdList;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface CameraState {
        public static final int OPENING = 0;
        public static final int CONFIGURING = 1;
        public static final int STARTED = 2;
        public static final int EVICTED = 3;
        public static final int STOPPED = 4;
    }

    private class StopCaptureTask
    implements Runnable {
        private StopCaptureTask() {
        }

        @Override
        public void run() {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            if (VideoCaptureCamera2.this.mCameraDevice == null) {
                return;
            }
            try {
                VideoCaptureCamera2.this.mCameraDevice.close();
                VideoCaptureCamera2.this.mCameraDevice = null;
            }
            catch (IllegalStateException e) {
                Logging.e(TAG, "cameraDevice close error", e);
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(4);
            VideoCaptureCamera2.this.mCropRect = new Rect();
        }
    }

    private class CrPreviewReaderListener
    implements ImageReader.OnImageAvailableListener {
        private CrPreviewReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onImageAvailable(ImageReader reader) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Image image = null;
            Object object = VideoCaptureCamera2.this.mImageReaderLock;
            synchronized (object) {
                try {
                    if (VideoCaptureCamera2.this.mImageReader == null) {
                        return;
                    }
                    image = reader.acquireLatestImage();
                    if (image == null) {
                        VideoCaptureCamera2.this.onFrameDropped(9);
                        return;
                    }
                    if (image.getFormat() != 35 || image.getPlanes().length != 3) {
                        Logging.e(TAG, "Unexpected image format: " + image.getFormat() + " or #planes: " + image.getPlanes().length);
                        throw new IllegalStateException();
                    }
                    if (reader.getWidth() != image.getWidth() || reader.getHeight() != image.getHeight()) {
                        Logging.e(TAG, "ImageReader size (" + reader.getWidth() + "x" + reader.getHeight() + ") did not match Image size (" + image.getWidth() + "x" + image.getHeight() + ")");
                        throw new IllegalStateException();
                    }
                    VideoFrameMetaInfo metaInfo = VideoCaptureCamera2.this.getPerFrameMetaInfos();
                    VideoCaptureCamera2.this.onI420FrameAvailable(image.getPlanes()[0].getBuffer(), image.getPlanes()[0].getRowStride(), image.getPlanes()[1].getBuffer(), image.getPlanes()[2].getBuffer(), image.getPlanes()[1].getRowStride(), image.getPlanes()[1].getPixelStride(), image.getWidth(), image.getHeight(), VideoCaptureCamera2.this.getCameraRotation(), image.getTimestamp(), metaInfo);
                }
                catch (IllegalStateException ex) {
                    Logging.e(TAG, "acquireLatestImage():" + ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    Logging.e(TAG, "acquireLatestImage():" + ex.getMessage());
                }
                finally {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (IllegalStateException ex) {
                            Logging.e(TAG, "Image Close():" + ex.getMessage());
                        }
                        catch (IllegalArgumentException ex) {
                            Logging.e(TAG, "Image Close():" + ex.getMessage());
                        }
                    }
                }
                return;
            }
        }
    }

    private class TextureVideoSinkListener
    implements SurfaceTextureHelper.IVideoCapture {
        private TextureVideoSinkListener() {
        }

        @Override
        public void onFrame(VideoFrame frame) {
            VideoFrame.Buffer capturedBuffer = frame.getBuffer();
            if (VideoCaptureCamera2.this.mEnableTextureCopy) {
                capturedBuffer = ((SurfaceTextureHelper)VideoCaptureCamera2.this.mSurfaceTextureHelper).textureCopy((VideoFrame.TextureBuffer)frame.getBuffer());
            }
            if (capturedBuffer == null) {
                this.onFrameDropped(9);
                Logging.i(TAG, "[HWS] TextureVideoSinkListener copy frame error");
                return;
            }
            VideoFrame modifiedFrame = new VideoFrame(VideoCapture.createTextureBufferWithModifiedTransformMatrix((TextureBuffer)capturedBuffer, !VideoCaptureCamera2.this.mInvertDeviceOrientationReadings, -VideoCaptureCamera2.this.mCameraNativeOrientation), VideoCaptureCamera2.this.getCameraRotation(), frame.getTimestampNs());
            VideoCaptureCamera2.this.attachPerFrameMetaInfos(modifiedFrame);
            VideoCaptureCamera2.this.onFrameCaptured(modifiedFrame);
            if (VideoCaptureCamera2.this.mEnableTextureCopy) {
                capturedBuffer.release();
            }
            modifiedFrame.release();
        }

        @Override
        public void onFrameDropped(int dropReason) {
            VideoCaptureCamera2.super.onFrameDropped(dropReason);
        }
    }

    private class CrPreviewSessionListener
    extends CameraCaptureSession.StateCallback {
        private CrPreviewSessionListener() {
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.i(TAG, "CrPreviewSessionListener.onConfigured");
            VideoCaptureCamera2.this.mPreviewSession = cameraCaptureSession;
            try {
                if (VideoCaptureCamera2.this.mPreviewRequestBuilder != null && VideoCaptureCamera2.this.mPreviewSession != null) {
                    VideoCaptureCamera2.this.requestFaceDetection(VideoCaptureCamera2.this.mPreviewRequestBuilder, VideoCaptureCamera2.this.mFaceDetectMode);
                    VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(VideoCaptureCamera2.this.mPreviewRequestBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, VideoCaptureCamera2.this.mCameraThreadHandler);
                }
                if (!VideoCaptureCamera2.this.mIsCameraTorchStarted && VideoCaptureCamera2.this.mTorchMode != 0) {
                    VideoCaptureCamera2.this.setTorchMode(VideoCaptureCamera2.this.mTorchMode == 1);
                }
                if (!VideoCaptureCamera2.this.mIsmCameraExposureStarted && VideoCaptureCamera2.this.mCameraExposurePositions[0] > 0.0f && VideoCaptureCamera2.this.mCameraExposurePositions[1] > 0.0f) {
                    VideoCaptureCamera2.this.setExposure(VideoCaptureCamera2.this.mCameraExposurePositions[0], VideoCaptureCamera2.this.mCameraExposurePositions[1]);
                }
                if (!VideoCaptureCamera2.this.mIsmCameraFocusStarted && VideoCaptureCamera2.this.mCameraFocusPositions[0] > 0.0f && VideoCaptureCamera2.this.mCameraFocusPositions[1] > 0.0f) {
                    VideoCaptureCamera2.this.setFocus(VideoCaptureCamera2.this.mCameraFocusPositions[0], VideoCaptureCamera2.this.mCameraFocusPositions[1]);
                }
                if (!VideoCaptureCamera2.this.mIsmCameraZoomStarted && VideoCaptureCamera2.this.mCameraZoomFactor > 0.0f) {
                    VideoCaptureCamera2.this.setZoom(VideoCaptureCamera2.this.mCameraZoomFactor);
                }
                if (!VideoCaptureCamera2.this.mIsExposureCompensationStarted && VideoCaptureCamera2.this.mCameraExposureCompensation != 0) {
                    VideoCaptureCamera2.this.setExposureCompensation(VideoCaptureCamera2.this.mCameraExposureCompensation);
                }
                if (!VideoCaptureCamera2.this.mIsNoiseReducationStarted && VideoCaptureCamera2.this.mCameraNoiseReduction != 0) {
                    VideoCaptureCamera2.this.setNoiseReductionMode(VideoCaptureCamera2.this.mCameraNoiseReduction);
                }
                if (!VideoCaptureCamera2.this.mAutoFaceDetectFocusStarted && VideoCaptureCamera2.this.mCameraAutoFaceFocus) {
                    VideoCaptureCamera2.this.setAutoFaceFocus(VideoCaptureCamera2.this.mCameraAutoFaceFocus);
                }
            }
            catch (CameraAccessException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (SecurityException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (IllegalStateException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (IllegalArgumentException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (NoClassDefFoundError e) {
                Logging.e(TAG, "setRepeatingRequest: " + e.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(2);
            VideoCaptureCamera2.this.onStarted();
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.i(TAG, "CrPreviewSessionListener.onConfigureFailed");
            VideoCaptureCamera2.this.changeCameraStateAndNotify(4);
            VideoCaptureCamera2.this.mPreviewSession = null;
            VideoCaptureCamera2.this.onError(101, "Camera session configuration error");
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.i(TAG, "CrPreviewSessionListener.onClosed");
            VideoCaptureCamera2.this.mPreviewSession = null;
        }
    }

    class CrStateListener
    extends CameraDevice.StateCallback {
        CrStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.i(TAG, "CameraDevice.StateCallback onOpened");
            Object object = VideoCaptureCamera2.this.mCameraStateLock;
            synchronized (object) {
                if (VideoCaptureCamera2.this.mCameraState == 4) {
                    try {
                        Logging.w(TAG, "cameraDevice state error,  should manual close!");
                        cameraDevice.close();
                    }
                    catch (IllegalStateException e) {
                        Logging.e(TAG, "cameraDevice close error", e);
                    }
                    return;
                }
            }
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.close();
            VideoCaptureCamera2.this.changeCameraStateAndNotify(1);
            VideoCaptureCamera2.this.createPreviewObjectsAndStartPreviewOrFailWith(100);
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.e(TAG, "cameraDevice was closed unexpectedly");
            if (VideoCaptureCamera2.this.mCameraState != 4 && VideoCaptureCamera2.this.mCameraState != 3) {
                if (VideoCaptureCamera2.this.mCameraDevice != null) {
                    try {
                        VideoCaptureCamera2.this.mCameraDevice.close();
                        VideoCaptureCamera2.this.mCameraDevice = null;
                        Logging.i(TAG, "CameraDevice close done!");
                    }
                    catch (IllegalStateException e) {
                        Logging.e(TAG, "cameraDevice close error", e);
                    }
                    VideoCaptureCamera2.this.mCameraDevice = null;
                }
                VideoCaptureCamera2.this.onError(6, "Camera disconnected");
                VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
            }
        }

        public void onError(CameraDevice cameraDevice, int error) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.e(TAG, "cameraDevice encountered an error, code: " + error);
            if (VideoCaptureCamera2.this.mCameraState == 4 || VideoCaptureCamera2.this.mCameraState == 3) {
                return;
            }
            if (VideoCaptureCamera2.this.mCameraDevice != null) {
                try {
                    VideoCaptureCamera2.this.mCameraDevice.close();
                }
                catch (IllegalStateException e) {
                    Logging.e(TAG, "cameraDevice close error", e);
                }
                VideoCaptureCamera2.this.mCameraDevice = null;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
            int errorCode = 0;
            String msg = "";
            switch (error) {
                case 1: {
                    errorCode = 1;
                    msg = "Camera In Use";
                    break;
                }
                case 2: {
                    errorCode = 2;
                    msg = "Camera In Use";
                    break;
                }
                case 3: {
                    errorCode = 3;
                    msg = "Camera disabled";
                    break;
                }
                case 5: {
                    errorCode = 5;
                    msg = "Camera service error";
                    break;
                }
                case 4: {
                    errorCode = 4;
                    msg = "Camera device error";
                    break;
                }
                default: {
                    errorCode = 901;
                    msg = "Camera runtime erro";
                }
            }
            VideoCaptureCamera2.this.onError(errorCode, msg);
        }

        public void onClosed(CameraDevice camera) {
            Logging.i(TAG, "cameraDevice closed");
            if (VideoCaptureCamera2.this.mPreviewSession != null) {
                VideoCaptureCamera2.this.mPreviewSession = null;
            }
            VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.open();
        }
    }
}

