/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.opengl.GLES20;
import android.opengl.GLES30;
import android.os.Build;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.HdrUtil;

public class GlTextureFrameBuffer {
    private final int pixelFormat;
    private int frameBufferId;
    private int textureId;
    private int width;
    private int height;

    public GlTextureFrameBuffer(int pixelFormat) {
        switch (pixelFormat) {
            case 6407: 
            case 6408: 
            case 6409: 
            case 34842: {
                this.pixelFormat = pixelFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pixel format: " + pixelFormat);
            }
        }
        this.width = 0;
        this.height = 0;
    }

    public void setSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid size: " + width + "x" + height);
        }
        if (width == this.width && height == this.height) {
            return;
        }
        int texture_id = this.textureId;
        if (texture_id == 0) {
            texture_id = GlUtil.generateTexture(3553);
        }
        if (this.frameBufferId == 0) {
            int[] frameBuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
            this.frameBufferId = frameBuffers[0];
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)texture_id);
        if (this.pixelFormat == 34842) {
            if (Build.VERSION.SDK_INT < 18 || !HdrUtil.isSupportedEGL3()) {
                throw new IllegalArgumentException("not support hdr");
            }
            GLES30.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5126, null);
            GlUtil.checkNoGLES2Error("GlTextureFrameBuffer glTexImage2D GL_RGBA16F");
        } else {
            GLES20.glTexImage2D((int)3553, (int)0, (int)this.pixelFormat, (int)width, (int)height, (int)0, (int)this.pixelFormat, (int)5121, null);
        }
        GLES20.glBindTexture((int)3553, (int)0);
        GlUtil.checkNoGLES2Error("GlTextureFrameBuffer setSize");
        this.bindTexture(texture_id, 3553, width, height, false);
    }

    public void bindTexture(int textureId, int textureFormat, int width, int height, boolean forceBind) {
        if (!forceBind && width == this.width && height == this.height && this.textureId == textureId) {
            return;
        }
        this.textureId = textureId;
        this.width = width;
        this.height = height;
        if (this.frameBufferId == 0) {
            int[] frameBuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
            this.frameBufferId = frameBuffers[0];
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)textureFormat, (int)textureId, (int)0);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new IllegalStateException("Framebuffer not complete, status: " + status);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void release() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        this.textureId = 0;
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
        this.frameBufferId = 0;
        this.width = 0;
        this.height = 0;
    }
}

