/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.base.internal.CalledByNative;
import io.agora.rte.Constants;

public class Error {
    private long mNativeHandle = 0L;
    private boolean mIsNativeOwner = true;

    public Error() {
        this.mNativeHandle = this.nativeCreateError();
    }

    @CalledByNative
    public Error(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mIsNativeOwner = false;
    }

    protected void finalize() {
        this.destroy();
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public Constants.ErrorCode code() {
        return Constants.ErrorCode.fromInt(this.nativeGetCode(this.mNativeHandle));
    }

    public String message() {
        return this.nativeGetMessage(this.mNativeHandle);
    }

    private void destroy() {
        if (this.mIsNativeOwner) {
            this.nativeReleaseError(this.mNativeHandle);
        }
        this.mNativeHandle = 0L;
    }

    private native long nativeCreateError();

    private native void nativeReleaseError(long var1);

    private native int nativeGetCode(long var1);

    private native String nativeGetMessage(long var1);
}

