/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import io.agora.base.internal.BuildConfig;
import java.io.File;

public class NativeLibsLoader {
    private static final String TAG = NativeLibsLoader.class.getSimpleName();
    public static String nativeLibraryName = "agora-rtc-sdk";
    static String nativeLibraryPrefix = "lib";
    static String nativeLibrarySurffix = ".so";
    private static int sLibLoadCount = 0;

    public static synchronized boolean initializeNativeLibs() {
        return NativeLibsLoader.initializeNativeLibs(null);
    }

    public static synchronized boolean initializeNativeLibs(String libPath) {
        boolean libLoaded = false;
        if (sLibLoadCount <= 0) {
            for (int i = 0; i < BuildConfig.so_list.size(); ++i) {
                libLoaded = NativeLibsLoader.safeLoadLibrary(libPath, BuildConfig.so_list.get(i));
                if (libLoaded) continue;
                return libLoaded;
            }
            libLoaded = NativeLibsLoader.safeLoadLibrary(libPath, nativeLibraryName);
            if (libLoaded) {
                ++sLibLoadCount;
            }
        } else {
            ++sLibLoadCount;
            libLoaded = true;
        }
        return libLoaded;
    }

    public static synchronized void deinitializeNativeLibs() {
        if (sLibLoadCount > 0 && --sLibLoadCount < 0) {
            sLibLoadCount = 0;
        }
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    private static boolean safeLoadLibrary(String path, String name) {
        boolean loaded = true;
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                System.loadLibrary(name);
            } else {
                System.load(NativeLibsLoader.getNativeLibFullPath(path, name));
            }
        }
        catch (UnsatisfiedLinkError e) {
            loaded = false;
        }
        catch (Exception e) {
            loaded = false;
        }
        if (!loaded) {
            Log.i((String)TAG, (String)("failed to load library " + name + " from " + path));
        }
        return loaded;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySurffix;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    private NativeLibsLoader() {
    }
}

