/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import io.agora.utils2.internal.CommonUtility;
import io.agora.utils2.internal.Logging;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Connectivity {
    private static final String TAG = "Connectivity";
    public static final int Network_UNKNOWN = -1;
    public static final int Network_DISCONNECTED = 0;
    public static final int Network_LAN = 1;
    public static final int Network_WIFI = 2;
    public static final int Network_2G = 3;
    public static final int Network_3G = 4;
    public static final int Network_4G = 5;
    public static final int Network_5G = 6;
    public static final int Network_SubType_WIFI_2P4G = 100;
    public static final int Network_SubType_WIFI_5G = 101;

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        if (!CommonUtility.checkAccessNetworkState(context)) {
            return null;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo();
    }

    public static int VPNBehindAddress(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            Network activeNetwork;
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkCapabilities caps = cm.getNetworkCapabilities(activeNetwork = cm.getActiveNetwork());
            if (caps == null) {
                Logging.d(TAG, "VPNBehindAddress NetworkCapabilities is null");
                return 0;
            }
            boolean vpnInUse = caps.hasTransport(4);
            Logging.d(TAG, "VPNBehindAddress vpnInUse is " + vpnInUse);
            return vpnInUse ? 1 : 0;
        }
        return 0;
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected();
    }

    public static int getNetworkType(NetworkInfo info) {
        if (info == null) {
            return 0;
        }
        if (!info.isConnected()) {
            return 0;
        }
        int type = info.getType();
        if (type == 1) {
            return 2;
        }
        if (type != 0) {
            return -1;
        }
        switch (info.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 3;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 20: {
                return 6;
            }
        }
        return -1;
    }

    public static int getNetworkType(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return Connectivity.getNetworkType(info);
    }

    public static ArrayList<String> getDnsList() {
        Logging.d(TAG, "getDnsList()");
        if (Build.VERSION.SDK_INT >= 26) {
            return null;
        }
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            ArrayList<String> servers = new ArrayList<String>();
            for (String name : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                String value = (String)method.invoke(null, name);
                if (value == null || "".equals(value) || servers.contains(value)) continue;
                servers.add(value);
            }
            return servers;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

