/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine.earmonitor;

import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ReflectUtils;
import io.agora.base.internal.voiceengine.earmonitor.HardwareEarMonitorListener;
import io.agora.base.internal.voiceengine.earmonitor.HonorHardwareEarMonitor;
import io.agora.base.internal.voiceengine.earmonitor.HuaweiHardwareEarMonitor;
import io.agora.base.internal.voiceengine.earmonitor.IHardwareEarMonitor;
import io.agora.base.internal.voiceengine.earmonitor.VivoHardwareEarMonitor;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HardwareEarMonitorFactory {
    private static final String TAG = HardwareEarMonitorFactory.class.getSimpleName();
    private static Map<String, Class<? extends IHardwareEarMonitor>> sHardwareEarMonitorMap = new ConcurrentHashMap<String, Class<? extends IHardwareEarMonitor>>();

    @Nullable
    public static IHardwareEarMonitor create(String manufacturer, HardwareEarMonitorListener listener) {
        IHardwareEarMonitor hardwareEarMonitor = null;
        try {
            Class<? extends IHardwareEarMonitor> clazz = sHardwareEarMonitorMap.get(manufacturer);
            if (clazz != null && ((Boolean)ReflectUtils.safeCallMethod(clazz, null, "hasEarMonitorClass", new Class[0], new Object[0])).booleanValue()) {
                Constructor<? extends IHardwareEarMonitor> constructor = clazz.getConstructor(HardwareEarMonitorListener.class);
                hardwareEarMonitor = constructor.newInstance(listener);
            }
            if (hardwareEarMonitor == null && manufacturer.equals("honor")) {
                Logging.w(TAG, "fallback to use huawei audiokit for honor device");
                hardwareEarMonitor = HardwareEarMonitorFactory.create("huawei", listener);
            }
        }
        catch (Throwable e) {
            Logging.e(TAG, "createHardwareEarMonitor failed: ", e);
        }
        return hardwareEarMonitor;
    }

    static {
        sHardwareEarMonitorMap.put("huawei", HuaweiHardwareEarMonitor.class);
        sHardwareEarMonitorMap.put("honor", HonorHardwareEarMonitor.class);
        sHardwareEarMonitorMap.put("vivo", VivoHardwareEarMonitor.class);
    }
}

