/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine.earmonitor;

import android.content.Context;
import androidx.annotation.Nullable;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ReflectUtils;
import io.agora.base.internal.voiceengine.earmonitor.HardwareEarMonitorListener;
import io.agora.base.internal.voiceengine.earmonitor.IHardwareEarMonitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;

public class HonorHardwareEarMonitor
implements IHardwareEarMonitor {
    private static final String TAG = HonorHardwareEarMonitor.class.getSimpleName();
    private AudioServiceCallbackImpl mAudioServiceCallbackImpl = new AudioServiceCallbackImpl();
    @Nullable
    private HardwareEarMonitorListener mListener;
    @Nullable
    private Context mContext;
    @Nullable
    private Object mHnAudioClient = null;
    @Nullable
    private Object mHnEarReturnClient = null;
    @Nullable
    private Class<?> mHnAudioClientClass;
    @Nullable
    private Class<?> mHnEarReturnClientClass;
    @Nullable
    private Class<?> mServiceTypeClass;
    @Nullable
    private Class<?> mParamNameClass;
    private volatile boolean mInitialized = false;
    private volatile boolean mIsDestroyed = false;
    private volatile boolean mEarMonitorEnabled = false;
    private volatile boolean mBindServiceSuccess = false;

    public HonorHardwareEarMonitor(HardwareEarMonitorListener listener) {
        Logging.d(TAG, ">>ctor");
        this.mListener = listener;
        this.mContext = ContextUtils.getApplicationContext();
    }

    public static boolean hasEarMonitorClass() {
        Class<?> audioClientClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.HnAudioClient");
        Class<?> earReturnClientClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.HnEarReturnClient");
        Class<?> serviceCallbackInterface = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.IAudioServiceCallback");
        return audioClientClass != null && earReturnClientClass != null && serviceCallbackInterface != null;
    }

    @Override
    public void initialize() {
        Logging.d(TAG, "HnAudioClient initialize");
        if (this.mContext == null) {
            Logging.e(TAG, "mContext is null!");
            return;
        }
        if (this.mInitialized) {
            Logging.w(TAG, "already initialized, ignore");
            return;
        }
        try {
            this.mHnAudioClientClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.HnAudioClient");
            this.mHnEarReturnClientClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.HnEarReturnClient");
            Class<?> iAudioServiceCallbackClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.IAudioServiceCallback");
            this.mServiceTypeClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.HnAudioClient$ServiceType");
            this.mParamNameClass = ReflectUtils.safeFindClass("com.hihonor.android.magicx.media.audio.interfaces.HnEarReturnClient$ParameName");
            Object audioServiceCallback = Proxy.newProxyInstance(iAudioServiceCallbackClass.getClassLoader(), new Class[]{iAudioServiceCallbackClass}, (InvocationHandler)this.mAudioServiceCallbackImpl);
            Class[] types = new Class[]{Context.class, iAudioServiceCallbackClass};
            Constructor<?> hnAudioClientClassConstructor = this.mHnAudioClientClass.getConstructor(types);
            this.mHnAudioClient = hnAudioClientClassConstructor.newInstance(this.mContext, audioServiceCallback);
            ReflectUtils.safeCallMethod(this.mHnAudioClientClass, this.mHnAudioClient, "initialize", new Class[0], new Object[0]);
            this.mInitialized = true;
            Logging.d(TAG, "HnAudioClient initialize success");
        }
        catch (Throwable e) {
            Logging.e(TAG, "HnAudioClient initialize failed");
        }
    }

    private void initHnEarReturnClient() {
        Logging.d(TAG, "initHnEarReturnClient");
        this.mHnEarReturnClient = ReflectUtils.safeCallMethod(this.mHnAudioClientClass, this.mHnAudioClient, "createService", new Class[]{this.mServiceTypeClass}, new Object[]{this.mServiceTypeClass.getEnumConstants()[0]});
    }

    private void bindService() throws Throwable {
        List services = (List)ReflectUtils.safeCallMethod(this.mHnAudioClientClass, this.mHnAudioClient, "getSupportedServices", new Class[0], new Object[0]);
        if (services != null) {
            for (Integer service : services) {
                if (service != 1) continue;
                this.initHnEarReturnClient();
                this.mBindServiceSuccess = true;
                Logging.w(TAG, "bind service success");
                break;
            }
        }
    }

    @Override
    public boolean isHardwareEarMonitorSupported() {
        try {
            boolean isDeviceSupported = (Boolean)ReflectUtils.safeCallMethod(this.mHnAudioClientClass, this.mHnAudioClient, "isDeviceSupported", new Class[]{Context.class}, new Object[]{this.mContext});
            Logging.d(TAG, "earMonitor is" + (isDeviceSupported ? " " : "not ") + "supported and bind service " + (this.mBindServiceSuccess ? "success" : "failed"));
            return isDeviceSupported && this.mBindServiceSuccess;
        }
        catch (Throwable e) {
            Logging.e(TAG, "isHardwareEarMonitorSupported false ", e);
            return false;
        }
    }

    @Override
    public int enableHardwareEarMonitor(boolean enable) {
        Logging.d(TAG, ">>enableHardwareEarMonitor " + enable);
        try {
            int ret = (Integer)ReflectUtils.safeCallMethod(this.mHnEarReturnClientClass, this.mHnEarReturnClient, "enableEarReturn", new Class[]{Boolean.TYPE}, new Object[]{enable});
            if (ret != 0) {
                Logging.e(TAG, "enableKaraokeFeature failed ret " + ret);
                return -1;
            }
            this.mEarMonitorEnabled = enable;
        }
        catch (Throwable e) {
            Logging.e(TAG, "enableHardwareEarMonitor failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public int setHardwareEarMonitorVolume(int vol) {
        if (!this.mEarMonitorEnabled) {
            return -7;
        }
        Logging.d(TAG, ">>setHardwareEarMonitorVolume " + vol);
        vol = Math.max(0, Math.min(vol, 100));
        try {
            int ret = (Integer)ReflectUtils.safeCallMethod(this.mHnEarReturnClientClass, this.mHnEarReturnClient, "setParameter", new Class[]{this.mParamNameClass, Integer.TYPE}, new Object[]{this.mParamNameClass.getEnumConstants()[1], vol});
            if (ret != 0) {
                Logging.e(TAG, "setHardwareEarMonitorVolume failed ret " + ret);
                return -1;
            }
        }
        catch (Throwable e) {
            Logging.e(TAG, "setHardwareEarMonitorVolume failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public void destroy() {
        Logging.d(TAG, "karaoke kit destroy");
        this.mListener = null;
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        this.mEarMonitorEnabled = false;
        this.mBindServiceSuccess = false;
        this.mIsDestroyed = true;
        this.destroyImpl();
    }

    private void destroyImpl() {
        try {
            ReflectUtils.safeCallMethod(this.mHnEarReturnClientClass, this.mHnEarReturnClient, "destroy", new Class[0], new Object[0]);
            ReflectUtils.safeCallMethod(this.mHnAudioClientClass, this.mHnAudioClient, "destroy", new Class[0], new Object[0]);
            Logging.d(TAG, "karaoke kit destroy call.");
        }
        catch (Throwable e) {
            Logging.e(TAG, "destroy failed ", e);
        }
    }

    private class AudioServiceCallbackImpl
    implements InvocationHandler {
        private AudioServiceCallbackImpl() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                if ("onResult".equals(method.getName())) {
                    int result = (Integer)args[0];
                    Logging.w(TAG, "onResult: " + result);
                    if (HonorHardwareEarMonitor.this.mIsDestroyed) {
                        Logging.w(TAG, "ignore result after destroy");
                        if (result == 0) {
                            HonorHardwareEarMonitor.this.destroyImpl();
                        }
                        return proxy;
                    }
                    switch (result) {
                        case 0: {
                            HonorHardwareEarMonitor.this.bindService();
                            if (HonorHardwareEarMonitor.this.mListener != null) {
                                HonorHardwareEarMonitor.this.mListener.onInitResult(0);
                            }
                            Logging.d(TAG, "IAudioServiceCallback: HnAudioClient init success");
                            break;
                        }
                        case 1000: {
                            boolean support = HonorHardwareEarMonitor.this.isHardwareEarMonitorSupported();
                            if (HonorHardwareEarMonitor.this.mListener != null) {
                                HonorHardwareEarMonitor.this.mListener.onHardwareEarMonitorSupported(support);
                            }
                            Logging.d(TAG, "IAudioServiceCallback: Karaoke feature bind service success");
                            break;
                        }
                        default: {
                            Logging.e(TAG, "IAudioServiceCallback: onResult error number " + result);
                        }
                    }
                }
            }
            catch (Throwable e) {
                Logging.e(TAG, "AudioServiceCallbackImpl invoke failed ", e);
            }
            return proxy;
        }
    }
}

