/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.rte.Config;
import io.agora.rte.InitialConfig;
import io.agora.rte.NativeLibsLoader;
import io.agora.rte.Observer;
import io.agora.rte.callback.AsyncCallback;
import io.agora.rte.exception.RteException;

public class Rte {
    public static final String TAG = "Rte";
    private long mNativeHandle = 0L;
    private boolean mGetFromBridge = false;

    public static synchronized Rte getFromBridge() throws RteException {
        long handle = Rte.nativeGetFromBridge();
        return new Rte(handle);
    }

    public Rte(InitialConfig initialConfig) {
        NativeLibsLoader.initializeNativeLibs();
        this.mNativeHandle = this.nativeCreateRte(initialConfig);
    }

    private Rte(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mGetFromBridge = true;
    }

    public synchronized void destroy() throws RteException {
        if (this.mNativeHandle != 0L) {
            this.nativeReleaseRte(this.mNativeHandle);
            this.mNativeHandle = 0L;
            if (!this.mGetFromBridge) {
                NativeLibsLoader.deinitializeNativeLibs();
            }
        }
    }

    protected void finalize() {
        try {
            this.destroy();
        }
        catch (RteException e) {
            e.printStackTrace();
        }
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public void initMediaEngine(AsyncCallback callBack) throws RteException {
        this.nativeInitMediaEngine(this.mNativeHandle, callBack);
    }

    public void getConfigs(Config config) throws RteException {
        this.nativeGetConfigs(this.mNativeHandle, config != null ? config.getNativeHandle() : 0L);
    }

    public void setConfigs(Config config) throws RteException {
        this.nativeSetConfigs(this.mNativeHandle, config != null ? config.getNativeHandle() : 0L);
    }

    public void registerObserver(Observer observer) throws RteException {
        this.nativeRegisterObserver(this.mNativeHandle, observer != null ? observer.getNativeHandle() : 0L);
    }

    public void unregisterObserver(Observer observer) throws RteException {
        this.nativeUnregisterObserver(this.mNativeHandle, observer != null ? observer.getNativeHandle() : 0L);
    }

    private static native long nativeGetFromBridge();

    private native long nativeCreateRte(InitialConfig var1);

    private native void nativeReleaseRte(long var1);

    private native void nativeInitMediaEngine(long var1, AsyncCallback var3);

    private native void nativeGetConfigs(long var1, long var3);

    private native void nativeSetConfigs(long var1, long var3);

    private native void nativeRegisterObserver(long var1, long var3);

    private native void nativeUnregisterObserver(long var1, long var3);
}

