/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.gltool;

import android.graphics.Matrix;
import android.graphics.Point;
import androidx.annotation.Nullable;
import io.agora.rtc.ss.gltool.RendererCommon;

public class VideoFrameDrawer {
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final Matrix renderMatrix = new Matrix();

    static void drawTexture(RendererCommon.GlDrawer drawer, int textureId, Matrix matrix, int type, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        Matrix finalMatrix = new Matrix();
        finalMatrix.preConcat(renderMatrix);
        float[] finalGlMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(finalMatrix);
        switch (type) {
            case 1: {
                drawer.drawOes(textureId, finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            case 2: {
                drawer.drawRgb(textureId, finalGlMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    private static int distance(float x0, float y0, float x1, float y1) {
        return (int)Math.round(Math.hypot(x1 - x0, y1 - y0));
    }

    private void calculateTransformedRenderSize(int frameWidth, int frameHeight, @Nullable Matrix renderMatrix) {
        if (renderMatrix == null) {
            this.renderWidth = frameWidth;
            this.renderHeight = frameHeight;
            return;
        }
        renderMatrix.mapPoints(this.dstPoints, srcPoints);
        for (int i = 0; i < 3; ++i) {
            int n = i * 2 + 0;
            this.dstPoints[n] = this.dstPoints[n] * (float)frameWidth;
            int n2 = i * 2 + 1;
            this.dstPoints[n2] = this.dstPoints[n2] * (float)frameHeight;
        }
        this.renderWidth = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
        this.renderHeight = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
    }

    public void drawFrame(int textureId, Matrix matrix, int type, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int width, int height) {
        this.drawFrame(textureId, matrix, type, drawer, additionalRenderMatrix, 0, 0, width, height, width, height, 0);
    }

    public void drawFrame(int textureId, Matrix matrix, int type, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight, int width, int height, int rotation) {
        this.calculateTransformedRenderSize(width, height, additionalRenderMatrix);
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        this.renderMatrix.preRotate((float)rotation);
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            this.renderMatrix.preConcat(additionalRenderMatrix);
        }
        VideoFrameDrawer.drawTexture(drawer, textureId, matrix, type, this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
    }

    public void release() {
    }
}

