/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.ss.gles.GLRender;
import io.agora.rtc.ss.gles.GlUtil;
import io.agora.rtc.ss.gles.ImgTexFormat;
import io.agora.rtc.ss.gles.ImgTexFrame;
import io.agora.rtc.ss.gles.SrcConnector;
import java.lang.ref.WeakReference;

@TargetApi(value=21)
public class ScreenCapture
implements SurfaceTexture.OnFrameAvailableListener {
    private static final boolean DEBUG_ENABLED = false;
    private static final String TAG = ScreenCapture.class.getSimpleName();
    public static final int MEDIA_PROJECTION_REQUEST_CODE = 1001;
    private Context mContext;
    private OnScreenCaptureListener mOnScreenCaptureListener;
    public MediaProjectionManager mMediaProjectManager;
    private MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private int mWidth = 1280;
    private int mHeight = 720;
    public static final int SCREEN_ERROR_SYSTEM_UNSUPPORTED = -1;
    public static final int SCREEN_ERROR_PERMISSION_DENIED = -2;
    public static final int SCREEN_RECORD_STARTED = 4;
    public static final int SCREEN_RECORD_FAILED = 5;
    private static final int RELEASE_SCREEN_THREAD = 1;
    private GLRender mGLRender;
    private int mTextureId;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private boolean mTexInited = false;
    private ImgTexFormat mImgTexFormat;
    private Handler mMainHandler;
    private HandlerThread mScreenSetupThread;
    private HandlerThread mAudioRecordThread;
    private Handler mAudioRecordHandler;
    private Handler mScreenSetupHandler;
    private int mScreenDensity;
    private Runnable mFillFrameRunnable;
    private static final boolean TRACE = false;
    private long mLastTraceTime;
    private long mFrameDrawed;
    private AudioRecord audioRecord;
    private volatile boolean audioRecording = false;
    private boolean localSharing = true;
    private boolean enableAudio = false;
    private int sampleRate = 16000;
    private int channels = 2;
    public SrcConnector<ImgTexFrame> mImgTexSrcConnector;
    private GLRender.GLRenderListener mGLRenderListener = new GLRender.GLRenderListener(){

        @Override
        public void onReady() {
            Log.d((String)TAG, (String)"onReady");
        }

        @Override
        public void onSizeChanged(int width, int height) {
            Log.d((String)TAG, (String)("onSizeChanged : " + width + "*" + height));
            ScreenCapture.this.mWidth = width;
            ScreenCapture.this.mHeight = height;
            ScreenCapture.this.mTexInited = false;
            if (ScreenCapture.this.mVirtualDisplay != null) {
                ScreenCapture.this.mVirtualDisplay.release();
                ScreenCapture.this.mVirtualDisplay = null;
            }
            ScreenCapture.this.mTextureId = GlUtil.createOESTextureObject();
            if (ScreenCapture.this.mSurfaceTexture != null) {
                ScreenCapture.this.mSurfaceTexture.release();
            }
            if (ScreenCapture.this.mSurface != null) {
                ScreenCapture.this.mSurface.release();
            }
            ScreenCapture.this.mSurfaceTexture = new SurfaceTexture(ScreenCapture.this.mTextureId);
            ScreenCapture.this.mSurfaceTexture.setDefaultBufferSize(ScreenCapture.this.mWidth, ScreenCapture.this.mHeight);
            ScreenCapture.this.mSurface = new Surface(ScreenCapture.this.mSurfaceTexture);
            ScreenCapture.this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)ScreenCapture.this);
            Log.d((String)TAG, (String)"mGLRenderListener onSizeChanged: ");
            if (ScreenCapture.this.mVirtualDisplay == null) {
                ScreenCapture.this.start();
            }
        }

        @Override
        public void onDrawFrame() {
            ScreenCapture.this.doDrawFrame();
        }

        @Override
        public void onReleased() {
        }
    };
    public Intent mProjectionIntent;

    public void setEnableAudio(boolean enableAudio) {
        this.enableAudio = enableAudio;
    }

    public void setAudioCaptureParams(int sampleRate, int channels) {
        this.sampleRate = sampleRate;
        this.channels = channels;
    }

    public ScreenCapture(Context context, GLRender render, int density, MediaProjection mediaProjection) {
        if (Build.VERSION.SDK_INT < 21) {
            throw new RuntimeException("Need API level 21");
        }
        if (context == null || render == null) {
            throw new IllegalArgumentException("the context or render must be not null");
        }
        this.mContext = context;
        this.mGLRender = render;
        this.mScreenDensity = density;
        this.mMediaProjection = mediaProjection;
        this.mGLRender.addListener(this.mGLRenderListener);
        this.mImgTexSrcConnector = new SrcConnector();
        this.mMainHandler = new MainHandler(this);
        this.mFillFrameRunnable = new Runnable(){

            @Override
            public void run() {
                ScreenCapture.this.mGLRender.requestRender();
                ScreenCapture.this.mMainHandler.postDelayed(ScreenCapture.this.mFillFrameRunnable, 500L);
            }
        };
    }

    public void stop() {
        this.mMainHandler.removeCallbacks(this.mFillFrameRunnable);
    }

    public void release() {
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacks(this.mFillFrameRunnable);
        }
        this.mGLRender.quit();
        this.doScreenRelease(1);
    }

    public void setOnScreenCaptureListener(OnScreenCaptureListener listener) {
        this.mOnScreenCaptureListener = listener;
    }

    public void onFrameAvailable(SurfaceTexture st) {
        this.mGLRender.requestRender();
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacks(this.mFillFrameRunnable);
            this.mMainHandler.postDelayed(this.mFillFrameRunnable, 100L);
        }
    }

    private void initTexFormat() {
        this.mImgTexFormat = new ImgTexFormat(3, this.mWidth, this.mHeight);
        this.mImgTexSrcConnector.onFormatChanged(this.mImgTexFormat);
    }

    public void doDrawFrame() {
        long pts = System.nanoTime() / 1000L / 1000L;
        try {
            this.mSurfaceTexture.updateTexImage();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("updateTexImage failed, ignore" + e.getMessage()));
            return;
        }
        if (!this.mTexInited) {
            this.mTexInited = true;
            this.initTexFormat();
        }
        float[] texMatrix = new float[16];
        this.mSurfaceTexture.getTransformMatrix(texMatrix);
        ImgTexFrame frame = new ImgTexFrame(this.mImgTexFormat, this.mTextureId, texMatrix, pts);
        try {
            this.mImgTexSrcConnector.onFrameAvailable(frame, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Draw frame failed, ignore");
        }
    }

    public void start() {
        if (this.mSurface == null) {
            return;
        }
        Log.d((String)TAG, (String)"start: setupVirtualDisplay");
        try {
            this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("ScreenCapture", this.mWidth, this.mHeight, this.mScreenDensity, 1, this.mSurface, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"setupVirtualDisplay: createVirtualDisplay error !");
            return;
        }
        Message msg = this.mMainHandler.obtainMessage(4, 0, 0);
        this.mMainHandler.sendMessage(msg);
    }

    public void setLocalSharing(boolean localSharing) {
        this.localSharing = localSharing;
    }

    private void doScreenRelease(int isQuit) {
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
        }
        this.mVirtualDisplay = null;
        this.mSurfaceTexture.release();
    }

    public static interface OnScreenCaptureListener {
        public void onStarted();

        public void onError(int var1);
    }

    private static class MainHandler
    extends Handler {
        private final WeakReference<ScreenCapture> weakCapture;

        public MainHandler(ScreenCapture screenCapture) {
            this.weakCapture = new WeakReference<ScreenCapture>(screenCapture);
        }

        public void handleMessage(Message msg) {
            ScreenCapture screenCapture = (ScreenCapture)this.weakCapture.get();
            if (screenCapture == null) {
                return;
            }
            switch (msg.what) {
                case 4: {
                    if (screenCapture.mOnScreenCaptureListener == null) break;
                    screenCapture.mOnScreenCaptureListener.onStarted();
                    break;
                }
                case 5: {
                    if (screenCapture.mOnScreenCaptureListener == null) break;
                    screenCapture.mOnScreenCaptureListener.onError(msg.arg1);
                    break;
                }
            }
        }
    }
}

