/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.media.AudioFormat;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;

public class AudioCapture {
    private static final String TAG = "AudioCapture";
    private boolean audioRecording = false;
    private HandlerThread mAudioRecordThread = null;
    private Handler mAudioRecordHandler = null;
    private int channels = 1;
    private MediaProjection mMediaProjection;
    private int sampleRate = 16000;
    private AudioRecord audioRecord;
    public static final int NUM_SAMPLES_PER_READ = 1024;
    public static final int BYTES_PER_SAMPLE = 2;
    public static final int BUFFER_SIZE_IN_BYTES = 2048;
    private AudioFrameListener audioFrameListener;
    private int omitDataSize;

    public AudioCapture(int channels, int sampleRate, MediaProjection mMediaProjection) {
        this.channels = channels;
        this.mMediaProjection = mMediaProjection;
        this.sampleRate = sampleRate;
        this.omitDataSize = sampleRate / 100 * channels * 2 * 50;
    }

    public void setAudioFrameListener(AudioFrameListener audioFrameListener) {
        this.audioFrameListener = audioFrameListener;
    }

    public void start() {
        if (Build.VERSION.SDK_INT >= 29) {
            if (this.audioRecording) {
                return;
            }
            if (this.mAudioRecordThread == null) {
                this.mAudioRecordThread = new HandlerThread("SystemPlayoutCaptureThread");
                this.mAudioRecordThread.start();
                this.mAudioRecordHandler = new Handler(this.mAudioRecordThread.getLooper());
            }
            this.mAudioRecordHandler.removeCallbacksAndMessages(null);
            this.mAudioRecordHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    int channelSet = AudioCapture.this.channels == 2 ? 12 : 16;
                    AudioPlaybackCaptureConfiguration config = new AudioPlaybackCaptureConfiguration.Builder(AudioCapture.this.mMediaProjection).addMatchingUsage(1).build();
                    AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(2).setSampleRate(AudioCapture.this.sampleRate).setChannelMask(channelSet).build();
                    AudioCapture.this.audioRecording = true;
                    AudioCapture.this.audioRecord = new AudioRecord.Builder().setAudioFormat(audioFormat).setBufferSizeInBytes(2048).setAudioPlaybackCaptureConfig(config).build();
                    int retryTimes = 0;
                    while (AudioCapture.this.audioRecord.getState() != 1) {
                        AudioCapture.this.audioRecord.release();
                        AudioCapture.this.audioRecord = null;
                        if (retryTimes > 3) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        AudioCapture.this.audioRecord = new AudioRecord.Builder().setAudioFormat(audioFormat).setBufferSizeInBytes(2048).setAudioPlaybackCaptureConfig(config).build();
                        ++retryTimes;
                    }
                    if (AudioCapture.this.audioRecord == null) {
                        Log.e((String)AudioCapture.TAG, (String)("AudioCapture: build AudioRecord failed, alread try " + retryTimes + " times"));
                        return;
                    }
                    AudioCapture.this.audioRecord.startRecording();
                    byte[] capturedAudioSamples = new byte[1024];
                    int recordedCount = 0;
                    while (AudioCapture.this.audioRecording) {
                        AudioCapture.this.audioRecord.read(capturedAudioSamples, 0, 1024);
                        if ((recordedCount += 1024) <= AudioCapture.this.omitDataSize) continue;
                        AudioCapture.this.audioFrameListener.onFrame(capturedAudioSamples, 1024L);
                    }
                }
            }, 1000L);
        }
    }

    public void stop() {
        if (this.audioRecord != null) {
            this.audioRecording = false;
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        if (this.mAudioRecordThread != null) {
            this.mAudioRecordThread.interrupt();
            this.mAudioRecordThread.quit();
            this.mAudioRecordThread = null;
        }
        if (this.mAudioRecordHandler != null) {
            this.mAudioRecordHandler.removeCallbacksAndMessages(null);
            this.mAudioRecordHandler = null;
        }
    }

    public static interface AudioFrameListener {
        public void onFrame(byte[] var1, long var2);
    }
}

