/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.ScreenCaptureParameters;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.ss.gles.GLRender;
import io.agora.rtc.ss.gles.ImgTexFormat;
import io.agora.rtc.ss.gles.ImgTexFrame;
import io.agora.rtc.ss.gles.SinkConnector;
import io.agora.rtc.ss.impl.AudioCapture;
import io.agora.rtc.ss.impl.ScreenCapture;
import io.agora.rtc.ss.impl.ScreenCaptureSource;
import io.agora.rtc.video.VideoEncoderConfiguration;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

@RequiresApi(api=21)
public class ScreenSharing {
    private static final String TAG = ScreenSharing.class.getSimpleName();
    private ScreenCapture mScreenCapture;
    private AudioCapture mAudioCapture;
    private GLRender mScreenGLRender;
    private RtcEngine mRtcEngine;
    private boolean mIsLandSpace = false;
    private ScreenCaptureSource mSCS;
    private Context mContext;
    private boolean isCameraVideoSource = true;
    private int mOrientation = -1;
    private Display display;
    private Handler handler;
    private ResultCallback resultCallback = null;
    private ScreenCaptureParameters screenCaptureParameters = null;
    private VideoEncoderConfiguration currentConfiguration = null;
    private boolean loopbackEnabled = false;
    private static final int EVT_SCREEN_CAPTURE_FAILED = 1;
    private OrientationEventListener eventListener = null;
    private ComponentCallbacks componentCallbacks = null;
    private Runnable notifyTask = new Runnable(){

        @Override
        public void run() {
            WindowManager wm = (WindowManager)ScreenSharing.this.mContext.getApplicationContext().getSystemService("window");
            DisplayMetrics outMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(outMetrics);
            int screenWidth = outMetrics.widthPixels;
            int screenHeight = outMetrics.heightPixels;
            ScreenSharing.this.updateOffscreenPreview(screenWidth, screenHeight);
        }
    };
    private MediaProjectionManager mMediaProjectManager;
    private MediaProjection mediaProjection;
    private HandlerThread mScreenSetupThread;
    private HandlerThread mAudioRecordThread;
    private Handler mAudioRecordHandler;
    private Handler mScreenSetupHandler;
    private static final int MSG_SCREEN_START_SCREEN_ACTIVITY = 1;
    private static final int MSG_SCREEN_INIT_PROJECTION = 2;
    private static final int MSG_SCREEN_START = 3;
    private static final int MSG_SCREEN_RELEASE = 4;
    private static final int MSG_SCREEN_QUIT = 5;
    public static final int SCREEN_STATE_IDLE = 0;
    public static final int SCREEN_STATE_INITIALIZING = 1;
    public static final int SCREEN_STATE_INITIALIZED = 2;
    public static final int SCREEN_STATE_STOPPING = 3;
    public static final int SCREEN_STATE_CAPTURING = 4;
    private Intent mProjectionIntent;
    private AtomicInteger mState;

    public ResultCallback getResultCallback() {
        return this.resultCallback;
    }

    public void setResultCallback(ResultCallback resultCallback) {
        this.resultCallback = resultCallback;
    }

    public ScreenSharing(Context context, RtcEngine rtcEngine) {
        this.mContext = context;
        this.mRtcEngine = rtcEngine;
        this.handleOrientation();
    }

    public void setRtcEngine(RtcEngine mRtcEngine) {
        this.mRtcEngine = mRtcEngine;
    }

    public void updateOffscreenPreview(int width, int height) throws IllegalArgumentException {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid offscreen resolution");
        }
        if (this.mScreenGLRender != null) {
            this.mScreenGLRender.update(width, height);
        }
    }

    private void setupScreenCapture() {
        this.mRtcEngine.enableLocalVideo(true);
        WindowManager wm = (WindowManager)this.mContext.getApplicationContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        if (this.mScreenGLRender == null) {
            this.mScreenGLRender = new GLRender();
        }
        if (this.mScreenCapture != null) {
            this.mScreenCapture.stop();
            this.mScreenCapture.release();
            this.mScreenCapture = null;
        }
        this.mScreenCapture = new ScreenCapture(this.mContext, this.mScreenGLRender, metrics.densityDpi, this.mediaProjection);
        this.mScreenCapture.setLocalSharing(true);
        this.mScreenCapture.setEnableAudio(this.screenCaptureParameters.captureAudio);
        this.mScreenCapture.setAudioCaptureParams(this.screenCaptureParameters.audioCaptureParameters.sampleRate, this.screenCaptureParameters.audioCaptureParameters.channels);
        this.mScreenCapture.mImgTexSrcConnector.connect(new SinkConnector<ImgTexFrame>(){

            @Override
            public void onFormatChanged(Object obj) {
                if (obj instanceof ImgTexFormat) {
                    int width = ((ImgTexFormat)obj).mWidth;
                    int height = ((ImgTexFormat)obj).mHeight;
                    if (ScreenSharing.this.currentConfiguration != null) {
                        if (ScreenSharing.this.mRtcEngine == null) {
                            return;
                        }
                        boolean enable1080p = false;
                        try {
                            enable1080p = Boolean.parseBoolean(ScreenSharing.this.mRtcEngine.getParameter("che.video.mobile_1080p", null));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int maxWidth = enable1080p ? 1920 : 1280;
                        int maxHeight = enable1080p ? 1080 : 720;
                        int setWidth = Math.max(((ScreenSharing)ScreenSharing.this).currentConfiguration.dimensions.width, ((ScreenSharing)ScreenSharing.this).currentConfiguration.dimensions.height);
                        int setHeight = Math.min(((ScreenSharing)ScreenSharing.this).currentConfiguration.dimensions.width, ((ScreenSharing)ScreenSharing.this).currentConfiguration.dimensions.height);
                        float setFactor = (float)setWidth * 1.0f / (float)setHeight;
                        float actualFactor = (float)Math.max(width, height) * 1.0f / (float)Math.min(width, height);
                        if (setFactor < actualFactor) {
                            if (setWidth > maxWidth) {
                                setWidth = maxWidth;
                            }
                            setHeight = (int)((float)setWidth / actualFactor);
                        } else {
                            if (setHeight > maxHeight) {
                                setHeight = maxHeight;
                            }
                            setWidth = (int)((float)setHeight * actualFactor);
                        }
                        Log.d((String)TAG, (String)("onFormatChanged: setVideoEncoderConfiguration   " + ((ScreenSharing)ScreenSharing.this).currentConfiguration.dimensions.height + "  " + ((ScreenSharing)ScreenSharing.this).currentConfiguration.dimensions.width));
                        ScreenSharing.this.mRtcEngine.setVideoEncoderConfiguration(ScreenSharing.this.currentConfiguration);
                    }
                }
            }

            @Override
            public void onFrameAvailable(ImgTexFrame frame, ByteBuffer byteBuffer) {
                if (ScreenSharing.this.mRtcEngine == null) {
                    return;
                }
                if (byteBuffer == null) {
                    ScreenSharing.this.mSCS.getConsumer().consumeTextureFrame(frame.mTextureId, 11, frame.mFormat.mWidth, frame.mFormat.mHeight, 0, frame.pts, frame.mTexMatrix);
                } else {
                    ScreenSharing.this.mSCS.getConsumer().consumeByteBufferFrame(byteBuffer, 4, frame.mFormat.mWidth, frame.mFormat.mHeight, 0, frame.pts);
                }
            }

            @Override
            public void setSurface(Surface surface) {
                Log.i((String)TAG, (String)"setSurface");
            }
        });
        this.mScreenCapture.setOnScreenCaptureListener(new ScreenCapture.OnScreenCaptureListener(){

            @Override
            public void onStarted() {
                Log.d((String)TAG, (String)"Screen Record Started");
            }

            @Override
            public void onError(int err) {
                Log.d((String)TAG, (String)("onError " + err));
                switch (err) {
                    case -1: {
                        break;
                    }
                }
            }
        });
        int screenWidth = wm.getDefaultDisplay().getWidth();
        int screenHeight = wm.getDefaultDisplay().getHeight();
        if (this.mIsLandSpace && screenWidth < screenHeight || !this.mIsLandSpace && screenWidth > screenHeight) {
            screenWidth = wm.getDefaultDisplay().getHeight();
            screenHeight = wm.getDefaultDisplay().getWidth();
        }
        this.setOffscreenPreview(screenWidth, screenHeight);
    }

    public void updateVideoCaptureParameters(ScreenCaptureParameters.VideoCaptureParameters videoCaptureParameters) {
        if (this.mRtcEngine == null) {
            return;
        }
        if (!this.screenCaptureParameters.captureVideo || this.screenCaptureParameters.videoCaptureParameters.width != videoCaptureParameters.width || this.screenCaptureParameters.videoCaptureParameters.height != videoCaptureParameters.height || this.screenCaptureParameters.videoCaptureParameters.framerate != videoCaptureParameters.framerate || this.screenCaptureParameters.videoCaptureParameters.bitrate != videoCaptureParameters.bitrate) {
            if (this.currentConfiguration == null) {
                this.currentConfiguration = new VideoEncoderConfiguration();
            }
            this.currentConfiguration.dimensions = new VideoEncoderConfiguration.VideoDimensions(videoCaptureParameters.width, videoCaptureParameters.height);
            this.currentConfiguration.frameRate = videoCaptureParameters.framerate;
            this.currentConfiguration.bitrate = videoCaptureParameters.bitrate;
            this.currentConfiguration.orientationMode = VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE;
            this.mRtcEngine.setVideoEncoderConfiguration(this.currentConfiguration);
        }
        if (this.screenCaptureParameters.videoCaptureParameters.contentHint != videoCaptureParameters.contentHint) {
            this.mSCS = new ScreenCaptureSource(videoCaptureParameters.contentHint);
            this.mRtcEngine.setVideoSource((IVideoSource)this.mSCS);
        }
    }

    private void deInitModules() {
        if (this.mScreenCapture != null) {
            this.mScreenCapture.release();
            this.mScreenCapture = null;
        }
        if (this.mScreenGLRender != null) {
            this.mScreenGLRender.quit();
            this.mScreenGLRender = null;
        }
        if (this.mSCS != null) {
            this.mSCS.onStop();
        }
        this.loopbackEnabled = false;
        this.eventListener.disable();
        this.eventListener = null;
        this.mContext.unregisterComponentCallbacks(this.componentCallbacks);
        this.componentCallbacks = null;
    }

    public void setSurface(Surface surface) {
    }

    public void setOffscreenPreview(int width, int height) throws IllegalArgumentException {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid offscreen resolution");
        }
        this.mScreenGLRender.init(width, height);
    }

    public void startCapture() {
        this.mScreenSetupHandler.sendEmptyMessage(1);
    }

    public void stopCapture() {
        this.mScreenSetupHandler.sendEmptyMessage(5);
    }

    public void startCaptureInternal() {
        Log.i((String)TAG, (String)"startCapture");
        if (this.screenCaptureParameters.captureAudio) {
            this.startAudioCapture();
        }
        if (this.screenCaptureParameters.captureVideo) {
            this.setUpVideoConfig(this.screenCaptureParameters);
            this.mSCS = new ScreenCaptureSource(this.screenCaptureParameters.videoCaptureParameters.contentHint);
            this.mRtcEngine.setVideoSource((IVideoSource)this.mSCS);
            this.startScreenCapture();
        }
        this.isCameraVideoSource = false;
    }

    private void startAudioCapture() {
        if (this.mAudioCapture != null) {
            this.mAudioCapture.start();
        }
    }

    private void startScreenCapture() {
        if (this.mScreenCapture != null) {
            this.mScreenCapture.start();
        }
    }

    public void stopCaptureInternal() {
        Log.d((String)TAG, (String)"stopCapture: ");
        if (this.mScreenCapture != null) {
            this.mScreenCapture.stop();
            this.mScreenCapture = null;
        }
        if (this.mAudioCapture != null) {
            this.mAudioCapture.stop();
            this.mAudioCapture = null;
            this.loopbackEnabled = false;
            this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.loopback.recording\":false}", new Object[0]));
            this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.external.aec.reference\":false}", new Object[0]));
        }
        if (this.mediaProjection != null) {
            this.mediaProjection.stop();
        }
        this.quitThread();
        this.eventListener.disable();
    }

    public void enableScreenCapture(boolean enable) {
        if (enable) {
            if (this.mScreenCapture != null) {
                return;
            }
            this.mSCS = new ScreenCaptureSource(this.screenCaptureParameters.videoCaptureParameters.contentHint);
            this.mRtcEngine.setVideoSource((IVideoSource)this.mSCS);
            this.setupScreenCapture();
            this.startScreenCapture();
        } else {
            if (this.mScreenCapture == null) {
                return;
            }
            this.mScreenCapture.stop();
            this.mScreenCapture.release();
            this.mScreenCapture = null;
            this.mRtcEngine.setVideoSource(null);
        }
    }

    public void enableAudioCapture(boolean enable) {
        if (enable) {
            if (this.mAudioCapture != null) {
                return;
            }
            if (this.mRtcEngine == null) {
                return;
            }
            this.setupAudioCapture();
            this.startAudioCapture();
        } else {
            if (this.mAudioCapture == null) {
                return;
            }
            this.mAudioCapture.stop();
            this.mAudioCapture = null;
            this.loopbackEnabled = false;
            this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.loopback.recording\":false}", new Object[0]));
            this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.external.aec.reference\":false}", new Object[0]));
        }
    }

    public void init(ScreenCaptureParameters screenCaptureParameters) {
        Log.i((String)TAG, (String)("init ScreenCaptureParameters:" + screenCaptureParameters.toString()));
        this.screenCaptureParameters = screenCaptureParameters;
        this.handler = new Handler(Looper.getMainLooper());
        this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.video.has_intra_request\": false}", new Object[0]));
        this.display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        if (screenCaptureParameters.captureVideo && !this.mRtcEngine.isTextureEncodeSupported()) {
            throw new RuntimeException("Can not work on device do not supporting texture" + this.mRtcEngine.isTextureEncodeSupported());
        }
        this.initScreenSetupThread();
    }

    public void destroy() {
        this.deInitModules();
    }

    private void setUpVideoConfig(ScreenCaptureParameters screenCaptureParameters) {
        VideoEncoderConfiguration.ORIENTATION_MODE om;
        VideoEncoderConfiguration.FRAME_RATE fr;
        int width = screenCaptureParameters.videoCaptureParameters.width;
        int height = screenCaptureParameters.videoCaptureParameters.height;
        int frameRate = screenCaptureParameters.videoCaptureParameters.framerate;
        int bitRate = screenCaptureParameters.videoCaptureParameters.bitrate;
        int orientationMode = 0;
        switch (frameRate) {
            case 1: {
                fr = VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_1;
                break;
            }
            case 7: {
                fr = VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_7;
                break;
            }
            case 10: {
                fr = VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_10;
                break;
            }
            case 24: {
                fr = VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_24;
                break;
            }
            case 30: {
                fr = VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_30;
                break;
            }
            default: {
                fr = VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_15;
            }
        }
        switch (orientationMode) {
            case 1: {
                om = VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_LANDSCAPE;
                break;
            }
            case 2: {
                om = VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_PORTRAIT;
                break;
            }
            default: {
                om = VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE;
            }
        }
        Log.i((String)TAG, (String)("setUpVideoConfig:" + width + "," + height));
        this.currentConfiguration = new VideoEncoderConfiguration(new VideoEncoderConfiguration.VideoDimensions(width, height), fr, bitRate, om);
        this.currentConfiguration.orientationMode = VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE;
        this.mRtcEngine.setVideoEncoderConfiguration(this.currentConfiguration);
    }

    private void handleOrientation() {
        this.eventListener = new OrientationEventListener(this.mContext, 3){

            public void onOrientationChanged(int orientation) {
                if (orientation == -1) {
                    return;
                }
                if (orientation > 340 || orientation < 20 || orientation > 70 && orientation < 110 || orientation > 160 && orientation < 200 || orientation > 250 && orientation < 290) {
                    ScreenSharing.this.notifyOrientationChange();
                }
            }
        };
        if (this.eventListener.canDetectOrientation()) {
            this.eventListener.enable();
        }
        this.componentCallbacks = new ComponentCallbacks(){

            public void onConfigurationChanged(Configuration newConfig) {
                ScreenSharing.this.notifyOrientationChange();
            }

            public void onLowMemory() {
            }
        };
        this.mContext.registerComponentCallbacks(this.componentCallbacks);
    }

    private void notifyOrientationChange() {
        if (this.display == null) {
            return;
        }
        int orientation = this.display.getRotation();
        if (orientation == this.mOrientation) {
            return;
        }
        switch (orientation) {
            case 0: {
                this.mOrientation = 0;
                this.notifyVirtualDisplayUpdate();
                break;
            }
            case 1: {
                this.mOrientation = 1;
                this.notifyVirtualDisplayUpdate();
                break;
            }
            case 2: {
                this.mOrientation = 2;
                this.notifyVirtualDisplayUpdate();
                break;
            }
            case 3: {
                this.mOrientation = 3;
                this.notifyVirtualDisplayUpdate();
            }
        }
    }

    private void notifyVirtualDisplayUpdate() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.postDelayed(this.notifyTask, 1000L);
    }

    @RequiresApi(api=21)
    private void doScreenSetup() {
        Log.d((String)TAG, (String)"doScreenSetup");
        if (this.mMediaProjectManager == null) {
            this.mMediaProjectManager = (MediaProjectionManager)this.mContext.getSystemService("media_projection");
        }
        Intent intent = new Intent(this.mContext, LocalScreenCaptureAssistantActivity.class);
        intent.addFlags(0x10000000);
        LocalScreenCaptureAssistantActivity.mScreenSharing = this;
        this.mContext.startActivity(intent);
    }

    public void onScreenSharingRequest(int requestCode, int resultCode, Intent intent) {
        if (resultCode != -1) {
            Log.e((String)TAG, (String)"onScreenSharingRequest: user decline request to share screen !");
            this.resultCallback.onResult(1, 16);
            return;
        }
        if (intent == null) {
            Log.e((String)TAG, (String)"onScreenSharingRequest: intent is null");
            return;
        }
        this.mediaProjection = this.mMediaProjectManager.getMediaProjection(resultCode, intent);
        if (this.screenCaptureParameters.captureVideo) {
            this.setupScreenCapture();
        }
        if (this.screenCaptureParameters.captureAudio) {
            this.setupAudioCapture();
        }
        this.mScreenSetupHandler.sendEmptyMessage(3);
    }

    private void setupAudioCapture() {
        if (this.mAudioCapture != null) {
            this.mAudioCapture.stop();
            this.mAudioCapture = null;
        }
        final int[] audioPushPosition = new int[]{3};
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        if (this.screenCaptureParameters.audioCaptureParameters.allowCaptureCurrentApp) {
            audioManager.setAllowedCapturePolicy(1);
        } else {
            audioManager.setAllowedCapturePolicy(3);
        }
        this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.loopback.signal.volume\":%d}", this.screenCaptureParameters.audioCaptureParameters.captureSignalVolume));
        this.mRtcEngine.enableLocalAudio(true);
        this.mAudioCapture = new AudioCapture(this.screenCaptureParameters.audioCaptureParameters.channels, this.screenCaptureParameters.audioCaptureParameters.sampleRate, this.mediaProjection);
        this.mAudioCapture.setAudioFrameListener(new AudioCapture.AudioFrameListener(){

            @Override
            public void onFrame(byte[] buffer, long length) {
                if (ScreenSharing.this.mRtcEngine != null) {
                    if (!ScreenSharing.this.loopbackEnabled) {
                        ScreenSharing.this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.external.aec.reference\":true}", new Object[0]));
                        ScreenSharing.this.mRtcEngine.setParameters(String.format(Locale.US, "{\"che.audio.loopback.recording\":true}", new Object[0]));
                        ScreenSharing.this.loopbackEnabled = true;
                    }
                    ScreenSharing.this.mRtcEngine.pushExternalAudioFrame(buffer, length, ((ScreenSharing)ScreenSharing.this).screenCaptureParameters.audioCaptureParameters.sampleRate, ((ScreenSharing)ScreenSharing.this).screenCaptureParameters.audioCaptureParameters.channels, 2, audioPushPosition[0]);
                }
            }
        });
    }

    private void initScreenSetupThread() {
        this.mScreenSetupThread = new HandlerThread("screen_setup_thread", 5);
        this.mScreenSetupThread.start();
        this.mScreenSetupHandler = new Handler(this.mScreenSetupThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        ScreenSharing.this.doScreenSetup();
                        break;
                    }
                    case 2: {
                        ScreenSharing.this.onScreenSharingRequest(msg.arg1, msg.arg2, ScreenSharing.this.mProjectionIntent);
                        break;
                    }
                    case 3: {
                        ScreenSharing.this.startCaptureInternal();
                        break;
                    }
                    case 5: {
                        ScreenSharing.this.stopCaptureInternal();
                    }
                }
            }
        };
    }

    private void quitThread() {
        try {
            this.mScreenSetupThread.join();
        }
        catch (InterruptedException e) {
            Log.d((String)TAG, (String)("quitThread " + Log.getStackTraceString((Throwable)e)));
        }
        finally {
            this.mScreenSetupThread = null;
        }
    }

    public static class LocalScreenCaptureAssistantActivity
    extends Activity {
        public static ScreenSharing mScreenSharing;

        @RequiresApi(api=21)
        public void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.requestWindowFeature(1);
            if (mScreenSharing == null) {
                return;
            }
            if (mScreenSharing.mMediaProjectManager == null) {
                mScreenSharing.mMediaProjectManager = (MediaProjectionManager)this.getSystemService("media_projection");
            }
            this.startActivityForResult(mScreenSharing.mMediaProjectManager.createScreenCaptureIntent(), 1001);
        }

        public void onActivityResult(int requestCode, int resultCode, Intent intent) {
            if (mScreenSharing != null) {
                Message msg = new Message();
                msg.what = 2;
                msg.arg1 = requestCode;
                msg.arg2 = resultCode;
                mScreenSharing.mProjectionIntent = intent;
                mScreenSharing.mScreenSetupHandler.removeMessages(2);
                mScreenSharing.mScreenSetupHandler.sendMessage(msg);
            }
            mScreenSharing = null;
            this.finish();
        }
    }

    public static class ScreenCaptureAssistantActivity
    extends Activity {
        public static ScreenSharing mScreenSharing;

        @RequiresApi(api=21)
        public void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.requestWindowFeature(1);
            if (mScreenSharing.mMediaProjectManager == null) {
                mScreenSharing.mMediaProjectManager = (MediaProjectionManager)this.getSystemService("media_projection");
            }
            this.startActivityForResult(mScreenSharing.mMediaProjectManager.createScreenCaptureIntent(), 1001);
        }

        public void onActivityResult(int requestCode, int resultCode, Intent intent) {
            if (mScreenSharing != null) {
                Message msg = new Message();
                msg.what = 2;
                msg.arg1 = requestCode;
                msg.arg2 = resultCode;
                mScreenSharing.mProjectionIntent = intent;
                mScreenSharing.mScreenSetupHandler.removeMessages(2);
                mScreenSharing.mScreenSetupHandler.sendMessage(msg);
            }
            mScreenSharing = null;
            this.finish();
        }
    }

    public static interface ResultCallback {
        public void onResult(int var1, int var2);
    }
}

