/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.ScreenCaptureParameters;
import io.agora.rtc.internal.ExternalScreenSharingCallback;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.ss.aidl.INotification;
import io.agora.rtc.ss.aidl.IScreenSharing;
import io.agora.rtc.ss.impl.LocalScreenSharingService;
import io.agora.rtc.ss.impl.ScreenSharingService;
import io.agora.rtc.video.VideoEncoderConfiguration;
import java.io.Serializable;

public class ScreenSharingClient {
    private static final String VERSION = "1.0";
    private static final String TAG = ScreenSharingClient.class.getSimpleName();
    private static IScreenSharing mExternalScreenShareSvc;
    private static LocalScreenSharingService mLocalScreenShareSvc;
    private static volatile ScreenSharingClient mInstance;
    private Context context;
    private ScreenCaptureParameters mCurrentParameters = null;
    private ExternalScreenSharingCallback mExternalCallback = null;
    private RtcEngine mRtcEngine = null;
    private volatile boolean stopCalled = false;
    private ServiceConnection mExternalScreenShareConn = null;
    private ServiceConnection mLocalScreenShareConn = null;
    private INotification mNotification = new INotification.Stub(){

        @Override
        public void onEvent(int event, int error) throws RemoteException {
            Log.d((String)TAG, (String)("remote onEvent received: " + event + "error:" + error));
            Log.d((String)TAG, (String)("onEvent: mExternalCallback != null ? " + (ScreenSharingClient.this.mExternalCallback != null)));
            if (ScreenSharingClient.this.mExternalCallback != null) {
                ScreenSharingClient.this.mExternalCallback.onExtenalScreenCaptureEvent(event, error);
            }
        }
    };

    private ScreenSharingClient() {
    }

    public static String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScreenSharingClient getInstance() {
        if (mInstance != null) return mInstance;
        Class<ScreenSharingClient> clazz = ScreenSharingClient.class;
        synchronized (ScreenSharingClient.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ScreenSharingClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void switchVideoSource() {
    }

    public static void startScreenCapture(Context context, RtcEngine rtcEngine, ScreenCaptureParameters screenCaptureParameters, ExternalScreenSharingCallback callback) {
        Logging.d((String)("startScreenCapture :" + screenCaptureParameters.toString()));
        ScreenSharingClient.getInstance().context = context;
        ScreenSharingClient.getInstance().startLocalScreenSharing(context, rtcEngine, screenCaptureParameters, callback);
    }

    public void checkParameters(ScreenCaptureParameters screenCaptureParameters) {
        ScreenCaptureParameters.VideoCaptureParameters videoCaptureParameters = screenCaptureParameters.videoCaptureParameters;
        if (videoCaptureParameters.framerate <= 0) {
            videoCaptureParameters.framerate = 15;
        }
        if (videoCaptureParameters.width < 0 || videoCaptureParameters.height < 0) {
            videoCaptureParameters.width = 0;
            videoCaptureParameters.height = 0;
        }
        if (videoCaptureParameters.bitrate <= -3) {
            videoCaptureParameters.bitrate = 0;
        }
        if (videoCaptureParameters.contentHint < 0 || videoCaptureParameters.contentHint > 2) {
            videoCaptureParameters.contentHint = 2;
        }
        ScreenCaptureParameters.AudioCaptureParameters audioCaptureParameters = screenCaptureParameters.audioCaptureParameters;
        if (audioCaptureParameters.captureSignalVolume < 0 || audioCaptureParameters.captureSignalVolume > 100) {
            audioCaptureParameters.captureSignalVolume = 100;
        }
        if (audioCaptureParameters.channels < 1 || audioCaptureParameters.channels > 2) {
            audioCaptureParameters.channels = 2;
        }
        switch (audioCaptureParameters.sampleRate) {
            case 16000: 
            case 32000: 
            case 44100: 
            case 48000: {
                break;
            }
            default: {
                audioCaptureParameters.sampleRate = 16000;
            }
        }
        Log.d((String)TAG, (String)("checkParameters checked:  " + screenCaptureParameters.toString()));
    }

    @TargetApi(value=21)
    public void startLocalScreenSharing(Context context, RtcEngine rtcEngine, ScreenCaptureParameters screenCaptureParameters, ExternalScreenSharingCallback callback) {
        if (screenCaptureParameters == null) {
            return;
        }
        if (!screenCaptureParameters.captureVideo && !screenCaptureParameters.captureAudio) {
            return;
        }
        this.checkParameters(screenCaptureParameters);
        this.mCurrentParameters = screenCaptureParameters;
        this.mExternalCallback = callback;
        this.mRtcEngine = rtcEngine;
        if (mLocalScreenShareSvc != null) {
            this.stop();
        }
        this.mLocalScreenShareConn = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                Log.d((String)TAG, (String)("local onServiceConnected: " + Thread.currentThread().getName()));
                LocalScreenSharingService.LocalBinder localBinder = (LocalScreenSharingService.LocalBinder)service;
                mLocalScreenShareSvc = localBinder.getService();
                mLocalScreenShareSvc.setExternalScreenSharingCallback(ScreenSharingClient.this.mExternalCallback);
                mLocalScreenShareSvc.setRtcEngine(ScreenSharingClient.this.mRtcEngine);
                mLocalScreenShareSvc.startCapture();
            }

            public void onServiceDisconnected(ComponentName name) {
                Log.d((String)TAG, (String)"local onServiceDisconnected: ");
                mLocalScreenShareSvc = null;
            }
        };
        Intent intent = new Intent(context, LocalScreenSharingService.class);
        intent.putExtra("capture_params", (Serializable)this.mCurrentParameters);
        context.bindService(intent, this.mLocalScreenShareConn, 1);
    }

    @TargetApi(value=21)
    public void startExternalScreenSharing(Context context, ScreenCaptureParameters screenCaptureParameters, ExternalScreenSharingCallback callback) {
        this.mCurrentParameters = screenCaptureParameters;
        this.mExternalCallback = callback;
        this.mExternalScreenShareConn = new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder service) {
                mExternalScreenShareSvc = IScreenSharing.Stub.asInterface(service);
                try {
                    Log.d((String)TAG, (String)"onServiceConnected: register callback");
                    mExternalScreenShareSvc.registerCallback(ScreenSharingClient.this.mNotification);
                    mExternalScreenShareSvc.startShare();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
                }
            }

            public void onServiceDisconnected(ComponentName className) {
                Log.d((String)TAG, (String)"onServiceDisconnected: ");
                mExternalScreenShareSvc = null;
            }
        };
        if (mExternalScreenShareSvc == null) {
            Intent intent = new Intent(context, ScreenSharingService.class);
            intent.putExtra("capture_params", (Serializable)this.mCurrentParameters);
            context.bindService(intent, this.mExternalScreenShareConn, 1);
        } else {
            try {
                mExternalScreenShareSvc.startShare();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        }
    }

    public static void updateScreenCaptureParameters(boolean enableVideo, boolean enableAudio, ScreenCaptureParameters.VideoCaptureParameters videoCaptureParameters) {
        ScreenSharingClient.getInstance().updateScreenCaptureParametersInternal(enableVideo, enableAudio, videoCaptureParameters);
    }

    public void updateScreenCaptureParametersInternal(boolean enableVideo, boolean enableAudio, ScreenCaptureParameters.VideoCaptureParameters videoCaptureParameters) {
        if (this.mCurrentParameters == null) {
            Log.e((String)TAG, (String)"updateScreenCaptureParameters: CaptureParameter not set yet");
            return;
        }
        if (this.mCurrentParameters.captureVideo != enableVideo) {
            if (mExternalScreenShareSvc != null) {
                try {
                    mExternalScreenShareSvc.enableScreenCapture(enableVideo);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            } else if (mLocalScreenShareSvc != null) {
                mLocalScreenShareSvc.enableScreenCapture(enableVideo);
            }
            this.mCurrentParameters.captureVideo = enableVideo;
        }
        if (videoCaptureParameters.framerate <= 0) {
            videoCaptureParameters.framerate = 15;
        }
        if (videoCaptureParameters.width < 0 || videoCaptureParameters.height < 0) {
            videoCaptureParameters.width = 0;
            videoCaptureParameters.height = 0;
        }
        if (videoCaptureParameters.bitrate <= -3) {
            videoCaptureParameters.bitrate = 0;
        }
        if (videoCaptureParameters.contentHint < 0 || videoCaptureParameters.contentHint > 2) {
            videoCaptureParameters.contentHint = 2;
        }
        Log.d((String)TAG, (String)("updateScreenCaptureParametersInternal checked: " + videoCaptureParameters.toString()));
        if (enableVideo && !this.mCurrentParameters.videoCaptureParameters.equals((Object)videoCaptureParameters)) {
            mLocalScreenShareSvc.updateVideoCaptureParameters(videoCaptureParameters);
            this.mCurrentParameters.videoCaptureParameters = new ScreenCaptureParameters.VideoCaptureParameters();
            this.mCurrentParameters.videoCaptureParameters.bitrate = videoCaptureParameters.bitrate;
            this.mCurrentParameters.videoCaptureParameters.width = videoCaptureParameters.width;
            this.mCurrentParameters.videoCaptureParameters.height = videoCaptureParameters.height;
            this.mCurrentParameters.videoCaptureParameters.contentHint = videoCaptureParameters.contentHint;
            this.mCurrentParameters.videoCaptureParameters.framerate = videoCaptureParameters.framerate;
        }
        if (this.mCurrentParameters.captureAudio != enableAudio) {
            if (mExternalScreenShareSvc != null) {
                try {
                    mExternalScreenShareSvc.enableAudioCapture(enableAudio);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            } else if (mLocalScreenShareSvc != null) {
                mLocalScreenShareSvc.enableAudioCapture(enableAudio);
            }
            this.mCurrentParameters.captureAudio = enableAudio;
        }
    }

    @TargetApi(value=21)
    public void startExternalScreenSharing(Context context, String appId, String token, String channelName, int uid, VideoEncoderConfiguration vec) {
        Intent intent = new Intent(context, ScreenSharingService.class);
        intent.putExtra("app_id", appId);
        intent.putExtra("access_token", token);
        intent.putExtra("channel", channelName);
        intent.putExtra("uid", uid);
        intent.putExtra("width", vec.dimensions.width);
        intent.putExtra("height", vec.dimensions.height);
        intent.putExtra("frame_rate", vec.frameRate);
        intent.putExtra("bit_rate", vec.bitrate);
        intent.putExtra("orientation_mode", vec.orientationMode.getValue());
        context.bindService(intent, this.mExternalScreenShareConn, 1);
    }

    public static void stopScreenCapture() {
        ScreenSharingClient.getInstance().stop();
    }

    @TargetApi(value=21)
    public void stop() {
        this.stopCalled = true;
        if (mExternalScreenShareSvc != null) {
            try {
                mExternalScreenShareSvc.stopShare();
                mExternalScreenShareSvc.unregisterCallback(this.mNotification);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
            finally {
                mExternalScreenShareSvc = null;
            }
        }
        if (this.mExternalScreenShareConn != null) {
            this.context.unbindService(this.mExternalScreenShareConn);
        }
        if (mLocalScreenShareSvc != null) {
            mLocalScreenShareSvc.stopCapture();
            mLocalScreenShareSvc.setExternalScreenSharingCallback(null);
            mLocalScreenShareSvc.stopSelf();
            mLocalScreenShareSvc = null;
        }
        if (this.mLocalScreenShareConn != null) {
            this.context.unbindService(this.mLocalScreenShareConn);
        }
    }

    @TargetApi(value=21)
    public void renewToken(String token) {
        if (mExternalScreenShareSvc != null) {
            try {
                mExternalScreenShareSvc.renewToken(token);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
        } else {
            Log.e((String)TAG, (String)"screen sharing service not exist");
        }
    }
}

