/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.ss.gles.GLRender;
import io.agora.rtc.ss.gles.GlUtil;
import io.agora.rtc.ss.gles.ImgTexFormat;
import io.agora.rtc.ss.gles.ImgTexFrame;
import io.agora.rtc.ss.gles.SrcConnector;
import io.agora.rtc.ss.impl.VideoDecimator;
import io.agora.rtc.video.TextureRenderer;
import java.lang.ref.WeakReference;

@TargetApi(value=21)
public class ScreenCapture
implements SurfaceTexture.OnFrameAvailableListener {
    private static final boolean DEBUG_ENABLED = false;
    private static final String TAG = ScreenCapture.class.getSimpleName();
    public static final int MEDIA_PROJECTION_REQUEST_CODE = 1001;
    private OnScreenCaptureListener mOnScreenCaptureListener;
    private MediaProjection mMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private int mWidth = 1280;
    private int mHeight = 720;
    public static final int SCREEN_ERROR_SYSTEM_UNSUPPORTED = -1;
    public static final int SCREEN_ERROR_PERMISSION_DENIED = -2;
    public static final int SCREEN_RECORD_STARTED = 4;
    public static final int SCREEN_RECORD_FAILED = 5;
    private GLRender mGLRender;
    private int mTextureId;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private boolean mTexInited = false;
    private ImgTexFormat mImgTexFormat;
    private int mDstTextureId;
    private int fbo;
    private TextureRenderer textureRenderer;
    private Handler mMainHandler;
    private int mScreenDensity;
    private Runnable mFillFrameRunnable;
    private static final boolean TRACE = false;
    private long mLastTraceTime;
    private long mFrameDrawed;
    private int frameRate = 15;
    private VideoDecimator videoDecimator;
    public SrcConnector<ImgTexFrame> mImgTexSrcConnector;
    private GLRender.GLRenderListener mGLRenderListener = new GLRender.GLRenderListener(){

        @Override
        public void onReady() {
            Log.d((String)TAG, (String)"onReady");
        }

        @Override
        public void onSizeChanged(int width, int height) {
            Log.d((String)TAG, (String)("onSizeChanged : " + width + "*" + height));
            ScreenCapture.this.mWidth = width;
            ScreenCapture.this.mHeight = height;
            ScreenCapture.this.mTexInited = false;
            if (ScreenCapture.this.mVirtualDisplay != null) {
                ScreenCapture.this.mVirtualDisplay.release();
                ScreenCapture.this.mVirtualDisplay = null;
            }
            ScreenCapture.this.mTextureId = GlUtil.createOESTextureObject();
            int[] framebuffer = new int[1];
            ScreenCapture.this.mDstTextureId = GlUtil.createOffScreenTexture2DObject(framebuffer, width, height);
            ScreenCapture.this.fbo = framebuffer[0];
            if (ScreenCapture.this.mSurfaceTexture != null) {
                ScreenCapture.this.mSurfaceTexture.release();
            }
            if (ScreenCapture.this.mSurface != null) {
                ScreenCapture.this.mSurface.release();
            }
            ScreenCapture.this.textureRenderer = new TextureRenderer(true);
            ScreenCapture.this.mSurfaceTexture = new SurfaceTexture(ScreenCapture.this.mTextureId);
            ScreenCapture.this.mSurfaceTexture.setDefaultBufferSize(ScreenCapture.this.mWidth, ScreenCapture.this.mHeight);
            ScreenCapture.this.mSurface = new Surface(ScreenCapture.this.mSurfaceTexture);
            ScreenCapture.this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)ScreenCapture.this);
            Log.d((String)TAG, (String)"mGLRenderListener onSizeChanged: ");
            if (ScreenCapture.this.mVirtualDisplay == null) {
                ScreenCapture.this.start();
            }
        }

        @Override
        public void onDrawFrame() {
            ScreenCapture.this.doDrawFrame();
        }

        @Override
        public void onReleased() {
            GLES20.glDeleteBuffers((int)1, (int[])new int[ScreenCapture.this.fbo], (int)0);
            GLES20.glDeleteTextures((int)2, (int[])new int[]{ScreenCapture.this.mDstTextureId, ScreenCapture.this.mTextureId}, (int)0);
        }
    };
    public Intent mProjectionIntent;

    public void setTargetFramerate(int framerate) {
        this.frameRate = framerate;
    }

    public ScreenCapture(Context context, GLRender render, int density, MediaProjection mediaProjection) {
        if (Build.VERSION.SDK_INT < 21) {
            throw new RuntimeException("Need API level 21");
        }
        if (context == null || render == null) {
            throw new IllegalArgumentException("the context or render must be not null");
        }
        this.mGLRender = render;
        this.mScreenDensity = density;
        this.mMediaProjection = mediaProjection;
        this.mGLRender.addListener(this.mGLRenderListener);
        this.mImgTexSrcConnector = new SrcConnector();
        this.mMainHandler = new MainHandler(this);
        this.mFillFrameRunnable = new Runnable(){

            @Override
            public void run() {
                ScreenCapture.this.videoDecimator.updateIncomingFramerate();
                ScreenCapture.this.mGLRender.requestRender();
                ScreenCapture.this.mMainHandler.postDelayed(ScreenCapture.this.mFillFrameRunnable, 100L);
            }
        };
        this.videoDecimator = new VideoDecimator();
    }

    public void stop() {
        this.mMainHandler.removeCallbacks(this.mFillFrameRunnable);
        this.videoDecimator.reset();
    }

    public void release() {
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacks(this.mFillFrameRunnable);
        }
        this.doScreenRelease();
        this.mGLRender.quit();
    }

    public void setOnScreenCaptureListener(OnScreenCaptureListener listener) {
        this.mOnScreenCaptureListener = listener;
    }

    public void onFrameAvailable(SurfaceTexture st) {
        this.videoDecimator.updateIncomingFramerate();
        if (this.videoDecimator.dropFrame()) {
            return;
        }
        this.mGLRender.requestRender();
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacks(this.mFillFrameRunnable);
            this.mMainHandler.postDelayed(this.mFillFrameRunnable, 100L);
        }
    }

    private void initTexFormat() {
        this.mImgTexFormat = new ImgTexFormat(4, this.mWidth, this.mHeight);
        this.mImgTexSrcConnector.onFormatChanged(this.mImgTexFormat);
    }

    public void doDrawFrame() {
        long pts = System.nanoTime() / 1000L / 1000L;
        try {
            this.mSurfaceTexture.updateTexImage();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("updateTexImage failed, ignore" + e.getMessage()));
            return;
        }
        if (!this.mTexInited) {
            this.mTexInited = true;
            this.initTexFormat();
        }
        float[] texMatrix = new float[16];
        this.mSurfaceTexture.getTransformMatrix(texMatrix);
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindFramebuffer((int)36160, (int)this.fbo);
        GLES20.glBindTexture((int)3553, (int)this.mDstTextureId);
        this.textureRenderer.draw(this.mTextureId, texMatrix);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glFinish();
        ImgTexFrame frame = new ImgTexFrame(this.mImgTexFormat, this.mDstTextureId, texMatrix, pts);
        try {
            this.mImgTexSrcConnector.onFrameAvailable(frame, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Draw frame failed, ignore");
        }
    }

    public void start() {
        if (this.mSurface == null) {
            return;
        }
        Log.d((String)TAG, (String)"start: setupVirtualDisplay");
        try {
            this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("ScreenCapture", this.mWidth, this.mHeight, this.mScreenDensity, 1, this.mSurface, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"setupVirtualDisplay: createVirtualDisplay error !");
            return;
        }
        Message msg = this.mMainHandler.obtainMessage(4, 0, 0);
        this.mMainHandler.sendMessage(msg);
        this.videoDecimator.setTargetFramerate(this.frameRate);
    }

    private void doScreenRelease() {
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
        }
        this.mVirtualDisplay = null;
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
        this.mSurfaceTexture = null;
    }

    public static interface OnScreenCaptureListener {
        public void onStarted();

        public void onError(int var1);
    }

    private static class MainHandler
    extends Handler {
        private final WeakReference<ScreenCapture> weakCapture;

        public MainHandler(ScreenCapture screenCapture) {
            this.weakCapture = new WeakReference<ScreenCapture>(screenCapture);
        }

        public void handleMessage(Message msg) {
            ScreenCapture screenCapture = (ScreenCapture)this.weakCapture.get();
            if (screenCapture == null) {
                return;
            }
            switch (msg.what) {
                case 4: {
                    if (screenCapture.mOnScreenCaptureListener == null) break;
                    screenCapture.mOnScreenCaptureListener.onStarted();
                    break;
                }
                case 5: {
                    if (screenCapture.mOnScreenCaptureListener == null) break;
                    screenCapture.mOnScreenCaptureListener.onError(msg.arg1);
                    break;
                }
            }
        }
    }
}

