/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.impl;

import android.util.Log;

public class VideoDecimator {
    private static final String TAG = "VideoDecimator";
    private float overshootModifier;
    private int dropCount;
    private int keepCount;
    private float targetFrameRate;
    private float incomingFrameRate;
    private int maxFrameRate = 30;
    private long[] incomingFrameTimes = new long[FrameCountHistorySize];
    private boolean enableTemoralDecimation = true;
    private boolean dropNextFrame = false;
    private static int FrameCountHistorySize = 90;
    private static int FrameShitoryWindowMs = 2000;

    public void reset() {
        this.overshootModifier = 0.0f;
        this.dropCount = 0;
        this.keepCount = 0;
        this.targetFrameRate = 30.0f;
        this.incomingFrameRate = 0.0f;
        this.maxFrameRate = 30;
        this.enableTemoralDecimation = true;
        this.incomingFrameTimes = new long[FrameCountHistorySize];
    }

    public void enableTemporalDecimation(boolean enable) {
        this.enableTemoralDecimation = enable;
    }

    public int setMaxFramerate(int maxFrameRate) {
        if (maxFrameRate <= 0) {
            Log.w((String)TAG, (String)"setMaxFramerate invalid max frame rate");
            return -1;
        }
        this.maxFrameRate = maxFrameRate;
        if (this.targetFrameRate > (float)maxFrameRate) {
            this.targetFrameRate = maxFrameRate;
        }
        return 0;
    }

    public int setTargetFramerate(float framerate) {
        if ((double)framerate < 0.1) {
            Log.w((String)TAG, (String)"setTargetFramerate invalid frame rate ");
            return -1;
        }
        this.targetFrameRate = framerate > (float)this.maxFrameRate ? (float)this.maxFrameRate : framerate;
        return 0;
    }

    public float getTargetFrameRate() {
        return this.targetFrameRate;
    }

    public boolean dropFrame() {
        if (!this.enableTemoralDecimation) {
            return false;
        }
        if (this.incomingFrameRate <= 0.0f) {
            return false;
        }
        int incoming = Math.round(this.incomingFrameRate);
        if (this.targetFrameRate == 0.0f) {
            return true;
        }
        boolean drop = false;
        if ((float)incoming > this.targetFrameRate) {
            int overshoot = (int)(this.overshootModifier + ((float)incoming - this.targetFrameRate));
            if (overshoot < 0) {
                overshoot = 0;
                this.overshootModifier = 0.0f;
            }
            if (overshoot != 0 && 2 * overshoot < incoming) {
                if (this.dropCount != 0) {
                    this.dropCount = 0;
                    return true;
                }
                int dropVar = incoming / overshoot;
                if (this.keepCount > dropVar) {
                    drop = true;
                    this.overshootModifier = (float)(-(incoming % overshoot)) / 3.0f;
                    this.keepCount = 1;
                } else {
                    ++this.keepCount;
                }
            } else {
                this.keepCount = 0;
                int dropVar = (int)((float)overshoot / this.targetFrameRate);
                if (this.dropCount < dropVar) {
                    drop = true;
                    ++this.dropCount;
                } else {
                    this.overshootModifier = (float)overshoot - (float)((int)((float)overshoot / this.targetFrameRate)) * this.targetFrameRate;
                    drop = false;
                    this.dropCount = 0;
                }
            }
        }
        return drop;
    }

    public void updateIncomingFramerate() {
        long now = System.currentTimeMillis();
        if (this.incomingFrameTimes[0] != 0L) {
            for (int i = FrameCountHistorySize - 2; i >= 0; --i) {
                this.incomingFrameTimes[i + 1] = this.incomingFrameTimes[i];
            }
        }
        this.incomingFrameTimes[0] = now;
        this.processIncomingFramerate(now);
    }

    public int decimatedFramerate() {
        this.processIncomingFramerate(System.currentTimeMillis());
        if (!this.enableTemoralDecimation) {
            return Math.round(this.incomingFrameRate);
        }
        return Math.min((int)this.targetFrameRate, Math.round(this.incomingFrameRate));
    }

    public int inputFramerate() {
        this.processIncomingFramerate(System.currentTimeMillis());
        return Math.round(this.incomingFrameRate);
    }

    public boolean dropNextFrame() {
        return this.dropNextFrame;
    }

    public boolean needDropNextFrame(boolean dropped) {
        this.dropNextFrame = dropped;
        return this.dropNextFrame;
    }

    private void processIncomingFramerate(long now) {
        int num = 0;
        int nrOfFrames = 0;
        for (num = 1; num < FrameCountHistorySize - 1 && this.incomingFrameTimes[num] > 0L && now - this.incomingFrameTimes[num] <= (long)FrameShitoryWindowMs; ++num) {
            ++nrOfFrames;
        }
        if (num > 1) {
            long diff = now - this.incomingFrameTimes[num - 1];
            this.incomingFrameRate = 1.0f;
            if (diff > 0L) {
                this.incomingFrameRate = (float)nrOfFrames * 1000.0f / ((float)diff * 1.0f);
            }
        } else {
            this.incomingFrameRate = (float)nrOfFrames * 1.0f;
        }
    }
}

