/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.extensions;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.ConditionVariable;
import android.os.Handler;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.TimerSurfaceTextureHelper;
import io.agora.base.internal.video.VideoSink;
import io.agora.rtc2.extensions.MediaProjectionMgr;
import io.agora.rtc2.extensions.MediaProjectionSource;
import io.agora.rtc2.gl.EglBaseProvider;

@TargetApi(value=21)
public class ScreenCapture
implements VideoSink,
MediaProjectionMgr.IScreenCapture {
    private static final String TAG = "ScreenCapture";
    private static final String SCREEN_CAPTURER_THREAD_NAME = "ScreenCapturerThread";
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private volatile int width;
    private volatile int height;
    private volatile boolean lastOrientation;
    @Nullable
    private TimerSurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @NonNull
    private final MediaProjection mediaProjection;
    private final ConditionVariable waitForDeviceClosedConditionVariable = new ConditionVariable();
    @Nullable
    private VideoSink videoListener;

    public ScreenCapture(int width, int height, int frameRate, @NonNull MediaProjection mediaProjection, @Nullable VideoSink videoListener) {
        if (width <= 0 || height <= 0) {
            int[] size = ScreenCapture.getScreenSizeInlcudingTopBottomBar(MediaProjectionMgr.getContext());
            this.width = size[0];
            this.height = size[1];
        } else {
            this.width = width;
            this.height = height;
        }
        MediaProjectionSource.logD(TAG, "ScreenCapture() width: " + this.width + ", height: " + this.height + ", frame rate:" + frameRate);
        this.mediaProjection = mediaProjection;
        this.videoListener = videoListener;
        this.lastOrientation = ScreenCapture.getOrientation();
        this.surfaceTextureHelper = TimerSurfaceTextureHelper.create((String)SCREEN_CAPTURER_THREAD_NAME, (EglBase.Context)EglBaseProvider.getCurrentEglContext());
        this.surfaceTextureHelper.setFrameRate(frameRate);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    static int[] getScreenSizeInlcudingTopBottomBar(Context context) {
        int y;
        int x;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point screenSize = new Point();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(screenSize);
                x = screenSize.x;
                y = screenSize.y;
            } else {
                display.getSize(screenSize);
                x = screenSize.x;
                y = screenSize.y;
            }
        } else {
            x = display.getWidth();
            y = display.getHeight();
        }
        int[] screenDimensions = new int[]{x, y};
        return screenDimensions;
    }

    static boolean getOrientation() {
        int orientation;
        WindowManager wm = (WindowManager)MediaProjectionMgr.getContext().getSystemService("window");
        int rotation = wm.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation == 0 || orientation == 180;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        MediaProjectionSource.logD(TAG, "startCaptureMaybeAsync()");
        if (this.surfaceTextureHelper == null) {
            return false;
        }
        this.createVirtualDisplay();
        this.surfaceTextureHelper.startListening((VideoSink)this);
        return true;
    }

    @Override
    public void changeCaptureFrameRate(int frameRate) {
        MediaProjectionSource.logD(TAG, "changeCaptureFrameRate() frameRate: " + frameRate);
        if (this.surfaceTextureHelper == null) {
            return;
        }
        this.surfaceTextureHelper.setFrameRate(frameRate);
    }

    @Override
    public void changeCaptureFormatAsync(final int width, final int height) {
        MediaProjectionSource.logD(TAG, "changeCaptureFormatAsync() width: " + width + ", height: " + height);
        if (width <= 0 || height <= 0) {
            return;
        }
        if (width == this.width && height == this.height) {
            return;
        }
        if (this.surfaceTextureHelper == null) {
            return;
        }
        this.surfaceTextureHelper.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (width == ScreenCapture.this.width && height == ScreenCapture.this.height) {
                    return;
                }
                ScreenCapture.this.changeCaptureFormat(width, height, ScreenCapture.getOrientation());
            }
        });
    }

    @Override
    public void stopCaptureAndBlockUntilStopped() {
        MediaProjectionSource.logD(TAG, "stopCaptureAndBlockUntilStopped()");
        if (this.surfaceTextureHelper == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.surfaceTextureHelper.getHandler(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenCapture.this.surfaceTextureHelper.stopListening();
                if (ScreenCapture.this.virtualDisplay != null) {
                    ScreenCapture.this.virtualDisplay.release();
                    ScreenCapture.this.virtualDisplay = null;
                }
                ScreenCapture.this.waitForDeviceClosedConditionVariable.open();
            }
        });
        this.waitForDeviceClosedConditionVariable.block();
        this.videoListener = null;
    }

    private void createVirtualDisplay() {
        if (this.surfaceTextureHelper == null) {
            return;
        }
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.width, this.height, 400, 3, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    synchronized void changeCaptureFormat(int width, int height, boolean orientation) {
        MediaProjectionSource.logD(TAG, "changeCaptureFormat, " + width + " x " + height);
        this.width = width;
        this.height = height;
        this.lastOrientation = orientation;
        if (this.virtualDisplay == null) {
            return;
        }
        if (this.surfaceTextureHelper == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.surfaceTextureHelper.getHandler(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenCapture.this.virtualDisplay.release();
                ScreenCapture.this.createVirtualDisplay();
            }
        });
    }

    public void onFrame(VideoFrame frame) {
        boolean orientation = ScreenCapture.getOrientation();
        if (orientation != this.lastOrientation) {
            this.changeCaptureFormat(this.height, this.width, orientation);
        }
        if (this.videoListener != null) {
            this.videoListener.onFrame(frame);
        }
    }

    @Override
    public void dispose() {
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
    }
}

