/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.extensions;

import android.content.res.Configuration;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.VideoSink;
import io.agora.rtc2.extensions.AudioCapture;
import io.agora.rtc2.extensions.MediaProjectionMgr;
import io.agora.rtc2.extensions.ScreenCapture;
import java.nio.ByteBuffer;

public class MediaProjectionSource
implements VideoSink,
MediaProjectionMgr.AudioFrameListener,
MediaProjectionMgr.RequestListener,
MediaProjectionMgr.ConfigurationChangedListener {
    private static final String TAG = "MediaProjectionSource";
    private final ThreadUtils.ThreadChecker checker;
    @NonNull
    private final Callback callback;
    @Nullable
    MediaProjectionMgr mediaProjectManager;
    private final Object objectLock = new Object();
    @Nullable
    private MediaProjection requestedMediaProjection;
    @Nullable
    private MediaProjection.Callback virtualDisplayCallback;
    @Nullable
    private AudioCaptureParameters audioCaptureParameters;
    @Nullable
    private MediaProjectionMgr.IAudioCapture audioCapture;
    @Nullable
    private ScreenCaptureParameters screeenCaptureParameters;
    @Nullable
    private MediaProjectionMgr.IScreenCapture screenCapture;
    @NonNull
    private final CaptureFactory factory;
    @VisibleForTesting
    @Nullable
    private static CaptureFactory injectedFactory = null;

    @VisibleForTesting
    public static void setInjectedFactory(CaptureFactory injectedFactory) {
        MediaProjectionSource.injectedFactory = injectedFactory;
    }

    @CalledByNative
    public MediaProjectionSource(long handle) {
        this(MediaProjectionSource.createCallback(handle));
    }

    static CaptureFactory createDefaultCaptureFactory() {
        return new DefaultCaptureFactory();
    }

    public MediaProjectionSource(@NonNull Callback callback) {
        this(callback, MediaProjectionSource.createDefaultCaptureFactory());
    }

    public MediaProjectionSource(@NonNull Callback callback, @NonNull CaptureFactory factory) {
        MediaProjectionSource.logD(TAG, "constructor()");
        this.callback = callback;
        this.factory = injectedFactory != null ? injectedFactory : factory;
        this.checker = new ThreadUtils.ThreadChecker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private MediaProjectionMgr getMediaProjectManager() {
        Object object = this.objectLock;
        synchronized (object) {
            if (this.mediaProjectManager == null) {
                this.mediaProjectManager = new MediaProjectionMgr(this, this);
            }
            return this.mediaProjectManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMediaProjectionManager() {
        Object object = this.objectLock;
        synchronized (object) {
            if (this.audioCapture != null || this.screenCapture != null) {
                return;
            }
            if (this.requestedMediaProjection != null) {
                try {
                    if (Build.VERSION.SDK_INT >= 21) {
                        if (this.virtualDisplayCallback != null) {
                            this.requestedMediaProjection.unregisterCallback(this.virtualDisplayCallback);
                            this.virtualDisplayCallback = null;
                        }
                        this.requestedMediaProjection.stop();
                    }
                }
                catch (Exception exception) {
                    Logging.w((String)TAG, (String)("Exception when stopCaptureAndBlockUntilStopped: " + exception.getMessage()));
                }
                finally {
                    this.virtualDisplayCallback = null;
                    this.requestedMediaProjection = null;
                }
            }
            if (this.mediaProjectManager != null) {
                this.mediaProjectManager.dispose();
                this.mediaProjectManager = null;
            }
        }
    }

    @VisibleForTesting
    @Nullable
    public MediaProjection getRequestedMediaProjection() {
        return this.requestedMediaProjection;
    }

    @VisibleForTesting
    @Nullable
    public AudioCaptureParameters getAudioCaptureParameters() {
        return this.audioCaptureParameters;
    }

    @VisibleForTesting
    @Nullable
    public MediaProjectionMgr.IAudioCapture getAudioCapture() {
        return this.audioCapture;
    }

    @VisibleForTesting
    @Nullable
    public ScreenCaptureParameters getScreeenCaptureParameters() {
        return this.screeenCaptureParameters;
    }

    @VisibleForTesting
    @Nullable
    public MediaProjectionMgr.IScreenCapture getScreenCapture() {
        return this.screenCapture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    boolean startVideoCapture(ScreenCaptureParameters parameters) {
        this.checker.checkIsOnValidThread();
        Logging.d((String)TAG, (String)"startVideoCapture()");
        if (parameters == null) {
            Logging.w((String)TAG, (String)"invalid parameter for video capture");
            return false;
        }
        this.screeenCaptureParameters = parameters;
        if (!this.factory.isScreenCaptureSupported()) {
            return false;
        }
        Object object = this.objectLock;
        synchronized (object) {
            if (this.requestedMediaProjection != null) {
                this.screenCapture = this.factory.createScreenCapture(this.screeenCaptureParameters.width, this.screeenCaptureParameters.height, this.screeenCaptureParameters.frameRate, this.screeenCaptureParameters.frameCopy, this.screeenCaptureParameters.smoothCapture, this.screeenCaptureParameters.restartVirtualDisplay, this.requestedMediaProjection, this);
                if (this.screenCapture != null) {
                    if (Build.VERSION.SDK_INT >= 21 && this.virtualDisplayCallback == null) {
                        this.virtualDisplayCallback = new MediaProjection.Callback(){

                            public void onStop() {
                                super.onStop();
                                MediaProjectionSource.logD(MediaProjectionSource.TAG, "virtualDisplay onStop");
                            }
                        };
                        this.requestedMediaProjection.registerCallback(this.virtualDisplayCallback, new Handler(Looper.getMainLooper()));
                    }
                    this.screenCapture.startCaptureMaybeAsync();
                }
            } else {
                this.getMediaProjectManager().requestPermission();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void changeScreenCaptureFrameRate(int frameRate) {
        this.checker.checkIsOnValidThread();
        Object object = this.objectLock;
        synchronized (object) {
            if (this.screenCapture != null) {
                this.screenCapture.changeCaptureFrameRate(frameRate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void changeScreenCaptureFormat(int width, int height) {
        this.checker.checkIsOnValidThread();
        if (width <= 0 || height <= 0) {
            return;
        }
        Object object = this.objectLock;
        synchronized (object) {
            if (this.screenCapture != null) {
                this.screenCapture.changeCaptureFormatAsync(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void stopVideoCapture() {
        Logging.d((String)TAG, (String)"stopVideoCapture()");
        Object object = this.objectLock;
        synchronized (object) {
            if (this.screenCapture != null) {
                this.screenCapture.stopCaptureAndBlockUntilStopped();
                this.screenCapture.dispose();
                this.screenCapture = null;
            }
            this.screeenCaptureParameters = null;
            this.releaseMediaProjectionManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    boolean startAudioCapture(AudioCaptureParameters parameters) {
        Logging.d((String)TAG, (String)"startAudioCapture()");
        this.checker.checkIsOnValidThread();
        if (parameters == null) {
            Logging.w((String)TAG, (String)"invalid parameter for audio capture");
            return false;
        }
        this.audioCaptureParameters = parameters;
        if (!this.factory.isAudioCaptureSupported()) {
            return false;
        }
        Object object = this.objectLock;
        synchronized (object) {
            if (this.requestedMediaProjection != null) {
                this.audioCapture = this.factory.createAudioCapture(this.audioCaptureParameters.channels, this.audioCaptureParameters.sampleRate, this.requestedMediaProjection, null, this);
                if (this.audioCapture != null) {
                    this.audioCapture.startRecording();
                }
            } else {
                this.getMediaProjectManager().requestPermission();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void stopAudioCapture() {
        Logging.d((String)TAG, (String)"stopAudioCapture()");
        this.checker.checkIsOnValidThread();
        Object object = this.objectLock;
        synchronized (object) {
            if (this.audioCapture != null) {
                this.audioCapture.stopRecording();
                this.audioCapture = null;
            }
            this.audioCaptureParameters = null;
            this.releaseMediaProjectionManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProjectionResult(MediaProjection mediaProjection) {
        Logging.d((String)TAG, (String)"onRequestSuccess()");
        Object object = this.objectLock;
        synchronized (object) {
            if (mediaProjection == null) {
                Logging.w((String)TAG, (String)"Failed to get media projection, user denied");
                this.callback.onError(0);
                return;
            }
            this.requestedMediaProjection = mediaProjection;
            if (this.screeenCaptureParameters != null) {
                this.screenCapture = this.factory.createScreenCapture(this.screeenCaptureParameters.width, this.screeenCaptureParameters.height, this.screeenCaptureParameters.frameRate, this.screeenCaptureParameters.frameCopy, this.screeenCaptureParameters.smoothCapture, this.screeenCaptureParameters.restartVirtualDisplay, mediaProjection, this);
                if (this.screenCapture != null) {
                    if (Build.VERSION.SDK_INT >= 21 && this.virtualDisplayCallback == null) {
                        this.virtualDisplayCallback = new MediaProjection.Callback(){

                            public void onStop() {
                                super.onStop();
                                MediaProjectionSource.logD(MediaProjectionSource.TAG, "virtualDisplay onStop");
                            }
                        };
                        this.requestedMediaProjection.registerCallback(this.virtualDisplayCallback, null);
                    }
                    this.screenCapture.startCaptureMaybeAsync();
                }
            }
            if (this.audioCaptureParameters != null) {
                this.audioCapture = this.factory.createAudioCapture(this.audioCaptureParameters.channels, this.audioCaptureParameters.sampleRate, mediaProjection, null, this);
                if (this.audioCapture != null) {
                    this.audioCapture.startRecording();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        Logging.d((String)TAG, (String)"onConfigurationChanged()");
        Object object = this.objectLock;
        synchronized (object) {
            if (this.screenCapture != null) {
                this.screenCapture.changeConfigurationAsync(newConfig);
            }
        }
    }

    @NonNull
    static Callback createCallback(final long nativeSource) {
        return new Callback(){

            @Override
            public void onError(int errorCode) {
                MediaProjectionSource.nativeOnError(nativeSource, errorCode);
            }

            @Override
            public void onFrame(VideoFrame frame) {
                VideoFrame.Buffer buffer = frame.getBuffer();
                if (buffer instanceof VideoFrame.TextureBuffer) {
                    VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)frame.getBuffer();
                    MediaProjectionSource.nativeOnFrameCaptured(nativeSource, textureBuffer.getWidth(), textureBuffer.getHeight(), frame.getRotation(), frame.getTimestampNs(), textureBuffer.getEglContextType() == VideoFrame.TextureBuffer.ContextType.EGL_CONTEXT_14.ordinal(), textureBuffer.getEglBaseContext(), textureBuffer.getTextureId(), textureBuffer.getType() == VideoFrame.TextureBuffer.Type.OES, textureBuffer.getTransformMatrixArray());
                } else {
                    VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                    if (i420Buffer == null) {
                        return;
                    }
                    MediaProjectionSource.nativeOnI420FrameAvailable(nativeSource, i420Buffer.getWidth(), i420Buffer.getHeight(), i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), frame.getRotation(), frame.getTimestampNs());
                }
            }

            @Override
            public void onCacheBufferReady(ByteBuffer byteBuffer) {
                MediaProjectionSource.nativeOnCacheBufferReady(nativeSource, byteBuffer);
            }

            @Override
            public void onDataIsRecorded(int bytesRead) {
                MediaProjectionSource.nativeOnDataIsRecorded(nativeSource, bytesRead);
            }
        };
    }

    public void onFrame(VideoFrame frame) {
        this.callback.onFrame(frame);
    }

    @Override
    public void onCacheBufferReady(ByteBuffer byteBuffer) {
        this.callback.onCacheBufferReady(byteBuffer);
    }

    @Override
    public void onDataIsRecorded(int bytesRead) {
        this.callback.onDataIsRecorded(bytesRead);
    }

    private static native void nativeOnFrameCaptured(long var0, int var2, int var3, int var4, long var5, boolean var7, EglBase.Context var8, int var9, boolean var10, float[] var11);

    private static native void nativeOnI420FrameAvailable(long var0, int var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, ByteBuffer var8, int var9, int var10, long var11);

    private static native void nativeOnCacheBufferReady(long var0, ByteBuffer var2);

    private static native void nativeOnDataIsRecorded(long var0, int var2);

    private static native void nativeOnError(long var0, int var2);

    static void logD(String tag, String msg) {
        Logging.d((String)tag, (String)msg);
    }

    static void logW(String tag, String msg) {
        Logging.w((String)tag, (String)msg);
    }

    static void logE(String tag, String msg) {
        Logging.e((String)tag, (String)msg);
    }

    static interface Callback {
        public void onError(int var1);

        public void onFrame(VideoFrame var1);

        public void onCacheBufferReady(ByteBuffer var1);

        public void onDataIsRecorded(int var1);
    }

    static @interface MediaProjectionSourceError {
        public static final int ERROR_USER_DENY = 0;
    }

    static class DefaultCaptureFactory
    implements CaptureFactory {
        DefaultCaptureFactory() {
        }

        @Override
        public boolean isAudioCaptureSupported() {
            return Build.VERSION.SDK_INT >= 29;
        }

        @Override
        @Nullable
        public MediaProjectionMgr.IAudioCapture createAudioCapture(int channels, int sampleRate, @NonNull MediaProjection mediaProjection, @Nullable MediaProjectionMgr.AudioRecordErrorCallback errorCallback, @NonNull MediaProjectionMgr.AudioFrameListener listener) {
            if (!this.isAudioCaptureSupported()) {
                return null;
            }
            return new AudioCapture(channels, sampleRate, mediaProjection, errorCallback, listener);
        }

        @Override
        public boolean isScreenCaptureSupported() {
            return Build.VERSION.SDK_INT >= 21;
        }

        @Override
        @Nullable
        public MediaProjectionMgr.IScreenCapture createScreenCapture(int width, int height, int frameRate, boolean frameCopy, boolean smoothCapture, boolean restartVirtualDisplay, @NonNull MediaProjection projection, @NonNull VideoSink listener) {
            if (!this.isScreenCaptureSupported()) {
                return null;
            }
            return new ScreenCapture(width, height, frameRate, frameCopy, smoothCapture, restartVirtualDisplay, projection, listener);
        }
    }

    static class ScreenCaptureParameters {
        int width;
        int height;
        int frameRate;
        boolean frameCopy;
        boolean smoothCapture;
        boolean restartVirtualDisplay;

        @CalledByNative(value="ScreenCaptureParameters")
        public ScreenCaptureParameters(int width, int height, int frameRate, boolean frameCopy, boolean smoothCapture, boolean restartVirtualDisplay) {
            this.width = width;
            this.height = height;
            this.frameRate = frameRate;
            this.frameCopy = frameCopy;
            this.smoothCapture = smoothCapture;
            this.restartVirtualDisplay = restartVirtualDisplay;
        }
    }

    static class AudioCaptureParameters {
        int channels;
        int sampleRate;

        @CalledByNative(value="AudioCaptureParameters")
        public AudioCaptureParameters(int channels, int sampleRate) {
            this.channels = channels;
            this.sampleRate = sampleRate;
        }
    }

    public static interface CaptureFactory {
        public boolean isAudioCaptureSupported();

        @Nullable
        public MediaProjectionMgr.IAudioCapture createAudioCapture(int var1, int var2, @NonNull MediaProjection var3, @Nullable MediaProjectionMgr.AudioRecordErrorCallback var4, @NonNull MediaProjectionMgr.AudioFrameListener var5);

        public boolean isScreenCaptureSupported();

        @Nullable
        public MediaProjectionMgr.IScreenCapture createScreenCapture(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, @NonNull MediaProjection var7, @NonNull VideoSink var8);
    }
}

