/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.extensions;

import android.annotation.TargetApi;
import android.media.AudioFormat;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.internal.ThreadUtils;
import io.agora.rtc2.extensions.MediaProjectionMgr;
import io.agora.rtc2.extensions.MediaProjectionSource;
import java.nio.ByteBuffer;

public class AudioCapture
implements MediaProjectionMgr.IAudioCapture {
    private static final String TAG = "AudioCapture";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private final int channels;
    private final int sampleRate;
    @NonNull
    private final MediaProjection mediaProjection;
    @NonNull
    private final MediaProjectionMgr.AudioFrameListener audioFrameListener;
    @Nullable
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread = null;
    private volatile boolean microphoneMute = false;
    private byte[] emptyBytes;
    @Nullable
    private final MediaProjectionMgr.AudioRecordErrorCallback errorCallback;

    public AudioCapture(int channels, int sampleRate, @NonNull MediaProjection mediaProjection, @Nullable MediaProjectionMgr.AudioRecordErrorCallback errorCallback, @NonNull MediaProjectionMgr.AudioFrameListener listener) {
        this.mediaProjection = mediaProjection;
        this.channels = channels;
        this.sampleRate = sampleRate;
        this.audioFrameListener = listener;
        this.errorCallback = errorCallback;
    }

    @Override
    @TargetApi(value=29)
    public boolean startRecording() {
        MediaProjectionSource.logD(TAG, "startRecording");
        if (this.initRecording() <= 0) {
            return false;
        }
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + e.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    @TargetApi(value=29)
    int initRecording() {
        MediaProjectionSource.logD(TAG, "initRecording(sampleRate=" + this.sampleRate + ", channels=" + this.channels + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int bytesPerFrame = this.channels * 2;
        int framesPerBuffer = this.sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        if (!this.byteBuffer.hasArray()) {
            this.reportWebRtcAudioRecordInitError("ByteBuffer does not have backing array.");
            return -1;
        }
        MediaProjectionSource.logD(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.audioFrameListener.onCacheBufferReady(this.byteBuffer);
        int channelConfig = this.channelCountToConfiguration(this.channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)channelConfig, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
            return -1;
        }
        MediaProjectionSource.logD(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        MediaProjectionSource.logD(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        AudioPlaybackCaptureConfiguration config = new AudioPlaybackCaptureConfiguration.Builder(this.mediaProjection).addMatchingUsage(1).build();
        AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(2).setSampleRate(this.sampleRate).setChannelMask(channelConfig).build();
        this.audioRecord = new AudioRecord.Builder().setAudioFormat(audioFormat).setBufferSizeInBytes(bufferSizeInBytes).setAudioPlaybackCaptureConfig(config).build();
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            return -1;
        }
        this.logMainParameters();
        return framesPerBuffer;
    }

    @Override
    public void stopRecording() {
        MediaProjectionSource.logD(TAG, "stopRecording");
        if (this.audioThread != null) {
            this.audioThread.stopThread();
            if (!ThreadUtils.joinUninterruptibly((Thread)this.audioThread, (long)2000L)) {
                MediaProjectionSource.logE(TAG, "Join of AudioRecordJavaThread timed out");
            }
            this.audioThread = null;
        }
        this.releaseAudioResources();
    }

    private void logMainParameters() {
        MediaProjectionSource.logD(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    public void setMicrophoneMute(boolean mute) {
        MediaProjectionSource.logE(TAG, "setMicrophoneMute(" + mute + ")");
        this.microphoneMute = mute;
    }

    private void releaseAudioResources() {
        MediaProjectionSource.logD(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        MediaProjectionSource.logE(TAG, "Init recording error: " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode errorCode, String errorMessage) {
        MediaProjectionSource.logE(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioRecordError(String errorMessage) {
        MediaProjectionSource.logE(TAG, "Run-time recording error: " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordError(errorMessage);
        }
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        String getThreadInfo() {
            return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            MediaProjectionSource.logD(AudioCapture.TAG, "AudioRecordThread " + this.getThreadInfo());
            AudioCapture.assertTrue(AudioCapture.this.audioRecord.getRecordingState() == 3);
            while (this.keepAlive) {
                int bytesRead = AudioCapture.this.audioRecord.read(AudioCapture.this.byteBuffer, AudioCapture.this.byteBuffer.capacity());
                if (bytesRead == AudioCapture.this.byteBuffer.capacity()) {
                    if (AudioCapture.this.microphoneMute) {
                        AudioCapture.this.byteBuffer.clear();
                        AudioCapture.this.byteBuffer.put(AudioCapture.this.emptyBytes);
                    }
                    if (!this.keepAlive) continue;
                    AudioCapture.this.audioFrameListener.onDataIsRecorded(bytesRead);
                    continue;
                }
                String errorMessage = "AudioRecord.read failed: " + bytesRead;
                MediaProjectionSource.logE(AudioCapture.TAG, errorMessage);
                if (bytesRead != -3) continue;
                this.keepAlive = false;
                AudioCapture.this.reportWebRtcAudioRecordError(errorMessage);
            }
            try {
                if (AudioCapture.this.audioRecord != null) {
                    AudioCapture.this.audioRecord.stop();
                }
            }
            catch (IllegalStateException e) {
                MediaProjectionSource.logE(AudioCapture.TAG, "AudioRecord.stop failed: " + e.getMessage());
            }
        }

        public void stopThread() {
            MediaProjectionSource.logD(AudioCapture.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

