/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.extensions;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.ConditionVariable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.TimerSurfaceTextureHelper;
import io.agora.base.internal.video.VideoSink;
import io.agora.rtc2.extensions.MediaProjectionMgr;
import io.agora.rtc2.extensions.MediaProjectionSource;
import io.agora.rtc2.gl.EglBaseProvider;

@TargetApi(value=21)
public class ScreenCapture
implements VideoSink,
MediaProjectionMgr.IScreenCapture {
    private static final String TAG = "ScreenCapture";
    private static final String SCREEN_CAPTURER_THREAD_NAME = "ScreenCapturerThread";
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private final boolean smoothCapture;
    private final int frameRate;
    private volatile int widthParameters;
    private volatile int heightParameters;
    private volatile int widthPixel;
    private volatile int heightPixel;
    private volatile boolean lastOrientation;
    @Nullable
    private TimerSurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @NonNull
    private final MediaProjection mediaProjection;
    private final ConditionVariable waitForDeviceClosedConditionVariable = new ConditionVariable();
    private boolean enableFrameCopy;
    @Nullable
    private VideoSink videoListener;
    private int virtualDisplayWidth;
    private int virtualDisplayHeight;
    private int densityDpi;
    private boolean restartVirtualDisplay;

    public ScreenCapture(int width, int height, int frameRate, boolean frameCopy, boolean smoothCapture, boolean restartVirtualDisplay, @NonNull MediaProjection mediaProjection, @Nullable VideoSink videoListener) {
        if (width <= 0 || height <= 0) {
            int[] size = ScreenCapture.getScreenSizeInlcudingTopBottomBar(MediaProjectionMgr.getContext());
            this.widthParameters = size[0];
            this.heightParameters = size[1];
        } else {
            this.widthParameters = width;
            this.heightParameters = height;
        }
        this.mediaProjection = mediaProjection;
        this.videoListener = videoListener;
        this.lastOrientation = this.getOrientation();
        this.enableFrameCopy = frameCopy;
        this.restartVirtualDisplay = restartVirtualDisplay;
        this.frameRate = frameRate;
        this.smoothCapture = smoothCapture;
        this.surfaceTextureHelper = TimerSurfaceTextureHelper.create((String)SCREEN_CAPTURER_THREAD_NAME, (boolean)smoothCapture, (EglBase.Context)EglBaseProvider.instance().getLocalEglBaseContext());
        this.surfaceTextureHelper.setFrameRate(frameRate);
        Logging.d((String)TAG, (String)("ScreenCapture width: " + this.widthParameters + ", height: " + this.heightParameters + ", frame rate:" + frameRate + ", enable frameCopy: " + this.enableTextureCopy() + ", restartVirtualDisplay: " + restartVirtualDisplay));
        this.initDisplayMetrics();
        if (this.widthParameters * this.heightParameters > this.widthPixel * this.heightPixel) {
            this.widthParameters = this.widthPixel;
            this.heightParameters = this.heightPixel;
            Logging.w((String)TAG, (String)("ScreenCapture warring, " + width + "x" + height + " size unsupported."));
        }
    }

    private void initDisplayMetrics() {
        WindowManager wm = (WindowManager)MediaProjectionMgr.getContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        if (null == wm) {
            return;
        }
        Display display = wm.getDefaultDisplay();
        if (null == display) {
            return;
        }
        display.getRealMetrics(metrics);
        this.widthPixel = metrics.widthPixels;
        this.heightPixel = metrics.heightPixels;
        this.densityDpi = metrics.densityDpi;
        Logging.d((String)TAG, (String)("initDisplayMetrics widthPixel: " + this.widthPixel + " , heightPixel: " + this.heightPixel + " , oritation: " + (this.lastOrientation ? "landscape" : "portrait") + " , densityDpi: " + this.densityDpi));
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    static int[] getScreenSizeInlcudingTopBottomBar(Context context) {
        int y;
        int x;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point screenSize = new Point();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(screenSize);
                x = screenSize.x;
                y = screenSize.y;
            } else {
                display.getSize(screenSize);
                x = screenSize.x;
                y = screenSize.y;
            }
        } else {
            x = display.getWidth();
            y = display.getHeight();
        }
        int[] screenDimensions = new int[]{x, y};
        return screenDimensions;
    }

    private int getRotationByDM() {
        DisplayManager dm = (DisplayManager)MediaProjectionMgr.getContext().getSystemService("display");
        if (null == dm) {
            return 0;
        }
        Display display = dm.getDisplay(0);
        if (null == display) {
            return 0;
        }
        return display.getRotation();
    }

    private int getRotationByWM() {
        WindowManager wm = (WindowManager)MediaProjectionMgr.getContext().getSystemService("window");
        if (null == wm) {
            return 0;
        }
        Display display = wm.getDefaultDisplay();
        if (null == display) {
            return 0;
        }
        return display.getRotation();
    }

    private boolean getOrientation() {
        int orientation;
        int rotation;
        if (Build.VERSION.SDK_INT >= 17) {
            rotation = this.getRotationByDM();
            if (rotation < 0) {
                rotation = this.getRotationByWM();
            }
        } else {
            rotation = this.getRotationByWM();
        }
        switch (rotation) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation == 0 || orientation == 180;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        MediaProjectionSource.logD(TAG, "startCaptureMaybeAsync()");
        if (this.surfaceTextureHelper == null) {
            return false;
        }
        int[] size = this.getVirtualDisplaySize();
        this.virtualDisplayWidth = size[0];
        this.virtualDisplayHeight = size[1];
        this.createVirtualDisplay(this.surfaceTextureHelper);
        this.surfaceTextureHelper.startListening((VideoSink)this);
        return true;
    }

    @Override
    public void changeCaptureFrameRate(int frameRate) {
        Logging.d((String)TAG, (String)("changeCaptureFrameRate frameRate: " + frameRate + ", enable frameCopy: " + this.enableTextureCopy()));
        if (this.surfaceTextureHelper == null) {
            return;
        }
        this.surfaceTextureHelper.setFrameRate(frameRate);
    }

    @Override
    public void changeCaptureFormatAsync(final int width, final int height) {
        Logging.d((String)TAG, (String)("changeCaptureFormatAsync width: " + width + ", height: " + height));
        if (width <= 0 || height <= 0) {
            return;
        }
        if (width == this.widthParameters && height == this.heightParameters) {
            return;
        }
        if (this.surfaceTextureHelper == null) {
            return;
        }
        this.surfaceTextureHelper.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (width == ScreenCapture.this.widthParameters && height == ScreenCapture.this.heightParameters) {
                    return;
                }
                ScreenCapture.this.changeCaptureFormat(width, height, ScreenCapture.this.getOrientation());
            }
        });
    }

    @Override
    public void changeConfigurationAsync(@NonNull Configuration newConfig) {
        Display display;
        if (this.surfaceTextureHelper == null) {
            return;
        }
        final boolean orientation = this.getOrientation();
        WindowManager wm = (WindowManager)MediaProjectionMgr.getContext().getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        if (null != wm && null != (display = wm.getDefaultDisplay())) {
            display.getRealMetrics(metrics);
        }
        Logging.d((String)TAG, (String)("onConfigurationChanged oritation: " + orientation + " lastOritation: " + this.lastOrientation + " screenWidthDp: " + newConfig.screenWidthDp + " screenHeightDp: " + newConfig.screenHeightDp + " widthPixels: " + metrics.widthPixels + " heightPixels: " + metrics.heightPixels));
        this.densityDpi = metrics.densityDpi;
        if (metrics.widthPixels != this.widthPixel || metrics.heightPixels != this.heightPixel) {
            this.widthPixel = metrics.widthPixels;
            this.heightPixel = metrics.heightPixels;
            Logging.d((String)TAG, (String)("changeCaptureFormat, swap pixel by metrics: " + this.widthPixel + " x " + this.heightPixel));
            this.surfaceTextureHelper.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    ScreenCapture.this.changeCaptureFormat(ScreenCapture.this.widthParameters, ScreenCapture.this.heightParameters, orientation);
                }
            });
        }
    }

    @Override
    public void stopCaptureAndBlockUntilStopped() {
        MediaProjectionSource.logD(TAG, "stopCaptureAndBlockUntilStopped");
        if (this.surfaceTextureHelper == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.surfaceTextureHelper.getHandler(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenCapture.this.surfaceTextureHelper.stopListening();
                if (ScreenCapture.this.virtualDisplay != null) {
                    ScreenCapture.this.virtualDisplay.release();
                    ScreenCapture.this.virtualDisplay = null;
                }
                ScreenCapture.this.waitForDeviceClosedConditionVariable.open();
            }
        });
        this.waitForDeviceClosedConditionVariable.block();
        this.videoListener = null;
    }

    private void createVirtualDisplay(TimerSurfaceTextureHelper surfaceTextureHelper) {
        if (surfaceTextureHelper == null) {
            return;
        }
        surfaceTextureHelper.setTextureSize(this.virtualDisplayWidth, this.virtualDisplayHeight);
        try {
            int virtualDisplayDpi = this.densityDpi == 0 ? 400 : this.densityDpi;
            this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.virtualDisplayWidth, this.virtualDisplayHeight, virtualDisplayDpi, 3, new Surface(surfaceTextureHelper.getSurfaceTexture()), null, null);
        }
        catch (RuntimeException e) {
            this.virtualDisplay = null;
            Logging.e((String)TAG, (String)("Invalid media projection: " + e.getMessage()));
        }
    }

    synchronized void changeCaptureFormat(int width, int height, boolean orientation) {
        Logging.d((String)TAG, (String)("changeCaptureFormat, " + width + " x " + height + " orientation: " + orientation));
        if (this.widthParameters * this.heightParameters > this.widthPixel * this.heightPixel) {
            this.widthParameters = this.widthPixel;
            this.heightParameters = this.heightPixel;
            Logging.d((String)TAG, (String)("changeCaptureFormat failure, " + width + "x" + height + " size unsupported."));
            return;
        }
        this.widthParameters = width;
        this.heightParameters = height;
        this.lastOrientation = orientation;
        if (this.virtualDisplay == null) {
            return;
        }
        if (this.surfaceTextureHelper == null) {
            return;
        }
        int[] size = this.getVirtualDisplaySize();
        if (this.virtualDisplayWidth == size[0] || this.virtualDisplayHeight == size[1]) {
            return;
        }
        this.virtualDisplayWidth = size[0];
        this.virtualDisplayHeight = size[1];
        ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.surfaceTextureHelper.getHandler(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (Build.VERSION.SDK_INT < 34 || ScreenCapture.this.shouldRestartVirtualDisplay()) {
                        Logging.d((String)ScreenCapture.TAG, (String)("createVirtualDisplay, " + ScreenCapture.this.virtualDisplayWidth + " x " + ScreenCapture.this.virtualDisplayHeight + " , orientation: " + ScreenCapture.this.lastOrientation + " , densityDpi: " + ScreenCapture.this.densityDpi));
                        ScreenCapture.this.surfaceTextureHelper.stopListening();
                        if (ScreenCapture.this.virtualDisplay != null) {
                            ScreenCapture.this.virtualDisplay.release();
                            ScreenCapture.this.virtualDisplay = null;
                        }
                        if (ScreenCapture.this.surfaceTextureHelper != null) {
                            ScreenCapture.this.surfaceTextureHelper.dispose();
                            ScreenCapture.this.surfaceTextureHelper = null;
                        }
                        TimerSurfaceTextureHelper textureHelper = TimerSurfaceTextureHelper.create((String)ScreenCapture.SCREEN_CAPTURER_THREAD_NAME, (boolean)ScreenCapture.this.smoothCapture, (EglBase.Context)EglBaseProvider.instance().getLocalEglBaseContext());
                        textureHelper.setFrameRate(ScreenCapture.this.frameRate);
                        ScreenCapture.this.createVirtualDisplay(textureHelper);
                        textureHelper.startListening((VideoSink)ScreenCapture.this);
                        ScreenCapture.this.surfaceTextureHelper = textureHelper;
                    } else {
                        Logging.d((String)ScreenCapture.TAG, (String)("VirtualDisplay resize, " + ScreenCapture.this.virtualDisplayWidth + " x " + ScreenCapture.this.virtualDisplayHeight + " , orientation: " + ScreenCapture.this.lastOrientation + " , densityDpi: " + ScreenCapture.this.densityDpi));
                        ScreenCapture.this.virtualDisplay.resize(ScreenCapture.this.virtualDisplayWidth, ScreenCapture.this.virtualDisplayHeight, 400);
                        ScreenCapture.this.surfaceTextureHelper.setTextureSize(ScreenCapture.this.virtualDisplayWidth, ScreenCapture.this.virtualDisplayHeight);
                    }
                }
                catch (RuntimeException e) {
                    Logging.e((String)ScreenCapture.TAG, (String)("virtualDisplay resize error: " + e.getMessage()));
                }
            }
        });
    }

    private boolean shouldRestartVirtualDisplay() {
        return this.restartVirtualDisplay;
    }

    private int[] getVirtualDisplaySize() {
        if (this.widthPixel > this.heightPixel && this.widthParameters < this.heightParameters || this.widthPixel < this.heightPixel && this.widthParameters > this.heightParameters) {
            this.widthParameters ^= this.heightParameters;
            this.heightParameters = this.widthParameters ^ this.heightParameters;
            this.widthParameters ^= this.heightParameters;
        }
        int target_product = this.widthParameters * this.heightParameters;
        double source_fraction = (double)this.widthPixel / (double)this.heightPixel;
        int w = (int)Math.sqrt((double)target_product * source_fraction) + 3 >> 2 << 2;
        int h = (int)Math.sqrt((double)target_product / source_fraction) + 3 >> 2 << 2;
        return new int[]{w, h};
    }

    private boolean enableTextureCopy() {
        return this.enableFrameCopy;
    }

    @Override
    public void dispose() {
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
    }

    public void onFrame(VideoFrame frame) {
        if (this.videoListener == null) {
            return;
        }
        if (!this.enableTextureCopy()) {
            this.videoListener.onFrame(frame);
        } else {
            VideoFrame.TextureBuffer textureCopy = null;
            if (this.surfaceTextureHelper != null) {
                textureCopy = this.surfaceTextureHelper.textureCopy((VideoFrame.TextureBuffer)frame.getBuffer());
            }
            if (null == textureCopy) {
                Logging.w((String)TAG, (String)"Dropped texture buffer.");
                return;
            }
            if (textureCopy.getWidth() == 0 || textureCopy.getHeight() == 0) {
                Logging.w((String)TAG, (String)"Dropped texture buffer. ");
                return;
            }
            VideoFrame frameCopy = new VideoFrame((VideoFrame.Buffer)textureCopy, frame.getRotation(), frame.getTimestampNs());
            this.videoListener.onFrame(frameCopy);
            frameCopy.release();
        }
    }
}

