/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.extensions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.ContextUtils;
import io.agora.rtc2.extensions.AudioCapture;
import io.agora.rtc2.extensions.MediaProjectionSource;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class MediaProjectionMgr
implements ServiceConnection {
    private static final String TAG = "MediaProjectionMgr";
    @Nullable
    private WeakReference<LocalScreenSharingService.ConfigurationCallbacks> mConfigurationCallbacksRef;
    @VisibleForTesting
    @Nullable
    private static ScreenCaptureActionListener captureActionListener;
    @Nullable
    private static ScreenCaptureConfigFactory screenCaptureConfigFactory;
    @Nullable
    private static MediaProjectionMgr instance;
    @NonNull
    private final MediaProjectionManager projectionManager = (MediaProjectionManager)MediaProjectionMgr.getContext().getSystemService("media_projection");
    @NonNull
    private final WeakReference<RequestListener> requestListenerRef;
    @NonNull
    private final WeakReference<ConfigurationChangedListener> configurationChangedListenerRef;
    @NonNull
    private final WeakReference<Handler> handlerWeakRef;
    private volatile boolean requesting = false;
    private volatile boolean serviceBinded = false;
    private int resultCode;
    @Nullable
    private Intent resultData = null;
    private static final Runnable displayChangeRunnable;

    @VisibleForTesting
    public static void setCaptureActionListener(@Nullable ScreenCaptureActionListener captureActionListener) {
        MediaProjectionMgr.captureActionListener = captureActionListener;
    }

    public static void setConfigFactory(@Nullable ScreenCaptureConfigFactory screenCaptureConfigFactory) {
        MediaProjectionMgr.screenCaptureConfigFactory = screenCaptureConfigFactory;
    }

    public MediaProjectionMgr(@NonNull RequestListener requestListener, @NonNull ConfigurationChangedListener configurationChangedListener) {
        this.requestListenerRef = new WeakReference<RequestListener>(requestListener);
        this.configurationChangedListenerRef = new WeakReference<ConfigurationChangedListener>(configurationChangedListener);
        HandlerThread handlerThread = new HandlerThread("ScreenCapture");
        handlerThread.start();
        this.handlerWeakRef = new WeakReference<Handler>(new Handler(handlerThread.getLooper()));
        instance = this;
    }

    @NonNull
    static Context getContext() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            throw new IllegalStateException("context null");
        }
        return context;
    }

    boolean requestService() {
        MediaProjectionSource.logD(TAG, "requestService()");
        if (this.requesting) {
            MediaProjectionSource.logD(TAG, "mediaProjection request already sent. just waiting...");
            return true;
        }
        this.requesting = true;
        Context context = MediaProjectionMgr.getContext();
        Intent bridge = new Intent(context, LocalScreenCaptureAssistantActivity.class);
        bridge.addFlags(0x10000000);
        context.startActivity(bridge);
        return true;
    }

    void registerConfigurationCallback() {
        MediaProjectionSource.logD(TAG, "registerConfigurationCallback()");
        if (null != this.mConfigurationCallbacksRef && null != this.mConfigurationCallbacksRef.get()) {
            MediaProjectionSource.logD(TAG, "ConfigurationCallback already register.");
            return;
        }
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return;
        }
        this.mConfigurationCallbacksRef = new WeakReference<LocalScreenSharingService.ConfigurationCallbacks>(new LocalScreenSharingService.ConfigurationCallbacks());
        context.registerComponentCallbacks((ComponentCallbacks)this.mConfigurationCallbacksRef.get());
    }

    void onRequestResult(int resultCode, Intent resultData) {
        MediaProjectionSource.logD(TAG, "onRequestSuccess()");
        RequestListener listener = (RequestListener)this.requestListenerRef.get();
        if (listener == null) {
            return;
        }
        try {
            Context context = MediaProjectionMgr.getContext();
            Intent intent = new Intent(context, LocalScreenSharingService.class);
            context.bindService(intent, (ServiceConnection)this, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resultCode = resultCode;
        this.resultData = resultData;
    }

    void dispose() {
        this.requestListenerRef.clear();
        this.configurationChangedListenerRef.clear();
        if (this.mConfigurationCallbacksRef != null) {
            this.mConfigurationCallbacksRef.clear();
        }
        if (this.handlerWeakRef.get() != null) {
            ((Handler)this.handlerWeakRef.get()).getLooper().quit();
        }
        this.handlerWeakRef.clear();
        if (this.serviceBinded) {
            MediaProjectionMgr.getContext().unbindService((ServiceConnection)this);
        }
        instance = null;
        if (captureActionListener != null) {
            captureActionListener.dispose();
        }
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        MediaProjection projection;
        MediaProjectionSource.logD(TAG, "local onServiceConnected");
        RequestListener listener = (RequestListener)this.requestListenerRef.get();
        this.serviceBinded = true;
        if (listener == null) {
            return;
        }
        this.requesting = false;
        if (this.resultData == null) {
            listener.onProjectionResult(null);
            return;
        }
        try {
            projection = this.projectionManager.getMediaProjection(this.resultCode, this.resultData);
        }
        catch (Exception e) {
            e.printStackTrace();
            projection = null;
        }
        listener.onProjectionResult(projection);
    }

    public void onServiceDisconnected(ComponentName componentName) {
        MediaProjectionSource.logD(TAG, "local onServiceDisconnected");
        this.serviceBinded = false;
    }

    private static void executeDisplayChange(int delay) {
        if (instance == null) {
            return;
        }
        Handler handler = (Handler)MediaProjectionMgr.instance.handlerWeakRef.get();
        if (handler == null) {
            return;
        }
        handler.postDelayed(displayChangeRunnable, (long)delay);
    }

    static {
        displayChangeRunnable = new Runnable(){

            @Override
            public void run() {
                if (instance == null) {
                    return;
                }
                ConfigurationChangedListener listener = (ConfigurationChangedListener)instance.configurationChangedListenerRef.get();
                if (listener == null) {
                    return;
                }
                listener.onConfigurationChanged(new Configuration());
            }
        };
    }

    public static class LocalScreenSharingService
    extends Service {
        private static final int NOTIFICATION_ID = 12345678;
        private static final String CHANNEL_ID = "dummy_channel_id";
        @Nullable
        private ConfigurationCallbacks componentCallbacks;

        @Nullable
        public IBinder onBind(Intent intent) {
            MediaProjectionSource.logD(MediaProjectionMgr.TAG, "onBind()");
            Notification notification = this.getNotification();
            if (notification == null) {
                notification = this.getDefaultNotification();
            }
            try {
                if (Build.VERSION.SDK_INT >= 29) {
                    this.startForeground(12345678, notification, 32);
                } else {
                    this.startForeground(12345678, notification);
                }
            }
            catch (Exception e) {
                MediaProjectionSource.logE(MediaProjectionMgr.TAG, "startForeground error: " + e.getMessage());
            }
            if (null == this.componentCallbacks) {
                this.componentCallbacks = new ConfigurationCallbacks();
                this.registerComponentCallbacks(this.componentCallbacks);
            }
            return new Binder();
        }

        @Nullable
        private Notification getNotification() {
            if (screenCaptureConfigFactory == null) {
                return null;
            }
            return screenCaptureConfigFactory.createNotification();
        }

        private Notification getDefaultNotification() {
            ApplicationInfo appInfo = this.getApplicationContext().getApplicationInfo();
            String name = this.getApplicationContext().getPackageManager().getApplicationLabel(appInfo).toString();
            int icon = appInfo.icon;
            try {
                Bitmap iconBitMap = BitmapFactory.decodeResource((Resources)this.getApplicationContext().getResources(), (int)icon);
                if (iconBitMap == null || iconBitMap.getByteCount() == 0) {
                    MediaProjectionSource.logW(MediaProjectionMgr.TAG, "Couldn't load icon from icon of applicationInfo, use android default");
                    icon = 0x10D0000;
                }
            }
            catch (Exception e) {
                MediaProjectionSource.logW(MediaProjectionMgr.TAG, "Couldn't load icon from icon of applicationInfo, use android default");
                icon = 0x10D0000;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel mChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)name, 3);
                NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
                mNotificationManager.createNotificationChannel(mChannel);
            }
            PendingIntent activityPendingIntent = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent(), (int)0xC000000) : PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent(), (int)0x8000000);
            Notification.Builder builder = new Notification.Builder((Context)this).addAction(icon, (CharSequence)name, activityPendingIntent).setContentText((CharSequence)name).setOngoing(true).setPriority(1).setSmallIcon(icon).setTicker((CharSequence)name).setWhen(System.currentTimeMillis());
            if (Build.VERSION.SDK_INT >= 26) {
                builder.setChannelId(CHANNEL_ID);
            }
            return builder.build();
        }

        public void onDestroy() {
            super.onDestroy();
            if (null != this.componentCallbacks) {
                this.unregisterComponentCallbacks(this.componentCallbacks);
                this.componentCallbacks = null;
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
            super.onConfigurationChanged(newConfig);
            if (instance == null) {
                return;
            }
            ConfigurationChangedListener listener = (ConfigurationChangedListener)instance.configurationChangedListenerRef.get();
            if (listener == null) {
                return;
            }
            listener.onConfigurationChanged(newConfig);
            MediaProjectionMgr.executeDisplayChange(200);
        }

        static class ConfigurationCallbacks
        implements ComponentCallbacks {
            ConfigurationCallbacks() {
            }

            public void onConfigurationChanged(Configuration configuration) {
                if (instance == null) {
                    return;
                }
                ConfigurationChangedListener listener = (ConfigurationChangedListener)instance.configurationChangedListenerRef.get();
                if (listener == null) {
                    return;
                }
                listener.onConfigurationChanged(configuration);
                MediaProjectionMgr.executeDisplayChange(200);
            }

            public void onLowMemory() {
            }
        }
    }

    public static class LocalScreenCaptureAssistantActivity
    extends Activity {
        public static final int MEDIA_PROJECTION_REQUEST_CODE = 1001;
        WeakReference<MediaProjectionMgr> mgrWeakReference;

        @RequiresApi(api=21)
        public void onCreate(Bundle bundle) {
            if (Build.VERSION.SDK_INT == 26) {
                boolean result = this.fixOrientation();
                MediaProjectionSource.logD(MediaProjectionMgr.TAG, "fixOrientation when Oren, result = " + result);
            }
            super.onCreate(bundle);
            this.requestWindowFeature(1);
            this.request1Pixel(this);
            MediaProjectionMgr mgr = instance;
            if (mgr == null) {
                this.finish();
                return;
            }
            this.mgrWeakReference = new WeakReference<MediaProjectionMgr>(mgr);
            Intent screenCaptureIntent = mgr.projectionManager.createScreenCaptureIntent();
            MediaProjectionSource.logD(MediaProjectionMgr.TAG, "start screen capture request");
            this.startActivityForResult(screenCaptureIntent, 1001);
            if (captureActionListener != null) {
                captureActionListener.screenCaptureRequest();
            }
        }

        private boolean fixOrientation() {
            try {
                Field field = Activity.class.getDeclaredField("mActivityInfo");
                field.setAccessible(true);
                ActivityInfo o = (ActivityInfo)field.get((Object)this);
                o.screenOrientation = -1;
                field.setAccessible(false);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        protected void onActivityResult(int requestCode, int resultCode, Intent data) {
            super.onActivityResult(requestCode, resultCode, data);
            MediaProjectionMgr mgr = (MediaProjectionMgr)this.mgrWeakReference.get();
            if (requestCode == 1001 && mgr != null) {
                mgr.onRequestResult(resultCode, data);
            }
            this.finish();
        }

        private void request1Pixel(Activity activity) {
            Window window = activity.getWindow();
            window.setGravity(51);
            WindowManager.LayoutParams params = window.getAttributes();
            params.x = 0;
            params.y = 0;
            params.height = 1;
            params.width = 1;
            window.setAttributes(params);
        }
    }

    static interface ConfigurationChangedListener {
        public void onConfigurationChanged(@NonNull Configuration var1);
    }

    static interface RequestListener {
        public void onProjectionResult(MediaProjection var1);
    }

    public static interface AudioFrameListener {
        public void onDataIsRecorded(int var1);

        public void onCacheBufferReady(ByteBuffer var1);
    }

    public static interface AudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioCapture.AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    static interface IScreenCapture {
        public boolean startCaptureMaybeAsync();

        public void changeCaptureFrameRate(int var1);

        public void changeCaptureFormatAsync(int var1, int var2);

        public void changeConfigurationAsync(@NonNull Configuration var1);

        public void stopCaptureAndBlockUntilStopped();

        public void dispose();
    }

    static interface IAudioCapture {
        public boolean startRecording();

        public void stopRecording();
    }

    public static interface ScreenCaptureConfigFactory {
        public Notification createNotification();
    }

    @VisibleForTesting
    public static interface ScreenCaptureActionListener {
        public void screenCaptureRequest();

        public void dispose();
    }
}

