/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.HardwareVideoDecoder;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapperFactoryImpl;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderFactory;
import io.agora.base.internal.video.VideoDecoderUtils;
import java.util.ArrayList;

public class HardwareVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "HardwareVideoDecoderFactory";
    private final EglBase.Context sharedContext;

    @Deprecated
    public HardwareVideoDecoderFactory() {
        this(null);
    }

    public HardwareVideoDecoderFactory(EglBase.Context sharedContext) {
        this.sharedContext = sharedContext;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (!VideoCodecType.contains(codecType.getName())) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(codecType.getName());
        MediaCodecInfo info = VideoDecoderUtils.findCodecForType(type);
        if (info == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(type.mimeType());
        if (capabilities != null && capabilities.colorFormats != null) {
            for (int supportedColorFormat : capabilities.colorFormats) {
                Logging.d(TAG, "supportedColorFormat : " + supportedColorFormat);
            }
        }
        EglBase.Context eglContext = this.sharedContext;
        if (codecType.params != null && codecType.params.containsKey("av_dec_output_byte_frame")) {
            Logging.w(TAG, "force decode to byte frame");
            eglContext = null;
        }
        return new HardwareVideoDecoder(new MediaCodecWrapperFactoryImpl(), info.getName(), type, codecType.params, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities), eglContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264, VideoCodecType.H265}) {
            MediaCodecInfo codec = VideoDecoderUtils.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.");
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo info, boolean preferHWDecoder) {
        return this.createDecoder(info);
    }
}

