/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.BaseBitrateAdjuster;
import io.agora.base.internal.video.BitrateAdjuster;
import io.agora.base.internal.video.DynamicBitrateAdjuster;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.FactorBitrateAdjuster;
import io.agora.base.internal.video.FramerateBitrateAdjuster;
import io.agora.base.internal.video.H264Utils;
import io.agora.base.internal.video.HardwareVideoEncoder;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapperFactoryImpl;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoEncoder;
import io.agora.base.internal.video.VideoEncoderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    public static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("Lenovo S90-u", "CHM-CL00", "CHM-TL00H", "CHM-UL00", "E6533", "HUAWEI CRR-UL00", "HUAWEI MT7-TL00", "HONOR H30-L01", "CHE-TL00H", "CHE-TL00", "Che2-TL00", "Che2-TL00M", "HTC D820mt", "HUAWEI P7-L10", "HUAWEI P7-L07", "M5s", "SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060");
    private static final List<String> H265_HW_EXCEPTION_HARDWARES = Arrays.asList("mt6771", "mt6762");
    @Nullable
    private final EglBase.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this.sharedContext = sharedContext;
        this.enableIntelVp8Encoder = enableIntelVp8Encoder;
        this.enableH264HighProfile = enableH264HighProfile;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(null, enableIntelVp8Encoder, enableH264HighProfile);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info, boolean useTexture, boolean preferHWEncoder) {
        return this.createEncoder(info, useTexture);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo input, boolean useTexture) {
        if (!VideoCodecType.contains(input.name)) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(input.name);
        MediaCodecInfo info = this.findCodecForType(type, useTexture);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        String mime = type.mimeType();
        Integer surfaceColorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, info.getCapabilitiesForType(mime));
        Integer yuvColorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.encoderColorFormats(info.getName()), info.getCapabilitiesForType(mime));
        boolean isH264HighProfileSupported = false;
        if (type == VideoCodecType.H264) {
            boolean isHighProfile = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(type, true));
            boolean isBaselineProfile = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(type, false));
            isH264HighProfileSupported = this.isH264HighProfileSupported(info);
            input.params.put("is-highprofile-supported", String.valueOf(isH264HighProfileSupported));
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), codecName, type, surfaceColorFormat, yuvColorFormat, input.params, this.getKeyFrameIntervalSec(type), this.getForcedKeyFrameIntervalMs(type, codecName), this.createBitrateAdjuster(type, codecName), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs(boolean useTexture) {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264, VideoCodecType.H265}) {
            MediaCodecInfo codec = this.findCodecForType(type, useTexture);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type, boolean useTexture) {
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || !info.isEncoder() || !this.isSupportedCodec(info, type, useTexture)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type, boolean useTexture) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            Logging.w(TAG, "not support codec type:" + (Object)((Object)type));
            return false;
        }
        try {
            if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.encoderColorFormats(info.getName()), info.getCapabilitiesForType(type.mimeType())) == null) {
                Logging.e(TAG, "no match color format");
                return false;
            }
        }
        catch (Exception e) {
            Logging.w(TAG, "fail to selectColorFormat, not support mimeType:" + type.mimeType());
            return false;
        }
        if (MediaCodecUtils.checkInvalidEncoder(info.getName())) {
            return false;
        }
        if (!MediaCodecUtils.isCodecInPrepareList(info.getName())) {
            Logging.w(TAG, "not included codec:" + info.getName());
        } else {
            Logging.d(TAG, "found available codec: " + info.getName());
        }
        if (useTexture) {
            return this.isHardwareTextureSupportedInCurrentSdk(info, type);
        }
        return this.isHardwareSupportedInCurrentSdk(info, type);
    }

    private boolean isHardwareTextureSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return this.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return this.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
                    return false;
                }
                if (info.getName().startsWith("OMX.k3.")) {
                    return Build.VERSION.SDK_INT > 19;
                }
                return Build.VERSION.SDK_INT >= 19;
            }
            case H265: {
                return this.isHardwareSupportedInCurrentSdkH265();
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return this.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return this.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                return this.isHardwareSupportedInCurrentSdkH264(info);
            }
            case H265: {
                return this.isHardwareSupportedInCurrentSdkH265();
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String name = info.getName();
        return (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String name = info.getName();
        if (name.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private boolean isHardwareSupportedInCurrentSdkH265() {
        if (H265_HW_EXCEPTION_HARDWARES.contains(Build.HARDWARE)) {
            Logging.w(TAG, "Hardware: " + Build.HARDWARE + " has black listed H.265 encoder.");
            return false;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private int getKeyFrameIntervalSec(VideoCodecType type) {
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: 
            case H265: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)type));
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType type, String codecName) {
        if (type == VideoCodecType.VP8 && codecName.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType type, String codecName) {
        if (codecName.startsWith("OMX.Exynos.")) {
            if (type == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            if (type == VideoCodecType.H264 || type == VideoCodecType.H265) {
                return new FactorBitrateAdjuster(950);
            }
            return new FramerateBitrateAdjuster();
        }
        if ((type == VideoCodecType.H264 || type == VideoCodecType.H265) && (codecName.startsWith("OMX.qcom.") || codecName.startsWith("OMX.MTK.") || codecName.startsWith("OMX.hisi."))) {
            return new FactorBitrateAdjuster(950);
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        boolean big_four = false;
        boolean others = false;
        if (info.getName().startsWith("OMX.qcom.") || info.getName().startsWith("OMX.hisi.") || info.getName().startsWith("OMX.Exynos.") || info.getName().startsWith("OMX.MTK.")) {
            if (Build.VERSION.SDK_INT >= 21) {
                big_four = true;
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            others = true;
        }
        if (this.enableH264HighProfile && (big_four || others)) {
            MediaCodecInfo.CodecCapabilities h264CodecCapabilities = info.getCapabilitiesForType(VideoCodecType.H264.mimeType());
            for (MediaCodecInfo.CodecProfileLevel cpf : h264CodecCapabilities.profileLevels) {
                if (cpf.profile != 8) continue;
                return true;
            }
        }
        return false;
    }
}

