/*
 * Decompiled with CFR 0.152.
 */
package io.agora.metachat.internal;

import io.agora.metachat.IMetachatScene;
import io.agora.metachat.IMetachatSceneEventHandler;
import io.agora.metachat.MetachatSceneInfo;
import io.agora.metachat.MetachatUserAvatarConfig;
import io.agora.rtc2.video.AgoraVideoFrame;

public class MetachatSceneImpl
extends IMetachatScene {
    private static final String TAG = MetachatSceneImpl.class.getSimpleName();
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private long mNativeHandle = 0L;

    MetachatSceneImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public int release() {
        if (this.mNativeHandle != 0L) {
            MetachatSceneImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        return 0;
    }

    @Override
    public int addEventHandler(IMetachatSceneEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAddEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int removeEventHandler(IMetachatSceneEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int enterScene(MetachatSceneInfo sceneInfo, MetachatUserAvatarConfig avatarConfig) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnterScene(this.mNativeHandle, sceneInfo, avatarConfig);
    }

    @Override
    public int leaveScene() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeLeaveScene(this.mNativeHandle);
    }

    @Override
    public int sendMessageToScene(byte[] message) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSendMessageToScene(this.mNativeHandle, message);
    }

    @Override
    public int setSceneParameters(String jsonParam) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetSceneParameters(this.mNativeHandle, jsonParam);
    }

    @Override
    public int enableUserPositionNotification(boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableUserPositionNotification(this.mNativeHandle, enable);
    }

    @Override
    public int enableVideoDisplay(int displayId, boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableVideoDisplay(this.mNativeHandle, displayId, enable);
    }

    @Override
    public int pushVideoFrameToDisplay(int displayId, AgoraVideoFrame frame) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePushVideoFrameToDisplay(this.mNativeHandle, displayId, frame.format, frame.buf, frame.stride, frame.height, frame.timeStamp);
    }

    @Override
    public int updateLocalAvatarConfig(MetachatUserAvatarConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeUpdateLocalAvatarConfig(this.mNativeHandle, config);
    }

    private static native int nativeDestroy(long var0);

    private native int nativeAddEventHandler(long var1, Object var3);

    private native int nativeRemoveEventHandler(long var1, Object var3);

    private native int nativeEnterScene(long var1, MetachatSceneInfo var3, MetachatUserAvatarConfig var4);

    private native int nativeLeaveScene(long var1);

    private native int nativeSendMessageToScene(long var1, byte[] var3);

    private native int nativeSetSceneParameters(long var1, String var3);

    private native int nativeEnableUserPositionNotification(long var1, boolean var3);

    private native int nativeEnableVideoDisplay(long var1, int var3, boolean var4);

    private native int nativePushVideoFrameToDisplay(long var1, int var3, int var4, byte[] var5, int var6, int var7, long var8);

    private native int nativeUpdateLocalAvatarConfig(long var1, MetachatUserAvatarConfig var3);
}

