/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import io.agora.rtc2.IMediaRecorderCallback;
import io.agora.rtc2.RtcConnection;
import io.agora.rtc2.RtcEngine;
import io.agora.rtc2.internal.RtcEngineImpl;
import java.lang.ref.WeakReference;

public class AgoraMediaRecorder {
    public static final int RECORDER_STATE_ERROR = -1;
    public static final int RECORDER_STATE_START = 2;
    public static final int RECORDER_STATE_STOP = 3;
    public static final int RECORDER_ERROR_NONE = 0;
    public static final int RECORDER_ERROR_WRITE_FAILED = 1;
    public static final int RECORDER_ERROR_NO_STREAM = 2;
    public static final int RECORDER_ERROR_OVER_MAX_DURATION = 3;
    public static final int RECORDER_ERROR_CONFIG_CHANGED = 4;
    public static final int STREAM_TYPE_AUDIO = 1;
    public static final int STREAM_TYPE_VIDEO = 2;
    public static final int STREAM_TYPE_BOTH = 3;
    public static final int CONTAINER_MP4 = 1;
    private static AgoraMediaRecorder mRecorder = null;
    WeakReference<RtcEngineImpl> mEngineReference;

    private AgoraMediaRecorder(RtcEngineImpl engine) {
        this.mEngineReference = new WeakReference<RtcEngineImpl>(engine);
    }

    private void setEngine(RtcEngineImpl engine) {
        this.mEngineReference = new WeakReference<RtcEngineImpl>(engine);
    }

    public static synchronized AgoraMediaRecorder getMediaRecorder(RtcEngine engine) {
        RtcEngineImpl engineImpl = (RtcEngineImpl)engine;
        if (mRecorder == null) {
            mRecorder = new AgoraMediaRecorder(engineImpl);
        } else {
            mRecorder.setEngine(engineImpl);
        }
        return mRecorder;
    }

    public int setMediaRecorderObserver(RtcConnection connection, IMediaRecorderCallback callback) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return engine.setMediaRecorderObserver(callback, connection);
    }

    public int startRecording(RtcConnection connection, MediaRecorderConfiguration config) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return engine.startRecording(config.storagePath, config.containerFormat, config.streamType, config.maxDurationMs, config.recorderInfoUpdateInterval, connection);
    }

    public int stopRecording(RtcConnection connection) {
        RtcEngineImpl engine = null;
        if (this.mEngineReference == null || (engine = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return engine.stopRecording(connection);
    }

    public void release() {
        RtcEngineImpl engine = null;
        if (this.mEngineReference != null && (engine = (RtcEngineImpl)this.mEngineReference.get()) != null) {
            engine.releaseRecorder();
        }
        this.mEngineReference = null;
    }

    public static class MediaRecorderConfiguration {
        public String storagePath;
        public int containerFormat = 1;
        public int streamType = 3;
        public int maxDurationMs = 120000;
        public int recorderInfoUpdateInterval = 0;

        public MediaRecorderConfiguration(String storagePath, int containerFormat, int streamType, int maxDurationMs, int recorderInfoUpdateInterval) {
            this.storagePath = storagePath;
            this.containerFormat = containerFormat;
            this.streamType = streamType;
            this.maxDurationMs = maxDurationMs;
            this.recorderInfoUpdateInterval = recorderInfoUpdateInterval;
        }
    }
}

