/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import android.content.Context;
import io.agora.base.internal.CalledByNative;
import io.agora.rtc2.Constants;
import io.agora.rtc2.IAgoraEventHandler;
import io.agora.rtc2.IMediaExtensionObserver;
import java.util.ArrayList;
import java.util.List;

public class RtcEngineConfig {
    public Context mContext = null;
    public String mAppId = "";
    public int mAreaCode = -1;
    public IAgoraEventHandler mEventHandler = null;
    public int mChannelProfile = 1;
    public String mLicense = "";
    public int mAudioScenario = 0;
    public List<String> mExtensionList = new ArrayList<String>();
    public IMediaExtensionObserver mExtensionObserver = null;
    public LogConfig mLogConfig = new LogConfig();
    public Integer mThreadPriority = null;
    public String mNativeLibPath;
    public boolean mDomainLimit = false;

    public void addExtension(String providerName) {
        this.mExtensionList.add(providerName);
    }

    @CalledByNative
    public Context getContext() {
        return this.mContext;
    }

    @CalledByNative
    public String getAppId() {
        return this.mAppId;
    }

    @CalledByNative
    public int getChannelProfile() {
        return this.mChannelProfile;
    }

    @CalledByNative
    public String getLicense() {
        return this.mLicense;
    }

    @CalledByNative
    public int getAudioScenario() {
        return this.mAudioScenario;
    }

    @CalledByNative
    public int getAreaCode() {
        return this.mAreaCode;
    }

    @CalledByNative
    public IMediaExtensionObserver getExtensionObserver() {
        return this.mExtensionObserver;
    }

    @CalledByNative
    public LogConfig getLogConfig() {
        return this.mLogConfig;
    }

    @CalledByNative
    public Integer getThreadPriority() {
        return this.mThreadPriority;
    }

    @CalledByNative
    public boolean getDomainLimit() {
        return this.mDomainLimit;
    }

    public static class LogConfig {
        public String filePath;
        public int fileSizeInKB;
        public int level = Constants.LogLevel.getValue(Constants.LogLevel.LOG_LEVEL_INFO);

        @CalledByNative(value="LogConfig")
        public String getFilePath() {
            return this.filePath;
        }

        @CalledByNative(value="LogConfig")
        public int getFileSize() {
            return this.fileSizeInKB;
        }

        @CalledByNative(value="LogConfig")
        public int getLevel() {
            return this.level;
        }
    }

    public static class AreaCode {
        public static final int AREA_CODE_NONE = 0;
        public static final int AREA_CODE_CN = 1;
        public static final int AREA_CODE_NA = 2;
        public static final int AREA_CODE_EU = 4;
        public static final int AREA_CODE_AS = 8;
        public static final int AREA_CODE_JP = 16;
        public static final int AREA_CODE_IN = 32;
        public static final int AREA_CODE_GLOB = -1;

        private AreaCode() {
        }
    }
}

