/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.gl;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.EglBaseFactory;
import java.util.Objects;
import javax.microedition.khronos.egl.EGL10;

public class EglBaseProvider {
    private static final String RELEASE_MESSAGE_TEMPLATE = "EglBaseProvider released %s unavailable";
    @Nullable
    private static volatile EglBaseProvider instance;
    private EglBase rootEglBase;
    private EglBase localEglBase;
    private EglBase remoteEglBase;
    private volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @CalledByNative
    public static EglBaseProvider instance() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            if (instance == null) {
                instance = new EglBaseProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static void destroy() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            if (instance != null) {
                instance.release();
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EglBase getRootEglBase() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            this.checkReleased("getRootEglBase");
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return EglBaseProvider.instance.rootEglBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EglBase getLocalEglBase() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            this.checkReleased("getLocalEglBase");
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return EglBaseProvider.instance.localEglBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public EglBase.Context getLocalEglBaseContext() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            this.checkReleased("getLocalEglBaseContext");
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return EglBaseProvider.instance.localEglBase.getEglBaseContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EglBase getRemoteEglBase() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            this.checkReleased("getRemoteEglBase");
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return EglBaseProvider.instance.remoteEglBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public EglBase.Context getRemoteEglBaseContext() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            this.checkReleased("getRemoteEglBaseContext");
            this.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return EglBaseProvider.instance.remoteEglBase.getEglBaseContext();
        }
    }

    @Nullable
    @CalledByNative
    public static EglBase.Context getCurrentEglContext() {
        EglBase.Context eglContext = null;
        if (EglBase14.isEGL14SupportedImpl()) {
            EGLContext currentContext = EGL14.eglGetCurrentContext();
            if (!Objects.equals(currentContext, EGL14.EGL_NO_CONTEXT)) {
                eglContext = new EglBase14.Context(currentContext);
            }
        } else {
            EGL10 egl = (EGL10)javax.microedition.khronos.egl.EGLContext.getEGL();
            if (egl != null && Objects.equals(egl.eglGetCurrentContext(), EGL10.EGL_NO_CONTEXT)) {
                eglContext = new EglBase10.Context(egl.eglGetCurrentContext());
            }
        }
        return eglContext;
    }

    @CalledByNative
    public static boolean isEgl14BaseContext(EglBase.Context context) {
        return context instanceof EglBase14.Context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void replaceRootBase(EglBase.Context context) {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            this.release();
            this.rootEglBase = EglBaseFactory.create(context, EglBase.CONFIG_PLAIN);
            this.localEglBase = EglBaseFactory.create(this.rootEglBase.getEglBaseContext());
            this.remoteEglBase = EglBaseFactory.create(this.rootEglBase.getEglBaseContext());
            this.initialized = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @CalledByNative
    public static void acquireEglBaseReadLock() {
        EglBase.rwlock.readLock().lock();
    }

    @CalledByNative
    public static void releaseEglBaseReadLock() {
        EglBase.rwlock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Class<EglBaseProvider> clazz = EglBaseProvider.class;
        synchronized (EglBaseProvider.class) {
            if (this.remoteEglBase != null) {
                this.remoteEglBase.release();
            }
            if (this.localEglBase != null) {
                this.localEglBase.release();
            }
            if (this.rootEglBase != null) {
                this.rootEglBase.release();
            }
            this.initialized = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private EglBaseProvider() {
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.rootEglBase = EglBaseFactory.create();
        this.localEglBase = EglBaseFactory.create(this.rootEglBase.getEglBaseContext());
        this.remoteEglBase = EglBaseFactory.create(this.rootEglBase.getEglBaseContext());
        this.initialized = true;
    }

    private void checkReleased(String methodName) {
        if (instance == null) {
            String releaseErrorMessage = String.format(RELEASE_MESSAGE_TEMPLATE, methodName);
            throw new IllegalStateException(releaseErrorMessage);
        }
    }
}

