/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.FaceDetectionInfo;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.rtc2.video.IVideoCaptureCamera;
import io.agora.rtc2.video.VideoCapture;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class VideoCaptureCamera
extends VideoCapture
implements IVideoCaptureCamera {
    private static final String TAG = VideoCaptureCamera.class.getSimpleName();
    protected final int mId;
    protected final boolean mCaptureToTexture;
    protected boolean mEnableAutoFaceFocus = false;
    protected boolean mEnableFaceDetection = false;
    protected boolean mIsFaceDetectionStarted = false;
    private static final String[] SIZE_HEIGHT_GT_720_BUGGY_DEVICE_LIST = new String[]{"Lenovo K520"};
    protected LinkedBlockingQueue<List<FaceDetectionInfo>> mPerFrameFaceDetectionInfoQueue = new LinkedBlockingQueue();
    CaptureViewWeakRef mRenderView = new CaptureViewWeakRef(null);
    boolean isMirror = false;
    int mRenderMode;

    @VisibleForTesting
    public boolean isEnableAutoFaceFocus() {
        return this.mEnableAutoFaceFocus;
    }

    @VisibleForTesting
    public boolean isEnableFaceDetection() {
        return this.mEnableFaceDetection;
    }

    @VisibleForTesting
    public boolean isFaceDetectionStarted() {
        return this.mIsFaceDetectionStarted;
    }

    VideoCaptureCamera(int id, long nativeVideoCaptureAndroid, boolean captureToTexture, boolean pqFist, EglBase.Context sharedContext) {
        super(nativeVideoCaptureAndroid, sharedContext);
        this.mId = id;
        this.mPQFirst = pqFist;
        this.mCaptureToTexture = captureToTexture && this.mSurfaceTextureHelper != null;
    }

    static boolean shouldExcludeSize(int width, int height) {
        if (height > 720) {
            for (String buggyDevice : SIZE_HEIGHT_GT_720_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return true;
            }
        }
        return false;
    }

    protected static VideoCapture.FramerateRange getClosestFramerateRange(List<VideoCapture.FramerateRange> framerateRanges, final int targetFramerate) {
        return Collections.min(framerateRanges, new Comparator<VideoCapture.FramerateRange>(){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int value, int threshold, int lowWeight, int highWeight) {
                return value < threshold ? value * lowWeight : threshold * lowWeight + (value - threshold) * highWeight;
            }

            int diff(VideoCapture.FramerateRange range) {
                int minFpsError = this.progressivePenalty(range.min, 8000, 1, 4);
                int maxFpsError = this.progressivePenalty(Math.abs(targetFramerate - range.max), 5000, 1, 3);
                return minFpsError + maxFpsError;
            }

            @Override
            public int compare(VideoCapture.FramerateRange range1, VideoCapture.FramerateRange range2) {
                return this.diff(range1) - this.diff(range2);
            }
        });
    }

    @Nullable
    private static VideoCapture.FramerateRange findBestFrameRateRangePreferFPS(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate) {
        Collections.sort(framerateRanges, new Comparator<VideoCapture.FramerateRange>(){

            @Override
            public int compare(VideoCapture.FramerateRange o1, VideoCapture.FramerateRange o2) {
                int result = o1.min - o2.min;
                return result == 0 ? o1.max - o2.max : result;
            }
        });
        Logging.d(TAG, "sorted fps Ranges List order by min first:" + framerateRanges.toString());
        for (VideoCapture.FramerateRange range : framerateRanges) {
            if (range.min < targetFramerate) continue;
            Logging.d(TAG, "set fps : " + range.toString() + " to camera in fps first mode, request:" + targetFramerate);
            return range;
        }
        return null;
    }

    @Nullable
    private static VideoCapture.FramerateRange findBestFrameRateRangePreferPQ(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate) {
        Collections.sort(framerateRanges, new Comparator<VideoCapture.FramerateRange>(){

            @Override
            public int compare(VideoCapture.FramerateRange o1, VideoCapture.FramerateRange o2) {
                int result = o1.max - o2.max;
                return result == 0 ? o1.min - o2.min : result;
            }
        });
        Logging.d(TAG, "sorted fps Ranges List order by max first:" + framerateRanges.toString());
        for (VideoCapture.FramerateRange range : framerateRanges) {
            if (range.max < targetFramerate) continue;
            Logging.d(TAG, "set fps : " + range.toString() + " to camera in PQ first mode, request:" + targetFramerate);
            return range;
        }
        return null;
    }

    @Nullable
    static VideoCapture.FramerateRange findBestFrameRateRange(@NonNull List<VideoCapture.FramerateRange> framerateRanges, int targetFramerate, boolean pqFirst) {
        if (framerateRanges.isEmpty()) {
            return null;
        }
        Logging.d(TAG, "findBestFrameRateRange " + framerateRanges.toString());
        VideoCapture.FramerateRange result = pqFirst ? VideoCaptureCamera.findBestFrameRateRangePreferPQ(framerateRanges, targetFramerate) : VideoCaptureCamera.findBestFrameRateRangePreferFPS(framerateRanges, targetFramerate);
        if (result == null) {
            Logging.e(TAG, "Failed to find match fps in " + (pqFirst ? "PQ" : " FPS") + " first mode, try closest.");
            result = VideoCaptureCamera.getClosestFramerateRange(framerateRanges, targetFramerate);
        }
        return result;
    }

    protected void notifyCameraFocusAreaChanged(Rect focusRect) {
        if (this.mNativeVideoCaptureAndroid != 0L) {
            this.nativeNotifyCameraFocusAreaChanged(this.mNativeVideoCaptureAndroid, focusRect.width(), focusRect.height(), focusRect.left, focusRect.top);
        }
    }

    protected void notifyFaceDetection(int imageWidth, int imageHeight, ArrayList<RectF> faceArray, ArrayList<Double> distanceArray) {
        int size = faceArray.size();
        if (this.mNativeVideoCaptureAndroid != 0L && size > 0) {
            ArrayList<FaceDetectionInfo> list = new ArrayList<FaceDetectionInfo>();
            for (int i = 0; i <= size - 1; ++i) {
                Rect rc = new Rect();
                faceArray.get(i).round(rc);
                list.add(new FaceDetectionInfo(i, rc, distanceArray.get(i)));
            }
            this.mPerFrameFaceDetectionInfoQueue.offer(list);
        }
    }

    protected void notifyCameraExposureAreaChanged(Rect rect) {
        if (this.mNativeVideoCaptureAndroid != 0L) {
            this.nativeNotifyCameraExposureAreaChanged(this.mNativeVideoCaptureAndroid, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, rect.left, rect.top);
        }
    }

    @Override
    public void setPreviewInfo(View view, boolean mirror, int renderMode) {
        this.mRenderView = new CaptureViewWeakRef(view);
        this.isMirror = mirror;
        this.mRenderMode = renderMode;
    }

    protected native void nativeNotifyCameraFocusAreaChanged(long var1, int var3, int var4, int var5, int var6);

    protected native void nativeNotifyCameraExposureAreaChanged(long var1, int var3, int var4, int var5, int var6);

    protected void attachPerFrameMetaInfos(VideoFrame videoFrame) {
        if (this.mPerFrameFaceDetectionInfoQueue.isEmpty()) {
            return;
        }
        ArrayList faceDetectionInfoList = (ArrayList)this.mPerFrameFaceDetectionInfoQueue.poll();
        for (FaceDetectionInfo faceDetectionInfo : faceDetectionInfoList) {
            videoFrame.getMetaInfo().getCustomMetaInfo(FaceDetectionInfo.class.getSimpleName()).put(faceDetectionInfo.getId(), (Object)faceDetectionInfo);
        }
    }

    protected class CaptureViewWeakRef<V>
    extends WeakReference<View> {
        public CaptureViewWeakRef(View referent) {
            super(referent);
        }

        public int getWidth() {
            return this.get() == null ? 0 : ((View)this.get()).getWidth();
        }

        public int getHeight() {
            return this.get() == null ? 0 : ((View)this.get()).getHeight();
        }
    }
}

