/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Range;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.BitrateAdjuster;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.FactorBitrateAdjuster;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapper;
import io.agora.base.internal.video.MediaCodecWrapperFactory;
import io.agora.base.internal.video.VideoCodecStatus;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoEncoder;
import io.agora.base.internal.video.VideoEncoderWrapper;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.YuvHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

@TargetApi(value=19)
class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final String KEY_AV_ENC_VIDEO_WIDTH_ALIGNMENT = "av_enc_video_width_alignment";
    private static final String KEY_AV_ENC_VIDEO_HEIGHT_ALIGNMENT = "av_enc_video_height_alignment";
    private static final String KEY_AV_ENC_VIDEO_FORCE_ALIGNMENT = "av_enc_video_force_alignment";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int VIDEO_ControlRateVariable = 1;
    private static final int VIDEO_ControlQualityConstant = 0;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3_1 = 512;
    private static final int VIDEO_HEVC_PROFILE_MAIN = 1;
    private static final int VIDEO_HEVC_MAINLEVEL_31 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MAX_ENCODER_Q_SIZE = 5;
    private static final int MAX_ENCODER_Q_WAIT_TIMEOUT_MS = 2000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int MAX_ENCODE_TIME_MS = 2000;
    private static final int DEFAULT_WIDTH_ALIGNMENT = 16;
    private static final int DEFAULT_HEIGHT_ALIGNMENT = 4;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private int maxSupportedWidth = 32768;
    private int maxSupportedHeight = 32768;
    private int minSupportedWidth = 2;
    private int minSupportedHeight = 2;
    private int maxSupportedBitrate = 0;
    private int minSupportedBitrate = 0;
    private int widthAlignment = 16;
    private int heightAlignment = 4;
    private boolean forceAlignment = true;
    private final VideoCodecType codecType;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private final BitrateAdjuster bitrateAdjuster;
    @Nullable
    private EglBase.Context sharedContext;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final BlockingDeque<EncodedImage.Builder> outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
    private final ThreadUtils.ThreadChecker encodeThreadChecker = new ThreadUtils.ThreadChecker();
    private final ThreadUtils.ThreadChecker outputThreadChecker = new ThreadUtils.ThreadChecker();
    @Nullable
    private String customConfigJson;
    private final Queue<TimeStamps> encodeTimeStamps = new ConcurrentLinkedQueue<TimeStamps>();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private Thread outputThread;
    @Nullable
    private EglBase textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private int alignedWidth;
    private int alignedHeight;
    private int bitrateMode;
    private boolean useSurfaceMode;
    private boolean shouldUseBaseline;
    private boolean shouldFallbackSoftware;
    private boolean shouldResetCodecByException;
    private boolean deliverEncodeResult;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer = null;
    private int adjustedBitrate;
    private volatile boolean running = false;
    @Nullable
    private volatile Exception shutdownException = null;
    private Map<Long, CodecSpecificInfo> codecSpecificInfoMap = new HashMap<Long, CodecSpecificInfo>();
    @Nullable
    private VideoEncoder.EncoderStyle encoderStyle;
    private long firstEncoderQueueFullMs = -1L;
    @VisibleForTesting
    private static boolean mockEncoderQueueFull = false;
    private static final int kMaxVuiSpsIncrease = 64;
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final String[] H264_HW_QCOM_EXCEPTION_MODELS = new String[]{"mi note lte", "redmi note 4x", "1605-a01", "aosp on hammerhead", "lm-x210", "oppo r9s"};
    private static final String[] MTK_NO_ADJUSTMENT_MODELS = new String[]{"vivo y83a", "vivo x21i", "vivo X21i A"};
    private static final String[] INTERVAL_HW_EXCEPTION_MODELS = new String[]{"vivo X21A", "MI 8", "MI 6", "MI 8 Lite", "Redmi Note 7"};
    private static final int INT_SETTING_INTERVAL_VALUE = 10;
    private static final int INT_INTERVAL_UPPER_LIMIT = 100;

    @VisibleForTesting
    public static void setMockEncoderQueueFull(boolean mockEncoderQueueFull) {
        HardwareVideoEncoder.mockEncoderQueueFull = mockEncoderQueueFull;
    }

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, Integer surfaceColorFormat, Integer yuvColorFormat, Map<String, String> params, int keyFrameIntervalSec, int forceKeyFrameIntervalMs, BitrateAdjuster bitrateAdjuster, EglBase.Context sharedContext) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecType = codecType;
        this.surfaceColorFormat = surfaceColorFormat;
        this.yuvColorFormat = yuvColorFormat;
        this.yuvFormat = YuvFormat.valueOf(yuvColorFormat, MediaCodecUtils.yuv420spPreferNV21(codecName));
        this.params = params;
        this.keyFrameIntervalSec = keyFrameIntervalSec;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(forceKeyFrameIntervalMs);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = sharedContext;
        this.encodeThreadChecker.detachThread();
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.alignedWidth = settings.width;
        this.alignedHeight = settings.height;
        this.encodeTimeStamps.clear();
        this.bitrateMode = settings.rateControlMode >= 0 ? settings.rateControlMode : 1;
        this.useSurfaceMode = this.canUseSurface(this.sharedContext);
        this.shouldUseBaseline = VideoEncoderWrapper.shouldUseBaseline();
        this.shouldFallbackSoftware = false;
        this.shouldResetCodecByException = false;
        this.deliverEncodeResult = false;
        if (settings.startBitrate != 0 && settings.maxFramerate != 0) {
            this.bitrateAdjuster.setTargets(settings.startBitrate * 1000, settings.maxFramerate);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        if (settings.keyFrameInterval != 0 && settings.maxFramerate != 0) {
            this.keyFrameIntervalSec = settings.keyFrameInterval;
        }
        if (Arrays.asList(INTERVAL_HW_EXCEPTION_MODELS).contains(Build.MODEL) && this.keyFrameIntervalSec >= 100) {
            Logging.d(TAG, "Model: " + Build.MODEL + " , need to modify interval. original keyInterval: " + this.keyFrameIntervalSec);
            this.keyFrameIntervalSec = 10;
        }
        Logging.w(TAG, "initEncode: " + this.width + " x " + this.height + ". @ " + settings.startBitrate + "kbps. Fps: " + settings.maxFramerate + " Use surface mode: " + this.useSurfaceMode + " keyFrameIntervalSec: " + this.keyFrameIntervalSec + " bitrateMode: " + this.bitrateMode);
        return this.initEncodeInternal();
    }

    private VideoCodecStatus initEncodeInternal() {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        this.firstEncoderQueueFullMs = -1L;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot create media encoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.readVideoCapabilities();
        this.resolutionAlignmentChecker();
        String profileLevelId = "";
        int colorFormat = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.alignedWidth, (int)this.alignedHeight);
            format.setInteger("bitrate", this.adjustedBitrate);
            format.setInteger(KEY_BITRATE_MODE, this.bitrateMode);
            format.setInteger("color-format", colorFormat);
            format.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
            format.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            if (this.codecType == VideoCodecType.H264) {
                profileLevelId = this.params.get("profile-level-id");
                String isH264HighProfileSupported = this.params.get("is-highprofile-supported");
                if (profileLevelId != null) {
                    Logging.d(TAG, "h264_profile:" + profileLevelId);
                }
                if (isH264HighProfileSupported != null) {
                    Logging.d(TAG, "is-highprofile-supported:" + isH264HighProfileSupported);
                }
                if (profileLevelId == null || isH264HighProfileSupported == null || isH264HighProfileSupported.equals("false") || this.shouldUseBaseline) {
                    profileLevelId = "";
                }
                if ("640c1f".equals(profileLevelId)) {
                    format.setInteger("profile", 8);
                    format.setInteger("level", 512);
                } else if ("4d001f".equals(profileLevelId)) {
                    format.setInteger("profile", 2);
                } else if ("42e01f".equals(profileLevelId)) {
                    format.setInteger("profile", 1);
                } else {
                    Logging.w(TAG, "Unknown profile level id: " + profileLevelId);
                }
            } else if (this.codecType == VideoCodecType.H265) {
                format.setInteger("profile", 1);
                format.setInteger("level", 256);
                format.setInteger(KEY_BITRATE_MODE, 1);
            }
            this.customConfigJson = this.params.get("av_enc_video_hwenc_config");
            MediaCodecUtils.applyCustomConfig(format, this.customConfigJson);
            Logging.d(TAG, "Format: " + format);
            this.codec.configure(format, null, null, 1);
            if (this.useSurfaceMode) {
                if (this.sharedContext instanceof EglBase10.Context) {
                    Logging.w(TAG, "Encoders will use EglBase10");
                    this.textureEglBase = new EglBase10((EglBase10.Context)this.sharedContext, EglBase.CONFIG_RECORDABLE);
                } else {
                    Logging.w(TAG, "Encoders will use EglBase14");
                    this.textureEglBase = new EglBase14((EglBase14.Context)this.sharedContext, EglBase.CONFIG_RECORDABLE);
                }
                this.textureInputSurface = this.codec.createInputSurface();
                this.textureEglBase.createSurface(this.textureInputSurface);
                this.textureEglBase.makeCurrent();
            }
            this.codec.start();
        }
        catch (Throwable t) {
            Logging.e(TAG, "initEncodeInternal failed. " + t.getMessage());
            this.release();
            if (null != profileLevelId && !profileLevelId.isEmpty()) {
                return VideoCodecStatus.FALLBACK_DEFAULT_PROFILE;
            }
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThreadChecker.detachThread();
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        return VideoCodecStatus.OK;
    }

    private boolean parseAlignmentFromParam() {
        try {
            String widthAlignmentStr = this.params.get(KEY_AV_ENC_VIDEO_WIDTH_ALIGNMENT);
            String heightAlignmentStr = this.params.get(KEY_AV_ENC_VIDEO_HEIGHT_ALIGNMENT);
            String forceAlignmentStr = this.params.get(KEY_AV_ENC_VIDEO_FORCE_ALIGNMENT);
            if (widthAlignmentStr != null) {
                this.widthAlignment = Integer.parseInt(widthAlignmentStr);
            }
            if (heightAlignmentStr != null) {
                this.heightAlignment = Integer.parseInt(heightAlignmentStr);
            }
            if (forceAlignmentStr != null) {
                this.forceAlignment = Boolean.parseBoolean(forceAlignmentStr);
            }
            return widthAlignmentStr != null && heightAlignmentStr != null;
        }
        catch (Exception e) {
            Logging.d(TAG, "fail to convert alignment");
            return false;
        }
    }

    private int parseAdjustmentTypeFromParam() {
        try {
            int adjustmentType;
            String paramsAdjustmentType = this.params.get("av_enc_bitrate_adjustment_type");
            if (paramsAdjustmentType != null && (adjustmentType = Integer.parseInt(paramsAdjustmentType)) >= 0 && adjustmentType <= 3) {
                Logging.d(TAG, "parse from param, bitrate adjustment type: " + paramsAdjustmentType);
                return adjustmentType;
            }
        }
        catch (Exception e) {
            Logging.d(TAG, "fail to convert adjustmentType.");
        }
        return -1;
    }

    private void readVideoCapabilities() {
        Range brs;
        Range heights;
        Range widths;
        boolean parseAlignmentFromParam = this.parseAlignmentFromParam();
        if (parseAlignmentFromParam) {
            Logging.w(TAG, "parse from param, align size: " + this.widthAlignment + "x" + this.heightAlignment + " ");
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.codec.getCodecInfo(this.codecType.mimeType());
        if (codecCapabilities == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        if (!parseAlignmentFromParam) {
            this.widthAlignment = Math.max(videoCapabilities.getWidthAlignment(), 16);
            this.heightAlignment = Math.max(videoCapabilities.getHeightAlignment(), 4);
        }
        if ((widths = videoCapabilities.getSupportedWidths()) != null) {
            this.maxSupportedWidth = (Integer)widths.getUpper();
            this.minSupportedWidth = (Integer)widths.getLower();
        }
        if ((heights = videoCapabilities.getSupportedHeights()) != null) {
            this.maxSupportedHeight = (Integer)heights.getUpper();
            this.minSupportedHeight = (Integer)heights.getLower();
        }
        if ((brs = videoCapabilities.getBitrateRange()) != null) {
            this.maxSupportedBitrate = (Integer)brs.getUpper();
            this.minSupportedBitrate = (Integer)brs.getLower();
        }
        Logging.d(TAG, this.codecType.mimeType() + "  max supported size:" + this.maxSupportedWidth + "x" + this.maxSupportedHeight + " min supported size:" + this.minSupportedWidth + "x" + this.minSupportedHeight + " align size: " + this.widthAlignment + "x" + this.heightAlignment + " bitrate range: " + this.maxSupportedBitrate + " -> " + this.minSupportedBitrate);
    }

    private void resolutionAlignmentChecker() {
        if (this.useSurfaceMode) {
            if (!this.forceAlignment) {
                return;
            }
            Logging.w(TAG, "force resolution alignment in surface mode");
        }
        this.alignedWidth = (this.width + this.widthAlignment - 1) / this.widthAlignment * this.widthAlignment;
        this.alignedHeight = (this.height + this.heightAlignment - 1) / this.heightAlignment * this.heightAlignment;
        Logging.v(TAG, "resolutionAlignmentChecker, alignedWidth : " + this.alignedWidth + ", alignedHeight: " + this.alignedHeight);
    }

    @Override
    public VideoCodecStatus release() {
        VideoCodecStatus returnValue;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.outputThread == null) {
            returnValue = VideoCodecStatus.OK;
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                returnValue = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                Logging.e(TAG, "Media encoder release exception", this.shutdownException);
                returnValue = VideoCodecStatus.ERROR;
            } else {
                returnValue = VideoCodecStatus.OK;
            }
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        if (this.textureEglBase != null) {
            this.textureEglBase.release();
            this.textureEglBase = null;
        }
        if (this.textureInputSurface != null) {
            this.textureInputSurface.release();
            this.textureInputSurface = null;
        }
        this.outputBuilders.clear();
        this.encodeTimeStamps.clear();
        this.codecSpecificInfoMap.clear();
        this.codec = null;
        this.outputThread = null;
        this.shouldFallbackSoftware = false;
        this.shouldResetCodecByException = false;
        this.deliverEncodeResult = false;
        this.encodeThreadChecker.detachThread();
        return returnValue;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo encodeInfo, CodecSpecificInfo codecSpecificInfo) {
        VideoCodecStatus status;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame.Buffer videoFrameBuffer = videoFrame.getBuffer();
        boolean isTextureBuffer = videoFrameBuffer instanceof VideoFrame.TextureBuffer;
        EglBase.Context sharedContextInFrame = isTextureBuffer ? ((VideoFrame.TextureBuffer)videoFrameBuffer).getEglBaseContext() : null;
        int frameWidth = videoFrame.getBuffer().getWidth();
        int frameHeight = videoFrame.getBuffer().getHeight();
        boolean shouldUseSurfaceMode = isTextureBuffer && this.canUseSurface(sharedContextInFrame);
        boolean contextChanged = !HardwareVideoEncoder.objectsEquals(this.sharedContext, sharedContextInFrame);
        boolean newShouldUseBaseline = VideoEncoderWrapper.shouldUseBaseline();
        if ((frameWidth != this.width || frameHeight != this.height || shouldUseSurfaceMode != this.useSurfaceMode || contextChanged || this.shouldUseBaseline != newShouldUseBaseline || this.shouldResetCodecByException) && (status = this.resetCodec(frameWidth, frameHeight, shouldUseSurfaceMode, newShouldUseBaseline, sharedContextInFrame)) != VideoCodecStatus.OK) {
            return status;
        }
        if (this.shouldFallbackSoftware) {
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.outputBuilders.size() > 5 || mockEncoderQueueFull) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            long now = System.currentTimeMillis();
            if (this.firstEncoderQueueFullMs < 0L) {
                this.firstEncoderQueueFullMs = now;
            }
            if (now - this.firstEncoderQueueFullMs > 2000L) {
                Logging.e(TAG, "Fallback to software, encoder queue full");
                this.release();
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            return VideoCodecStatus.NO_OUTPUT;
        }
        this.firstEncoderQueueFullMs = -1L;
        boolean requestedKeyFrame = false;
        for (EncodedImage.FrameType frameType : encodeInfo.frameTypes) {
            if (frameType != EncodedImage.FrameType.VideoFrameKey) continue;
            requestedKeyFrame = true;
        }
        boolean shouldForceKeyFrame = this.shouldForceKeyFrame(videoFrame.getTimestampNs());
        if (requestedKeyFrame || shouldForceKeyFrame) {
            Logging.w(TAG, "request KeyFrame: " + requestedKeyFrame + ". shouldForce KeyFrame: " + shouldForceKeyFrame);
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        int bufferSize = this.alignedWidth * this.alignedHeight * 3 / 2;
        EncodedImage.Builder builder = EncodedImage.builder().setCaptureTimeNs(videoFrame.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(this.width).setEncodedHeight(this.height).setRotation(videoFrame.getRotation());
        this.outputBuilders.offer(builder);
        VideoCodecStatus returnValue = this.useSurfaceMode ? this.encodeTextureBuffer(videoFrame, codecSpecificInfo) : this.encodeByteBuffer(videoFrame, videoFrameBuffer, bufferSize, codecSpecificInfo);
        if (returnValue != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        return returnValue;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame, CodecSpecificInfo codecSpecificInfo) {
        this.encodeThreadChecker.checkIsOnValidThread();
        long presentationTimestampUs = (videoFrame.getTimestampNs() + 500L) / 1000L;
        TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), presentationTimestampUs);
        this.encodeTimeStamps.add(timeStamps);
        try {
            if (codecSpecificInfo != null) {
                this.codecSpecificInfoMap.put(presentationTimestampUs, codecSpecificInfo);
            }
            GLES20.glClear((int)16384);
            VideoFrame derotatedFrame = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(derotatedFrame, this.textureDrawer, null);
            this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "encodeTexture failed", e);
            this.codecSpecificInfoMap.remove(presentationTimestampUs);
            this.encodeTimeStamps.remove(timeStamps);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer videoFrameBuffer, int bufferSize, CodecSpecificInfo codecSpecificInfo) {
        ByteBuffer buffer;
        int index;
        this.encodeThreadChecker.checkIsOnValidThread();
        long presentationTimestampUs = (videoFrame.getTimestampNs() + 500L) / 1000L;
        try {
            index = this.codec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "dequeueInputBuffer failed", e);
            return MediaCodecUtils.isMediaCodecException(e, this.deliverEncodeResult);
        }
        if (index == -1) {
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            buffer = this.codec.getInputBuffers()[index];
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "getInputBuffers failed", e);
            return MediaCodecUtils.isMediaCodecException(e, this.deliverEncodeResult);
        }
        this.fillInputBuffer(buffer, videoFrameBuffer);
        TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), presentationTimestampUs);
        try {
            if (codecSpecificInfo != null) {
                this.codecSpecificInfoMap.put(presentationTimestampUs, codecSpecificInfo);
            }
            this.codec.queueInputBuffer(index, 0, bufferSize, presentationTimestampUs, 0);
            this.encodeTimeStamps.add(timeStamps);
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "queueInputBuffer failed", e);
            this.codecSpecificInfoMap.remove(presentationTimestampUs);
            this.encodeTimeStamps.remove(timeStamps);
            return MediaCodecUtils.isMediaCodecException(e, this.deliverEncodeResult);
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setChannelParameters(short packetLoss, long roundTripTimeMs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int framerate) {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (framerate > 30) {
            framerate = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), framerate);
        return VideoCodecStatus.OK;
    }

    @Override
    public boolean isQcomHardware() {
        Logging.w(TAG, "[qualcom hardware] codecName:" + this.codecName);
        return this.codecName.startsWith("OMX.qcom");
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            if (this.codecType == VideoCodecType.VP8) {
                int kLowVp8QpThreshold = 29;
                int kHighVp8QpThreshold = 95;
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecType == VideoCodecType.H264) {
                int kLowH264QpThreshold = 28;
                int kHighH264QpThreshold = 35;
                return new VideoEncoder.ScalingSettings(28, 35);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    private VideoCodecStatus resetCodec(int newWidth, int newHeight, boolean newUseSurfaceMode, boolean newShouldUseBaseline, EglBase.Context newSharedContext) {
        this.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus status = this.release();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.width = newWidth;
        this.height = newHeight;
        this.sharedContext = newSharedContext;
        this.useSurfaceMode = newUseSurfaceMode;
        this.shouldUseBaseline = newShouldUseBaseline;
        if (this.sharedContext != null) {
            Logging.d(TAG, "resetCodec. contains shared EglBase.Context. Encoders will use texture mode.");
        } else {
            Logging.w(TAG, "resetCodec. No shared EglBase.Context. Encoders will not use texture mode.");
        }
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return this.forcedKeyFrameNs > 0L && presentationTimestampNs > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    private void requestKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle b = new Bundle();
            b.putInt("request-sync", 0);
            this.codec.setParameters(b);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "requestKeyFrame failed", e);
            return;
        }
        this.lastKeyFrameNs = presentationTimestampNs;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverEncodedImage() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int index = this.codec.dequeueOutputBuffer(info, 100000L);
            if (index < 0) {
                return;
            }
            ByteBuffer codecOutputBuffer = this.codec.getOutputBuffers()[index];
            codecOutputBuffer.position(info.offset);
            codecOutputBuffer.limit(info.offset + info.size);
            if ((info.flags & 2) != 0) {
                Logging.d(TAG, "Config frame generated. Offset: " + info.offset + ". Size: " + info.size);
                this.configBuffer = ByteBuffer.allocateDirect(info.size);
                this.configBuffer.put(codecOutputBuffer);
            } else {
                ByteBuffer frameBuffer;
                boolean isKeyFrame;
                this.bitrateAdjuster.reportEncodedFrame(info.size);
                if (this.adjustedBitrate != this.bitrateAdjuster.getAdjustedBitrateBps()) {
                    this.updateBitrate();
                }
                boolean bl = isKeyFrame = (info.flags & 1) != 0;
                if (isKeyFrame) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (isKeyFrame && (this.codecType == VideoCodecType.H264 || this.codecType == VideoCodecType.H265)) {
                    Logging.d(TAG, "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size);
                    frameBuffer = ByteBuffer.allocateDirect(info.size + this.configBuffer.capacity());
                    this.configBuffer.rewind();
                    frameBuffer.put(this.configBuffer);
                    frameBuffer.put(codecOutputBuffer);
                    frameBuffer.flip();
                } else {
                    frameBuffer = codecOutputBuffer.slice();
                }
                EncodedImage.FrameType frameType = isKeyFrame ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                EncodedImage.Builder builder = this.outputBuilders.poll();
                builder.setBuffer(frameBuffer).setFrameType(frameType);
                CodecSpecificInfo codecSpecificInfo = this.codecSpecificInfoMap.remove(info.presentationTimeUs);
                if (codecSpecificInfo == null) {
                    codecSpecificInfo = new CodecSpecificInfo();
                } else {
                    Logging.d(TAG, "pass codecSpecificInfo info");
                }
                TimeStamps timeStamps = null;
                int encodeDelayFrames = this.encodeTimeStamps.size();
                while (!this.encodeTimeStamps.isEmpty() && (timeStamps = this.encodeTimeStamps.poll()) != null && timeStamps.presentationTimeStampUs != info.presentationTimeUs) {
                    Logging.d(TAG, "HW encodeTimeStamps. cannot find: " + timeStamps.presentationTimeStampUs + "  presentationTimeUs: " + info.presentationTimeUs);
                }
                int encodecDelayTimeMs = -1;
                if (timeStamps == null) {
                    Logging.e(TAG, "HW encodeTimeStamps empty. cannot find: " + info.presentationTimeUs);
                } else {
                    encodecDelayTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.encodecStartTimeMs);
                    if (encodecDelayTimeMs > 2000) {
                        Logging.w(TAG, "Very high encode time: " + encodecDelayTimeMs + "ms.");
                        encodecDelayTimeMs = 2000;
                    }
                }
                this.callback.onEncodedFrame(builder.createEncodedImage(), encodecDelayTimeMs, encodeDelayFrames, codecSpecificInfo);
            }
            this.codec.releaseOutputBuffer(index, false);
            this.deliverEncodeResult = true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverOutput failed", e);
            if (MediaCodecUtils.isMediaCodecException(e, this.deliverEncodeResult) == VideoCodecStatus.ERROR) {
                this.shouldResetCodecByException = true;
            }
            this.shouldFallbackSoftware = true;
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media encoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media encoder release failed", e);
            this.shutdownException = e;
        }
        this.configBuffer = null;
        Logging.d(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate() {
        this.outputThreadChecker.checkIsOnValidThread();
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        try {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", this.adjustedBitrate);
            this.codec.setParameters(params);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "updateBitrate failed", e);
            return MediaCodecUtils.isMediaCodecException(e, this.deliverEncodeResult);
        }
    }

    private boolean canUseSurface(EglBase.Context sharedContext) {
        return sharedContext != null && this.surfaceColorFormat != null;
    }

    protected void fillInputBuffer(ByteBuffer buffer, VideoFrame.Buffer videoFrameBuffer) {
        this.yuvFormat.fillBuffer(buffer, this.alignedWidth, this.alignedHeight, videoFrameBuffer);
    }

    static boolean objectsEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    @Nullable
    @SuppressLint(value={"DefaultLocale"})
    public VideoEncoder.EncoderStyle getEncoderStyle() {
        if (this.encoderStyle != null) {
            return this.encoderStyle;
        }
        this.encoderStyle = new VideoEncoder.EncoderStyle();
        if (this.codecName.startsWith("OMX.qcom.")) {
            List<String> qcomExceptModels = Arrays.asList(H264_HW_QCOM_EXCEPTION_MODELS);
            if (qcomExceptModels.contains(Build.MODEL.toLowerCase())) {
                Logging.w(TAG, "Qcom Exception Model: " + Build.MODEL);
                this.encoderStyle.isNeedResetWhenDownBps = true;
            }
            this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
        } else if (this.codecName.startsWith("OMX.MTK.")) {
            String hardware_str = Build.HARDWARE;
            Logging.v(TAG, "MTK hardware: " + hardware_str);
            if (hardware_str.equalsIgnoreCase("mt6763") || hardware_str.equalsIgnoreCase("mt6763t")) {
                this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            } else {
                List<String> mtkNoAdjustmentModels = Arrays.asList(MTK_NO_ADJUSTMENT_MODELS);
                if (mtkNoAdjustmentModels.contains(Build.MODEL)) {
                    this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
                } else if (hardware_str.equalsIgnoreCase("mt6735")) {
                    this.encoderStyle.bitrateAdjustment = 2;
                    this.encoderStyle.highProfileSupported = false;
                } else {
                    this.encoderStyle.bitrateAdjustment = 2;
                    this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
                }
            }
        } else if (this.codecName.startsWith("OMX.Exynos.")) {
            if (Build.MODEL.equalsIgnoreCase("MX4 Pro")) {
                this.encoderStyle.bitrateAdjustment = 2;
                this.encoderStyle.highProfileSupported = false;
            } else if (Build.MANUFACTURER.equalsIgnoreCase("vivo") && Build.MODEL.equalsIgnoreCase("V1938CT")) {
                this.encoderStyle.bitrateAdjustment = 2;
                this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            } else if (Build.VERSION.SDK_INT > 28) {
                this.encoderStyle.bitrateAdjustment = 2;
                this.encoderStyle.highProfileSupported = true;
            } else {
                this.encoderStyle.bitrateAdjustment = 1;
                this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            }
        } else if (this.codecName.startsWith("OMX.IMG.TOPAZ.")) {
            if (Build.HARDWARE.equalsIgnoreCase("hi6250")) {
                this.encoderStyle.bitrateAdjustment = 2;
            } else {
                this.encoderStyle.highProfileSupported = false;
                this.encoderStyle.bitrateAdjustment = 1;
            }
        } else if (this.codecName.startsWith("OMX.hisi.")) {
            this.encoderStyle.highProfileSupported = false;
            this.encoderStyle.bitrateAdjustment = 2;
        } else if (this.codecName.startsWith("OMX.k3.")) {
            this.encoderStyle.bitrateAdjustment = 1;
            this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
        } else if (this.codecName.startsWith("OMX.amlogic.")) {
            Logging.v(TAG, "getChipProperties for amlogic");
            this.encoderStyle.bitrateAdjustment = 1;
            this.encoderStyle.highProfileSupported = false;
        } else if (this.codecName.startsWith("OMX.rk.")) {
            this.encoderStyle.bitrateAdjustment = 1;
            this.encoderStyle.highProfileSupported = false;
        } else {
            Logging.v(TAG, "getChipProperties from unsupported chip list");
            this.encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 23;
        }
        int adjustmentType = this.parseAdjustmentTypeFromParam();
        if (adjustmentType >= 0) {
            this.encoderStyle.bitrateAdjustment = adjustmentType;
        }
        Logging.d(TAG, "encoderStyle: " + this.encoderStyle);
        if (this.bitrateAdjuster instanceof FactorBitrateAdjuster) {
            FactorBitrateAdjuster cfr_ignored_0 = (FactorBitrateAdjuster)this.bitrateAdjuster;
            this.encoderStyle.bitrateAdjustNumerator = 950;
            FactorBitrateAdjuster cfr_ignored_1 = (FactorBitrateAdjuster)this.bitrateAdjuster;
            this.encoderStyle.bitrateAdjustDenominator = 1000;
        }
        return this.encoderStyle;
    }

    @Override
    public long getResetCoolDownTimeMs() {
        return 2000L;
    }

    @Override
    public boolean isHardwareEncoder() {
        return true;
    }

    @Override
    public long createNativeVideoEncoder() {
        return 0L;
    }

    private static enum YuvFormat {
        I420{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                int dstChromaWidth = (destWidth + 1) / 2;
                int dstChromaHeight = (destHeight + 1) / 2;
                int minSize = destWidth * destHeight + dstChromaWidth * dstChromaHeight * 2;
                if (dstBuffer.capacity() < minSize) {
                    throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dstBuffer.capacity());
                }
                boolean startY = false;
                int startU = destHeight * destWidth;
                int startV = startU + dstChromaHeight * dstChromaWidth;
                dstBuffer.position(0);
                ByteBuffer dstY = dstBuffer.slice();
                dstBuffer.position(startU);
                ByteBuffer dstU = dstBuffer.slice();
                dstBuffer.position(startV);
                ByteBuffer dstV = dstBuffer.slice();
                YuvHelper.I420Copy(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstY, destWidth, dstU, dstChromaWidth, dstV, dstChromaWidth, i420.getWidth(), i420.getHeight());
                i420.release();
            }
        }
        ,
        NV12{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer) {
                2.fillNV12Buffer(dstBuffer, destWidth, destHeight, srcBuffer, false);
            }
        }
        ,
        NV21{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer) {
                3.fillNV12Buffer(dstBuffer, destWidth, destHeight, srcBuffer, true);
            }
        };


        abstract void fillBuffer(ByteBuffer var1, int var2, int var3, VideoFrame.Buffer var4);

        static void fillNV12Buffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer, boolean revertUV) {
            VideoFrame.I420Buffer i420 = srcBuffer.toI420();
            int dstChromaWidth = (destWidth + 1) / 2;
            int dstChromaHeight = (destHeight + 1) / 2;
            int minSize = destWidth * destHeight + dstChromaWidth * dstChromaHeight * 2;
            if (dstBuffer.capacity() < minSize) {
                throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dstBuffer.capacity());
            }
            boolean startY = false;
            int startUV = destHeight * destWidth;
            dstBuffer.position(0);
            ByteBuffer dstY = dstBuffer.slice();
            dstBuffer.position(startUV);
            ByteBuffer dstUV = dstBuffer.slice();
            ByteBuffer tmpDataU = revertUV ? i420.getDataV() : i420.getDataU();
            int tmpStrideU = revertUV ? i420.getStrideV() : i420.getStrideU();
            ByteBuffer tmpDataV = revertUV ? i420.getDataU() : i420.getDataV();
            int tmpStrideV = revertUV ? i420.getStrideU() : i420.getStrideV();
            YuvHelper.I420ToNV12(i420.getDataY(), i420.getStrideY(), tmpDataU, tmpStrideU, tmpDataV, tmpStrideV, dstY, destWidth, dstUV, dstChromaWidth * 2, i420.getWidth(), i420.getHeight());
            i420.release();
        }

        static YuvFormat valueOf(int colorFormat, boolean yuv420spPreferNV21) {
            switch (colorFormat) {
                case 19: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return yuv420spPreferNV21 ? NV21 : NV12;
                }
            }
            throw new IllegalArgumentException("Unsupported colorFormat: " + colorFormat);
        }
    }

    private static class TimeStamps {
        private final long encodecStartTimeMs;
        private final long presentationTimeStampUs;

        public TimeStamps(long encodecStartTimeMs, long presentationTimeStampUs) {
            this.encodecStartTimeMs = encodecStartTimeMs;
            this.presentationTimeStampUs = presentationTimeStampUs;
        }
    }
}

