/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.VideoCodecType;
import java.util.Arrays;
import java.util.List;

class VideoDecoderUtils {
    private static final String TAG = "VideoDecoderUtils";
    private static final List<String> H264_HWDEC_EXCEPTION_MODELS = Arrays.asList("ASUS_T00J");

    VideoDecoderUtils() {
    }

    @CalledByNative
    static boolean isSupportHwDecoderByType(String codecType) {
        Logging.w(TAG, "isSupportHwDecoderByType " + codecType);
        return VideoCodecType.contains(codecType) && VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType)) != null;
    }

    @Nullable
    static MediaCodecInfo findCodecForType(VideoCodecType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || info.isEncoder() || !VideoDecoderUtils.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    static boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            Logging.w(TAG, "selectColorFormat is null");
            return false;
        }
        return VideoDecoderUtils.isHardwareSupported(info, type);
    }

    static boolean isHardwareSupported(MediaCodecInfo info, VideoCodecType type) {
        String name = info.getName();
        switch (type) {
            case VP8: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Intel.") || name.startsWith("OMX.Exynos.") || name.startsWith("OMX.Nvidia.");
            }
            case VP9: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.");
            }
            case H264: {
                if (H264_HWDEC_EXCEPTION_MODELS.contains(Build.MODEL)) {
                    return false;
                }
                if (!MediaCodecUtils.isCodecInPrepareList(info.getName())) {
                    Logging.w(TAG, "not included codec:" + info.getName());
                } else {
                    Logging.d(TAG, "found available codec: " + info.getName());
                }
                Logging.w(TAG, "not included codec:" + info.getName());
                return true;
            }
            case H265: {
                return Build.VERSION.SDK_INT >= 21;
            }
        }
        return false;
    }
}

