/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import io.agora.rtc2.internal.AudioRoutingController;
import io.agora.rtc2.internal.Logging;
import java.lang.ref.WeakReference;
import java.util.List;

public class AudioDeviceInventoryLowerThanM
implements AudioRoutingController.AudioDeviceInventory {
    private static final String TAG = "AudioRoute";
    private static final String PERMISSION_BLUETOOTH_CONNECT = "android.permission.BLUETOOTH_CONNECT";
    private final int STATE_DISCONNECT = -1;
    private final int STATE_CONNECT = 1;
    private final String HEADSET_EXTRA_STATE = "state";
    private final WeakReference<Context> mContext;
    private HeadsetBroadcastReceiver mHeadsetReceiver = null;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver = null;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private AudioRoutingController.AudioDeviceChangedCallback mAudioDeviceChangedCb;
    private int mHeadsetType = -1;
    private static AudioRoutingController.MockedBroadcaseter mockedBroadcaster = null;
    private static final int ANDROID_SNOW_CONE = 31;

    @VisibleForTesting
    public static void setMockedBroadcaster(AudioRoutingController.MockedBroadcaseter mockedBroadcaster) {
        AudioDeviceInventoryLowerThanM.mockedBroadcaster = mockedBroadcaster;
    }

    public AudioDeviceInventoryLowerThanM(Context context) {
        this.mContext = new WeakReference<Context>(context);
        Logging.i(TAG, "AudioDeviceInventoryLowerThanM ctor!");
    }

    @Override
    public void initialize() {
        Context context = (Context)this.mContext.get();
        Logging.i(TAG, "AudioDeviceInventoryLowerThanM initialize +");
        this.initHeadsetBroadcastReceiver(context);
        this.initBtBroadcastReceiver(context);
    }

    @Override
    public void dispose() {
        try {
            this.clearBTResource();
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    if (mockedBroadcaster != null) {
                        mockedBroadcaster.unRegisterReceiver(this.mHeadsetReceiver);
                    }
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    if (mockedBroadcaster != null) {
                        mockedBroadcaster.unRegisterReceiver(this.mBTHeadsetReceiver);
                    }
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            this.mHeadsetReceiver = null;
            this.mBTHeadsetReceiver = null;
        }
        catch (Exception e) {
            Logging.e(TAG, "AudioRoutingController dispose fail: ", e);
        }
    }

    @Override
    public boolean isDeviceAvaliable(int route) {
        boolean avaliable = false;
        if (route == 5) {
            if (this.mBTAdapter != null && 2 == this.mBTAdapter.getProfileConnectionState(1)) {
                avaliable = true;
            }
        } else if (route == 0 || route == 2) {
            avaliable = this.mHeadsetType == route;
        }
        return avaliable;
    }

    @Override
    public void setAudioDeviceChangeCallback(AudioRoutingController.AudioDeviceChangedCallback cb) {
        this.mAudioDeviceChangedCb = cb;
    }

    protected boolean hasPermission(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    private void initHeadsetBroadcastReceiver(Context context) {
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        if (!this.mHeadsetReceiver.getRegistered()) {
            IntentFilter hs = new IntentFilter("android.intent.action.HEADSET_PLUG");
            Intent intent = context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, hs);
            if (intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.intent.action.HEADSET_PLUG")) {
                this.processHeadsetIntent(intent);
            }
            if (mockedBroadcaster != null) {
                mockedBroadcaster.registerReceiver(this.mHeadsetReceiver, hs);
            }
            this.mHeadsetReceiver.setRegistered(true);
        }
    }

    private void initBtBroadcastReceiver(Context context) {
        if (Build.VERSION.SDK_INT >= 31 && !this.hasPermission(context, PERMISSION_BLUETOOTH_CONNECT) || Build.VERSION.SDK_INT < 31 && !this.hasPermission(context, "android.permission.BLUETOOTH")) {
            Logging.w(TAG, "do not support BT monitoring on this device");
            return;
        }
        this.initBluetoothProfileListener();
        try {
            if (this.mBTHeadsetReceiver == null) {
                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
            }
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBTAdapter == null) {
                Logging.e(TAG, "initialize: failed to get bluetooth adapter!!");
                return;
            }
            this.mBTAdapter.getProfileProxy(context, this.mBTHeadsetListener, 1);
            IntentFilter bt = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            bt.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            if (!this.mBTHeadsetReceiver.getRegistered()) {
                context.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, bt);
                if (mockedBroadcaster != null) {
                    mockedBroadcaster.registerReceiver(this.mBTHeadsetReceiver, bt);
                }
                this.mBTHeadsetReceiver.setRegistered(true);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "unable to create BluetoothHeadsetBroadcastReceiver, err:" + e.getMessage());
        }
    }

    private void initBluetoothProfileListener() {
        try {
            this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                public void onServiceConnected(int profile, BluetoothProfile proxy) {
                    Logging.i(AudioDeviceInventoryLowerThanM.TAG, "onServiceConnected " + profile + " =? headset(" + 1 + ")");
                    if (profile == 1) {
                        Logging.i(AudioDeviceInventoryLowerThanM.TAG, "on BT service connected: " + profile + " " + proxy);
                        AudioDeviceInventoryLowerThanM.this.mBTHeadset = (BluetoothHeadset)proxy;
                    }
                }

                public void onServiceDisconnected(int profile) {
                    Logging.i(AudioDeviceInventoryLowerThanM.TAG, "onServiceDisconnected " + profile + " =? headset(" + 1 + ")");
                    if (profile == 1) {
                        Logging.i(AudioDeviceInventoryLowerThanM.TAG, "on BT service disconnected: " + profile);
                        AudioDeviceInventoryLowerThanM.this.onAudioDeviceEvent(0);
                        AudioDeviceInventoryLowerThanM.this.mBTHeadset = null;
                    }
                }
            };
        }
        catch (Exception e) {
            Logging.e(TAG, "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + e.getMessage());
        }
    }

    private void onAudioDeviceChanged(int route, boolean connect) {
        Logging.i(TAG, "onAudioDeviceChanged route :" + route + " status: " + (connect ? "connect" : "disconnect"));
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceChanged(connect, route);
        }
    }

    private void onAudioDeviceEvent(int devEvt) {
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceEvent(devEvt);
        }
    }

    private int getBtConnectedDevicesSize() {
        if (this.mBTHeadset == null) {
            return 0;
        }
        int size = 0;
        try {
            List devices = this.mBTHeadset.getConnectedDevices();
            for (BluetoothDevice device : devices) {
                Logging.i(TAG, "connected device name: " + device.getName());
            }
            size = devices.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    private void clearBTResource() {
        if (this.mBTAdapter != null) {
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            this.mBTAdapter = null;
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    private boolean processHeadsetIntent(Intent intent) {
        int plugged = intent.getIntExtra("state", -1);
        int microphone = intent.getIntExtra("microphone", -1);
        if (plugged == 1) {
            this.mHeadsetType = microphone == 1 ? 0 : 2;
        }
        return plugged == 1;
    }

    private void processBluetoothIntent(Intent intent) {
        String action = intent.getAction();
        try {
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String deviceName = device != null ? device.getName() : "null name";
                Logging.d(TAG, "BT " + deviceName + " hfp connect state : " + previousState + ", " + state);
                switch (state) {
                    case 2: {
                        Logging.i(TAG, "Bluetooth device " + device + " connected");
                        this.onAudioDeviceChanged(5, true);
                        break;
                    }
                    case 0: {
                        Logging.i(TAG, "Bluetooth device " + device + " disconnected");
                        if (this.getBtConnectedDevicesSize() == 0) {
                            this.onAudioDeviceChanged(5, false);
                            break;
                        }
                        this.onAudioDeviceEvent(1);
                        break;
                    }
                    default: {
                        Logging.i(TAG, device + " unknown event, state=" + state);
                        break;
                    }
                }
            } else if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                Logging.d(TAG, "BluetoothAdapter.ACTION_STATE_CHANGED prev " + previousState + ", " + state);
                switch (state) {
                    case 10: {
                        this.onAudioDeviceChanged(5, false);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "BT broadcast receiver onReceive fail ", e);
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            AudioDeviceInventoryLowerThanM.this.processBluetoothIntent(intent);
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") || !intent.hasExtra("state")) {
                return;
            }
            boolean connect = AudioDeviceInventoryLowerThanM.this.processHeadsetIntent(intent);
            AudioDeviceInventoryLowerThanM.this.onAudioDeviceChanged(AudioDeviceInventoryLowerThanM.this.mHeadsetType, connect);
        }
    }
}

