/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.telephony.CellSignalStrength;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.OrientationEventListener;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ThreadUtils;
import io.agora.rtc2.internal.ConnectionChangeBroadcastReceiver;
import io.agora.rtc2.internal.Connectivity;
import io.agora.rtc2.internal.DeviceUtils;
import io.agora.rtc2.internal.HardwareEarMonitorController;
import io.agora.rtc2.internal.Logging;
import io.agora.rtc2.internal.PowerChangeReceiver;
import io.agora.rtc2.internal.ProcessLifecycleOwner;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class CommonUtility {
    private static final String TAG = "CommonUtility";
    static final int UNKNOWN_BATTERY_PERCENTAGE = 255;
    public static final String PREFIX_URI = "content://";
    public static final String PREFIX_ASSETS = "/assets/";
    private static final String URI_PROTOCOL_HEAD = "/proc/";
    private static final String OFFSET_SEPARATOR_CHARACTER = "agora_offset_&&_";
    private static final String LENGTH_SEPARATOR_CHARACTER = "agora_length_&&_";
    private ConnectivityManager.NetworkCallback mobileNetworkCallback = null;
    private final WeakReference<Context> mContext;
    private long mNativeHandle;
    private final ThreadUtils.ThreadChecker mThreadChecker;
    private final Handler mHandler;
    private volatile int mBatteryPercentage = 255;
    private boolean mDisposed = false;
    private AgoraPhoneStateListener mPhoneStateListener = null;
    private ConnectionChangeBroadcastReceiver mConnectionBroadcastReceiver = null;
    private PowerChangeReceiver mPowerChangeReceiver = null;
    private ProcessLifecycleOwner mProcessLifecycleOwner = null;
    private OrientationEventListener mOrientationListener = null;
    private int mLastOrientation = -1;
    private String mExtraConnectivityFilterActionForTesting;
    private Listener mListener;
    private static boolean ignoreMonitor = false;
    private static boolean failedToGetRunningTasks = false;

    public static void setIgnoreMonitor(boolean ignore) {
        ignoreMonitor = ignore;
    }

    @CalledByNative
    public CommonUtility(Context context, long handle) {
        Logging.d(TAG, "constructor()");
        this.mContext = new WeakReference<Context>(context);
        this.mNativeHandle = handle;
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
        HandlerThread handlerThread = new HandlerThread("UtilityThread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.startMonitor();
            }
        });
    }

    @CalledByNative
    public long getNativeHandle() {
        this.mThreadChecker.checkIsOnValidThread();
        return this.mNativeHandle;
    }

    @CalledByNative
    public static Object getSystemService(Context context, String serviceName) {
        return context.getSystemService(serviceName);
    }

    @VisibleForTesting
    void setExtraConnectionActionForTesting(String action) {
        this.mExtraConnectivityFilterActionForTesting = action;
    }

    @VisibleForTesting
    void setListener(Listener listener) {
        this.mListener = listener;
    }

    @VisibleForTesting
    Handler getHandler() {
        return this.mHandler;
    }

    @VisibleForTesting
    ProcessLifecycleOwner getProcessLifecycleOwner() {
        return this.mProcessLifecycleOwner;
    }

    void startMonitor() {
        Logging.d(TAG, "startMonitor()");
        if (ignoreMonitor) {
            Logging.e(TAG, "ignoreMonitor in simulator, just for ut");
            return;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        try {
            this.mPhoneStateListener = new AgoraPhoneStateListener(this, this.mHandler);
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 288);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create PhoneStateListener, ", e);
        }
        try {
            this.mConnectionBroadcastReceiver = new ConnectionChangeBroadcastReceiver(this);
            context.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            if (!TextUtils.isEmpty((CharSequence)this.mExtraConnectivityFilterActionForTesting)) {
                context.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter(this.mExtraConnectivityFilterActionForTesting));
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create ConnectionChangeBroadcastReceiver, ", e);
        }
        try {
            this.mPowerChangeReceiver = new PowerChangeReceiver(this);
            IntentFilter iFilter = new IntentFilter();
            iFilter.addAction("android.intent.action.BATTERY_CHANGED");
            context.registerReceiver((BroadcastReceiver)this.mPowerChangeReceiver, iFilter);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create PowerChangeReceiver, ", e);
        }
        try {
            this.mProcessLifecycleOwner = new ProcessLifecycleOwner(CommonUtility.isAppInForeground(), this);
            Application app = (Application)context.getApplicationContext();
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mProcessLifecycleOwner);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to registerActivityLifecycleCallbacks, ", e);
        }
    }

    private void stopMonitor() {
        Logging.d(TAG, "stopMonitor()");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        try {
            if (this.mPhoneStateListener != null) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 0);
                this.mPhoneStateListener = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mConnectionBroadcastReceiver != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver);
                this.mConnectionBroadcastReceiver = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mPowerChangeReceiver != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mPowerChangeReceiver);
                this.mPowerChangeReceiver = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mProcessLifecycleOwner != null) {
                Application app = (Application)context.getApplicationContext();
                app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mProcessLifecycleOwner);
                this.mProcessLifecycleOwner = null;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "unregister ProcessLifecycleOwner failed ", e);
        }
        this.closeGravityMonitor();
    }

    @CalledByNative
    public void dispose() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mDisposed) {
            return;
        }
        HardwareEarMonitorController.destroy();
        this.mDisposed = true;
        this.mNativeHandle = 0L;
        Logging.d(TAG, "dispose()");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CommonUtility.this.stopMonitor();
            }
        });
        final CountDownLatch waitingLatch = new CountDownLatch(1);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                waitingLatch.countDown();
                CommonUtility.this.mHandler.getLooper().quit();
            }
        });
        try {
            waitingLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.mListener != null) {
            this.mListener.onDispose();
        }
    }

    @CalledByNative
    public int getNetworkType() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        if (CommonUtility.checkAccessNetworkState(context)) {
            return Connectivity.getNetworkType(context);
        }
        Logging.w(TAG, "fail to getNetworkType, permission ACCESS_NETWORK_STATE not granted");
        return -1;
    }

    @CalledByNative
    public int getBatteryLifePercent() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return this.mBatteryPercentage;
        }
        return 255;
    }

    @CalledByNative
    public MediaNetworkInfo getNetworkInfo() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return this.getNetworkInfo(context);
        }
        return null;
    }

    @CalledByNative
    public String getRealFilePath(Context context, String url) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            Logging.e("getRealFilePath failed for init error");
            return "";
        }
        String realPath = null;
        if (url.startsWith(PREFIX_ASSETS)) {
            realPath = CommonUtility.getAssetsFilePath(context, url);
        } else if (url.startsWith(PREFIX_URI)) {
            Uri uri = Uri.parse((String)url);
            realPath = CommonUtility.getContentFilePath(context, uri);
        }
        return realPath != null ? realPath : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFilePath(Context context, Uri uri) {
        if (context == null || uri == null) {
            Logging.e("getContentFilePath failed for init error");
            return null;
        }
        ContentResolver resolver = context.getContentResolver();
        AssetFileDescriptor fileDescriptor = null;
        int realFd = -1;
        Object pfd = null;
        try {
            fileDescriptor = resolver.openAssetFileDescriptor(uri, "r");
            realFd = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor.getFileDescriptor()).getFd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (realFd < 0) {
            return null;
        }
        String realPath = URI_PROTOCOL_HEAD + Process.myPid() + "/fd/" + realFd;
        Logging.i("getContentFilePath is: " + realPath);
        return realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssetsFilePath(Context context, String url) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            Logging.e("getAssetsFilePath failed for init error");
            return null;
        }
        AssetManager manager = context.getAssets();
        AssetFileDescriptor fileDescriptor = null;
        String assetsFileName = url.substring(url.indexOf(PREFIX_ASSETS) + PREFIX_ASSETS.length());
        String realPath = null;
        try {
            fileDescriptor = manager.openFd(assetsFileName);
            int readFd = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor.getFileDescriptor()).getFd();
            if (readFd < 0) {
                String string = null;
                return string;
            }
            realPath = PREFIX_ASSETS + readFd + OFFSET_SEPARATOR_CHARACTER + fileDescriptor.getStartOffset() + LENGTH_SEPARATOR_CHARACTER + fileDescriptor.getDeclaredLength();
            Logging.i("getAssetsFilePath for init offset:" + fileDescriptor.getStartOffset() + "," + fileDescriptor.getDeclaredLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Logging.i("getAssetsFilePath is: " + realPath);
        return realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public String getAssetsCacheFile(Context context, String pathOrUri, String fileName) {
        Logging.i(TAG, "getAssetsCacheFile filePath: " + pathOrUri);
        boolean isUri = pathOrUri.startsWith(PREFIX_URI);
        File cacheFile = new File(context.getCacheDir(), fileName);
        try {
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int len;
            inputStream = isUri ? new FileInputStream(context.getContentResolver().openFileDescriptor(Uri.parse((String)pathOrUri), "r").getFileDescriptor()) : context.getAssets().open(pathOrUri);
            outputStream = new FileOutputStream(cacheFile);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cacheFile.getAbsolutePath();
    }

    void onAudioRoutingPhoneChanged(boolean enableAudio, int event, int arg) {
        if (this.mDisposed || this.mNativeHandle == 0L) {
            return;
        }
        Logging.d(TAG, "onAudioRoutingPhoneChanged() enableAudio:" + enableAudio + ", event:" + event + ", arg: " + arg);
        this.nativeAudioRoutingPhoneChanged(enableAudio, event, arg);
        if (this.mListener != null) {
            this.mListener.onAudioRoutingPhoneChanged(enableAudio, event, arg);
        }
    }

    void onNetworkChange() {
        if (this.mDisposed || this.mNativeHandle == 0L) {
            return;
        }
        Logging.d(TAG, "onNetworkChange()");
        MediaNetworkInfo info = this.getNetworkInfo((Context)this.mContext.get());
        this.nativeNotifyNetworkChange(info);
        if (this.mListener != null) {
            this.mListener.onNetworkChange(info);
        }
    }

    void onForegroundChanged(boolean foreground) {
        Log.d((String)TAG, (String)("onForegroundChanged() " + foreground));
        if (this.mDisposed) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onForegroundChanged(foreground);
        }
        if (this.mNativeHandle != 0L) {
            this.nativeNotifyForegroundChanged(foreground);
        }
    }

    void onPowerChange(int batteryPercentage) {
        Logging.d(TAG, "onPowerChange() " + batteryPercentage);
        this.mBatteryPercentage = batteryPercentage;
    }

    @CalledByNative
    public static boolean isSimulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    @CalledByNative
    public static int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    @CalledByNative
    public static int isSpeakerphoneEnabled(Context context) {
        if (context == null) {
            Logging.w(TAG, "fail to isSpeakerphoneEnabled, context null");
            return -1;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isSpeakerphoneOn() ? 1 : 0;
    }

    public void notifyAddressBound(String addr) {
        this.nativeNotifyAddressBound(addr);
    }

    @CalledByNative
    public void bindSocket2Network(int socketfd, String address) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        final ConnectivityManager connectivityManager = (ConnectivityManager)((Context)this.mContext.get()).getSystemService("connectivity");
        NetworkRequest requestForCellular = new NetworkRequest.Builder().addTransportType(0).build();
        final int socketFdInner = socketfd;
        final String addressInner = address.toString();
        final CommonUtility comm = this;
        if (this.mobileNetworkCallback != null) {
            connectivityManager.unregisterNetworkCallback(this.mobileNetworkCallback);
        }
        this.mobileNetworkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                LinkProperties prop = connectivityManager.getLinkProperties(network);
                InetAddress addr = ((LinkAddress)prop.getLinkAddresses().get(0)).getAddress();
                String ip = CommonUtility.inetAddressToIpAddress(addr);
                if (ip != null && ip.equals(addressInner)) {
                    Logging.d("start bindSocket2Network");
                    Logging.d("addressInner" + addressInner);
                    FileDescriptor fileDescriptor = new FileDescriptor();
                    try {
                        Field field = FileDescriptor.class.getDeclaredField("descriptor");
                        field.setAccessible(true);
                        field.setInt(fileDescriptor, socketFdInner);
                        network.bindSocket(fileDescriptor);
                        comm.notifyAddressBound(addressInner);
                        Logging.d("bindSocket2Network success: network" + network + "+socketfd" + socketFdInner);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            connectivityManager.requestNetwork(requestForCellular, this.mobileNetworkCallback);
        }
        catch (Exception e) {
            this.mobileNetworkCallback = null;
            Logging.e(TAG, "requestNetwork failed " + e.toString());
        }
    }

    @CalledByNative
    public static AndroidContextInfo getContextInfo(Context context) {
        if (context == null) {
            Logging.w(TAG, "fail to getContextInfo, context null");
            return null;
        }
        AndroidContextInfo info = new AndroidContextInfo();
        info.device = DeviceUtils.getDeviceId();
        info.configDir = CommonUtility.getAppPrivateStorageDir(context);
        info.dataDir = context.getCacheDir().getAbsolutePath();
        info.pluginDir = context.getApplicationInfo().nativeLibraryDir;
        info.deviceInfo = DeviceUtils.getDeviceInfo();
        info.systemInfo = DeviceUtils.getSystemInfo();
        info.manufacturer = DeviceUtils.getManufacturer();
        info.pkgName = context.getPackageName();
        return info;
    }

    @CalledByNative
    public static String[] getLocalHostList() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> ips = new ArrayList<String>();
            for (NetworkInterface intf : interfaces) {
                String interfaceName = intf.getName();
                if (interfaceName.startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr);
                    if (TextUtils.isEmpty((CharSequence)ip)) continue;
                    ips.add(ip + "+" + interfaceName);
                }
            }
            if (!ips.isEmpty()) {
                String[] addresses = new String[ips.size()];
                int i = 0;
                Iterator iterator = ips.iterator();
                while (iterator.hasNext()) {
                    String ip;
                    addresses[i] = ip = (String)iterator.next();
                    ++i;
                }
                return addresses;
            }
        }
        catch (Exception ex) {
            Logging.w(TAG, "fail to getLocalHostList", ex);
        }
        return null;
    }

    @CalledByNative
    public int VPNBehindAddress() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return 1;
        }
        return Connectivity.VPNBehindAddress(context);
    }

    @CalledByNative
    public static String getLocalHost(boolean is_ipv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            StringBuilder first_local_ip = new StringBuilder();
            String public_ip = null;
            for (NetworkInterface inter : interfaces) {
                if (inter.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addresses = Collections.list(inter.getInetAddresses());
                for (InetAddress addr : addresses) {
                    public_ip = CommonUtility.getIpAddressByType(addr, is_ipv4, first_local_ip);
                    if (TextUtils.isEmpty((CharSequence)public_ip)) continue;
                    return public_ip;
                }
            }
            if (first_local_ip.length() > 0) {
                return first_local_ip.toString();
            }
        }
        catch (Exception ex) {
            Logging.w(TAG, "fail to getLocalHost", ex);
        }
        return null;
    }

    private static String getIpAddressByType(InetAddress addr, boolean is_ipv4, StringBuilder first_local_ip) {
        if (is_ipv4 && addr instanceof Inet4Address) {
            String public_ip4 = CommonUtility.getPublicIpAddress(addr);
            if (!TextUtils.isEmpty((CharSequence)public_ip4) && first_local_ip.length() == 0) {
                first_local_ip.append(public_ip4);
            }
            return public_ip4;
        }
        if (!is_ipv4 && addr instanceof Inet6Address) {
            String public_ip6 = CommonUtility.getPublicIpAddress(addr);
            if (!TextUtils.isEmpty((CharSequence)public_ip6) && first_local_ip.length() == 0) {
                first_local_ip.append(public_ip6);
            }
            return public_ip6;
        }
        return null;
    }

    private static String getPublicIpAddress(InetAddress address) {
        if (!(address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isAnyLocalAddress())) {
            return address.getHostAddress();
        }
        return null;
    }

    public int checkOrientation(int orientation) {
        if (orientation == -1) {
            return -1;
        }
        if ((orientation > 340 || orientation < 20) && this.mLastOrientation != 270) {
            this.mLastOrientation = 270;
            this.nativeNotifyGravityOriChange(270);
        } else if (orientation > 70 && orientation < 110 && this.mLastOrientation != 180) {
            this.mLastOrientation = 180;
            this.nativeNotifyGravityOriChange(180);
        } else if (orientation > 160 && orientation < 200 && this.mLastOrientation != 90) {
            this.mLastOrientation = 90;
            this.nativeNotifyGravityOriChange(90);
        } else if (orientation > 250 && orientation < 290 && this.mLastOrientation != 0) {
            this.mLastOrientation = 0;
            this.nativeNotifyGravityOriChange(0);
        }
        return this.mLastOrientation;
    }

    @CalledByNative
    public int setupGravityMonitor() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        try {
            if (this.mOrientationListener == null) {
                this.mOrientationListener = new OrientationEventListener(context, 2){

                    public void onOrientationChanged(int orientation) {
                        if (orientation == -1) {
                            return;
                        }
                        CommonUtility.this.checkOrientation(orientation);
                    }
                };
            }
            this.mOrientationListener.enable();
            Logging.i(TAG, "[setupGravityMonitor] done!");
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create OrientationEventListener, ", e);
        }
        return -1;
    }

    @CalledByNative
    public int closeGravityMonitor() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        try {
            if (this.mOrientationListener != null) {
                this.mOrientationListener.disable();
                this.mOrientationListener = null;
                Logging.i(TAG, "[closeGravityMonitor] done!");
                return 0;
            }
            Logging.e(TAG, "[closeGravityMonitor] mOrientationListener is null!");
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to close OrientationEventListener, ", e);
        }
        return -1;
    }

    static boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        return res == 0;
    }

    static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE");
        return res == 0;
    }

    private MediaNetworkInfo getNetworkInfo(Context context) {
        String localIp6;
        MediaNetworkInfo ni = new MediaNetworkInfo();
        if (!CommonUtility.checkAccessNetworkState(context)) {
            Logging.w(TAG, "fail to getNetworkInfo, permission ACCESS_NETWORK_STATE not granted");
            return ni;
        }
        String localIp4 = CommonUtility.getLocalHost(true);
        if (!TextUtils.isEmpty((CharSequence)localIp4)) {
            ni.localIp4 = localIp4;
        }
        if (!TextUtils.isEmpty((CharSequence)(localIp6 = CommonUtility.getLocalHost(false)))) {
            ni.localIp6 = localIp6;
        }
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        ni.networkType = Connectivity.getNetworkType(networkInfo);
        if (networkInfo != null) {
            ni.networkSubtype = networkInfo.getSubtype();
        }
        ni.dnsList = Connectivity.getDnsList();
        if (ni.networkType == 2) {
            CommonUtility.fillWifiInfoIfPossible(context, ni);
            Logging.d(TAG, "networkType from WIFI, rssi = " + ni.rssi + " level = " + ni.signalLevel);
        } else if (this.mPhoneStateListener != null) {
            this.mPhoneStateListener.fillCellInfoIfPossible(context, ni);
            Logging.d(TAG, "networkType from Phone State Listener\uff0c rssi = " + ni.rssi + " level = " + ni.signalLevel);
        }
        ni.ifconfigs = this.getVpnIfconfigs();
        return ni;
    }

    public ArrayList<String> getVpnIfconfigs() {
        ArrayList<String> ifconfigs = new ArrayList<String>();
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                String name = nif.getName();
                if (!name.contains("tun") && !name.contains("ppp") && !name.contains("ipsec") && !name.contains("tap")) continue;
                ifconfigs.add(name);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Fail to get network interfaces array list. ", e);
        }
        return ifconfigs;
    }

    private static String inetAddressToIpAddress(InetAddress address) {
        if (!address.isLoopbackAddress()) {
            if (address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (address instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    private static InetAddress intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static void fillWifiInfoIfPossible(Context context, MediaNetworkInfo ni) {
        WifiInfo wifiInfo;
        InetAddress addr;
        if (!CommonUtility.checkAccessWifiState(context)) {
            Logging.w(TAG, "fail to fillWifiInfo, permission ACCESS_WIFI_STATE not granted");
            return;
        }
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        DhcpInfo dhcp = wifiManager.getDhcpInfo();
        if (dhcp != null && (addr = CommonUtility.intToInetAddress(dhcp.gateway)) != null) {
            ni.gatewayIp4 = addr.getHostAddress();
        }
        if ((wifiInfo = wifiManager.getConnectionInfo()) != null) {
            ni.rssi = wifiInfo.getRssi();
            ni.signalLevel = WifiManager.calculateSignalLevel((int)ni.rssi, (int)5);
            ni.linkspeed = wifiInfo.getLinkSpeed();
            if (Build.VERSION.SDK_INT >= 21) {
                int freq;
                ni.frequency = freq = wifiInfo.getFrequency();
                if (freq >= 5000) {
                    ni.networkSubtype = 101;
                } else if (freq >= 2400) {
                    ni.networkSubtype = 100;
                }
            }
        } else {
            Logging.w(TAG, "fail to fillWifiInfo, wifiInfo null");
        }
    }

    private static String getAppPrivateStorageDir(Context context) {
        File file;
        if ("mounted".equals(Environment.getExternalStorageState()) && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    @CalledByNative
    public static boolean isAppInForeground() {
        ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
        return appProcessInfo.importance == 100 || appProcessInfo.importance == 200;
    }

    @CalledByNative
    public static int getCpuTemperature() {
        return DeviceUtils.getCpuTemperature();
    }

    @CalledByNative
    public static int safeLoadLibrary(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return -2;
        }
        int loaded = 0;
        try {
            System.loadLibrary(path);
        }
        catch (SecurityException e) {
            loaded = -1;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = -1;
        }
        catch (NullPointerException e) {
            loaded = -1;
        }
        catch (Exception e) {
            loaded = -1;
        }
        if (loaded != 0) {
            Log.i((String)TAG, (String)("failed to load library: " + path));
        }
        return loaded;
    }

    private native void nativeAudioRoutingPhoneChanged(boolean var1, int var2, int var3);

    private native void nativeNotifyNetworkChange(MediaNetworkInfo var1);

    private native void nativeNotifyForegroundChanged(boolean var1);

    private native void nativeNotifyGravityOriChange(int var1);

    private native void nativeNotifyAddressBound(String var1);

    static interface Listener {
        public void onAudioRoutingPhoneChanged(boolean var1, int var2, int var3);

        public void onNetworkChange(MediaNetworkInfo var1);

        public void onDispose();

        public void onForegroundChanged(boolean var1);
    }

    public static class AndroidContextInfo {
        public String device;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String deviceInfo;
        public String systemInfo;
        public String manufacturer;
        public String pkgName;

        @CalledByNative(value="AndroidContextInfo")
        public String getDevice() {
            return this.device;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getConfigDir() {
            return this.configDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getDataDir() {
            return this.dataDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getPluginDir() {
            return this.pluginDir;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getDeviceInfo() {
            return this.deviceInfo;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getSystemInfo() {
            return this.systemInfo;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getManufacturer() {
            return this.manufacturer;
        }

        @CalledByNative(value="AndroidContextInfo")
        public String getPkgName() {
            return this.pkgName;
        }
    }

    public static class MediaNetworkInfo {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType = -1;
        int networkSubtype = -1;
        int signalLevel = 0;
        int rssi = 0;
        int snr = -100;
        ArrayList<String> dnsList = null;
        int linkspeed = 0;
        int frequency = 0;
        ArrayList<String> ifconfigs = null;

        @CalledByNative(value="MediaNetworkInfo")
        public String getLocalIp4() {
            return this.localIp4;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getGatewayIp4() {
            return this.gatewayIp4;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getLocalIp6() {
            return this.localIp6;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public String getGatewayIp6() {
            return this.gatewayIp6;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getNetworkType() {
            return this.networkType;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getNetworkSubtype() {
            return this.networkSubtype;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getSignalLevel() {
            return this.signalLevel;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getRssi() {
            return this.rssi;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getAsu() {
            return this.snr;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public ArrayList<String> getDnsList() {
            return this.dnsList;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getLinkspeed() {
            return this.linkspeed;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public int getFrequency() {
            return this.frequency;
        }

        @CalledByNative(value="MediaNetworkInfo")
        public ArrayList<String> getVpnIfconfigs() {
            return this.ifconfigs;
        }
    }

    static class AgoraPhoneStateListener
    extends PhoneStateListener {
        private final WeakReference<CommonUtility> mCommonUtilityRef;
        private final WeakReference<Handler> mHandlerRef;
        private SignalStrength mSignalStrength;
        private volatile boolean phoneStatusNeedResume = false;

        AgoraPhoneStateListener(CommonUtility commonUtility, Handler handler) {
            this.mCommonUtilityRef = new WeakReference<CommonUtility>(commonUtility);
            this.mHandlerRef = new WeakReference<Handler>(handler);
        }

        @RequiresApi(value=26)
        void fillCellInfoHighLevel(@NonNull MediaNetworkInfo cellInfo) {
            if (this.mSignalStrength != null) {
                try {
                    Method method = this.mSignalStrength.getClass().getDeclaredMethod("getCellSignalStrengths", new Class[0]);
                    if (method != null) {
                        List signalList = (List)method.invoke((Object)this.mSignalStrength, new Object[0]);
                        this.fillCellInfoByNetworkType(signalList, cellInfo);
                    }
                }
                catch (Exception e) {
                    Logging.e(CommonUtility.TAG, "fillCellInfoHighLevel getDeclareMethod:getCellSignalStrengths failed! ");
                    this.fillCellInfoLowLevel(cellInfo);
                }
            }
        }

        @RequiresApi(value=26)
        void fillCellInfoByNetworkType(@NonNull List<CellSignalStrength> cellInfoList, @NonNull MediaNetworkInfo cellInfo) {
            for (CellSignalStrength cellSignal : cellInfoList) {
                if (cellSignal instanceof CellSignalStrengthLte) {
                    CellSignalStrengthLte signalStrength = (CellSignalStrengthLte)cellSignal;
                    cellInfo.rssi = signalStrength.getDbm();
                    cellInfo.signalLevel = signalStrength.getLevel();
                    cellInfo.snr = signalStrength.getRssnr();
                    break;
                }
                if (!(cellSignal instanceof CellSignalStrengthGsm) && !(cellSignal instanceof CellSignalStrengthCdma) && !(cellSignal instanceof CellSignalStrengthWcdma)) continue;
                cellInfo.rssi = cellSignal.getDbm();
                cellInfo.signalLevel = cellSignal.getLevel();
                break;
            }
        }

        void fillCellInfoLowLevel(@NonNull MediaNetworkInfo cellInfo) {
            cellInfo.rssi = this.getRssi();
            cellInfo.signalLevel = this.getLevel();
        }

        public void fillCellInfoIfPossible(Context context, MediaNetworkInfo cellInfo) {
            if (Build.VERSION.SDK_INT <= 28) {
                this.fillCellInfoLowLevel(cellInfo);
            } else {
                this.fillCellInfoHighLevel(cellInfo);
            }
        }

        public int getRssi() {
            return this.invokeMethod("getDbm");
        }

        public int getLevel() {
            return this.invokeMethod("getLevel");
        }

        public int getAsuLevel() {
            return this.invokeMethod("getAsuLevel");
        }

        private int invokeMethod(String methodName) {
            try {
                if (this.mSignalStrength != null) {
                    Method method = this.mSignalStrength.getClass().getDeclaredMethod(methodName, new Class[0]);
                    return (Integer)method.invoke((Object)this.mSignalStrength, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            this.mSignalStrength = signalStrength;
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            final CommonUtility utility = (CommonUtility)this.mCommonUtilityRef.get();
            Handler handler = (Handler)this.mHandlerRef.get();
            if (utility == null || handler == null) {
                return;
            }
            if (state == 0) {
                if (this.phoneStatusNeedResume) {
                    this.phoneStatusNeedResume = false;
                    Logging.i(CommonUtility.TAG, "system phone call end delay 1000ms");
                    handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            utility.onAudioRoutingPhoneChanged(true, 22, 0);
                        }
                    }, 1000L);
                }
            } else if (state == 1) {
                Logging.i(CommonUtility.TAG, "system phone call ring");
                this.phoneStatusNeedResume = true;
                utility.onAudioRoutingPhoneChanged(false, 22, 1);
            } else if (state == 2) {
                Logging.i(CommonUtility.TAG, "system phone call start");
                this.phoneStatusNeedResume = true;
                utility.onAudioRoutingPhoneChanged(false, 22, 2);
            }
        }
    }
}

