/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.content.Intent;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.rtc2.video.IVideoCapture;
import io.agora.rtc2.video.IVideoCaptureCamera;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureCamera1;
import io.agora.rtc2.video.VideoCaptureCamera2;
import io.agora.rtc2.video.VideoCaptureCameraFallbackWrapper;
import io.agora.rtc2.video.VideoCaptureFormat;
import io.agora.rtc2.video.VideoCaptureScreen;
import java.util.Arrays;
import java.util.List;

class VideoCaptureFactory {
    private static final String TAG = "VideoCaptureFactory";
    private static final List<String> TEXTURE_EXCEPTION_MODELS = Arrays.asList("LG-H848", "Pixel 4a", "SM-A7000", "MI MAX");

    VideoCaptureFactory() {
    }

    private static boolean isLReleaseOrLater() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @CalledByNative
    static boolean isLegacyOrDeprecatedDevice(int index) {
        return !VideoCaptureFactory.isLReleaseOrLater() || VideoCaptureCamera2.isLegacyDevice(index) || VideoCaptureFactory.isInCamera2BlackList();
    }

    static boolean isLessSelectedLevel(int index, int selectedLevel) {
        int supportedLevel = VideoCaptureCamera2.getCamera2SupportedLevel(index);
        if (supportedLevel != Integer.MIN_VALUE) {
            return VideoCaptureCamera2.ANDROID_CAMERA_HARDWARE_LEVEL_MAP.get(supportedLevel) <= VideoCaptureCamera2.ANDROID_CAMERA_HARDWARE_LEVEL_MAP.get(selectedLevel, 1);
        }
        return true;
    }

    @CalledByNative
    static IVideoCapture createCameraCapture(int index, long nativeVideoCaptureDeviceAndroid, boolean captureToTexture, boolean pqFirst, EglBase.Context sharedContext, int camera_selected, int cameraSelectedLevel) {
        Logging.w(TAG, "createVideoCapture() " + index + ", captureToTexture: " + captureToTexture + ", camera_selected: " + camera_selected + ", camera_selected_level: " + cameraSelectedLevel + ", pqFirst: " + pqFirst);
        if (TEXTURE_EXCEPTION_MODELS.contains(Build.MODEL)) {
            Logging.w(TAG, "Not support for " + Build.MODEL);
            captureToTexture = false;
        }
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index) || 0 == camera_selected || VideoCaptureFactory.isLessSelectedLevel(index, cameraSelectedLevel)) {
            return new VideoCaptureCamera1(index, nativeVideoCaptureDeviceAndroid, captureToTexture, pqFirst, sharedContext);
        }
        VideoCaptureCamera2 capturer = new VideoCaptureCamera2(index, nativeVideoCaptureDeviceAndroid, captureToTexture, pqFirst, sharedContext);
        return VideoCaptureFactory.createFallbackWrapper(capturer, index, nativeVideoCaptureDeviceAndroid, captureToTexture, pqFirst, sharedContext);
    }

    static IVideoCaptureCamera createFallbackWrapper(IVideoCaptureCamera camera, final int index, final long nativeVideoCaptureDeviceAndroid, final boolean captureToTexture, final boolean pqFirst, final EglBase.Context sharedContext) {
        return new VideoCaptureCameraFallbackWrapper(camera, new VideoCaptureCameraFallbackWrapper.OnCameraFallbackListener(){

            @Override
            public IVideoCaptureCamera createFallbackCamera() {
                return new VideoCaptureCamera1(index, nativeVideoCaptureDeviceAndroid, captureToTexture, pqFirst, sharedContext);
            }
        });
    }

    @CalledByNative
    static VideoCapture createScreenCapture(long nativeVideoCaptureDeviceAndroid, EglBase.Context sharedContext, Intent mediaProjectionPermissionResultData) {
        return new VideoCaptureScreen(nativeVideoCaptureDeviceAndroid, sharedContext, mediaProjectionPermissionResultData);
    }

    @CalledByNative
    static int getNumberOfCameras() {
        return ChromiumCameraInfo.getNumberOfCameras();
    }

    @CalledByNative
    static int getCaptureApiType(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getCaptureApiType(index);
        }
        return VideoCaptureCamera2.getCaptureApiType(index);
    }

    @CalledByNative
    static int getFacingMode(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getFacingMode(index);
        }
        return VideoCaptureCamera2.getFacingMode(index);
    }

    @Nullable
    @CalledByNative
    static String getDeviceId(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getDeviceId(index);
        }
        return VideoCaptureCamera2.getDeviceId(index);
    }

    @Nullable
    @CalledByNative
    static String getDeviceName(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getName(index);
        }
        return VideoCaptureCamera2.getName(index);
    }

    @Nullable
    @CalledByNative
    static List<VideoCaptureFormat> getDeviceSupportedFormats(int index) {
        if (VideoCaptureFactory.isLegacyOrDeprecatedDevice(index)) {
            return VideoCaptureCamera1.getDeviceSupportedFormats(index);
        }
        return VideoCaptureCamera2.getDeviceSupportedFormats(index);
    }

    static boolean isInCamera2BlackList() {
        if ("ocean".equalsIgnoreCase(Build.DEVICE) && "oe106".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        if ("trident".equalsIgnoreCase(Build.DEVICE) && "de106".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        if ("shark".equalsIgnoreCase(Build.DEVICE) && "skr-a0".equalsIgnoreCase(Build.MODEL)) {
            return true;
        }
        if ("hnnem-h".equalsIgnoreCase(Build.DEVICE)) {
            return true;
        }
        if ("on7xelte".equals(Build.DEVICE) && "SM-G610F".equals(Build.MODEL)) {
            return true;
        }
        if ("m2c".equals(Build.DEVICE) || "M578CA".equals(Build.MODEL)) {
            return true;
        }
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && (Build.MODEL.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || "SC-02H".equals(Build.MODEL) || "SCV33".equals(Build.MODEL) || "SC-02J".equals(Build.MODEL) || "SCV36".equals(Build.MODEL) || "SM-G892A".equals(Build.MODEL) || "SM-G892U".equals(Build.MODEL) || "SC-03J".equals(Build.MODEL) || "SCV35".equals(Build.MODEL))) {
            return true;
        }
        if ("oneplus".equalsIgnoreCase(Build.MANUFACTURER)) {
            return true;
        }
        return "PCAM00".equalsIgnoreCase(Build.MODEL);
    }

    static @interface CAMERA_MODULE_SELECTED {
        public static final int ANDROID_CAMERA_AUTO = -1;
        public static final int ANDROID_CAMERA1 = 0;
        public static final int ANDROID_CAMERA2 = 1;
    }

    static class ChromiumCameraInfo {
        private static int sNumberOfSystemCameras = -1;

        ChromiumCameraInfo() {
        }

        private static int getNumberOfCameras() {
            if (sNumberOfSystemCameras == -1) {
                if (Build.VERSION.SDK_INT < 23 && ContextUtils.getApplicationContext().getPackageManager().checkPermission("android.permission.CAMERA", ContextUtils.getApplicationContext().getPackageName()) != 0) {
                    sNumberOfSystemCameras = 0;
                    Logging.w(VideoCaptureFactory.TAG, "Missing android.permission.CAMERA permission, no system camera available.");
                } else {
                    sNumberOfSystemCameras = VideoCaptureFactory.isLReleaseOrLater() ? VideoCaptureCamera2.getNumberOfCameras() : VideoCaptureCamera1.getNumberOfCameras();
                }
            }
            return sNumberOfSystemCameras;
        }
    }
}

