/*
 * Decompiled with CFR 0.152.
 */
package io.agora.spatialaudio.internal;

import io.agora.rtc2.RtcConnection;
import io.agora.spatialaudio.ILocalSpatialAudioEngine;
import io.agora.spatialaudio.LocalSpatialAudioConfig;
import io.agora.spatialaudio.RemoteVoicePositionInfo;
import io.agora.spatialaudio.SpatialAudioZone;
import java.util.Locale;

public class LocalSpatialAudioImpl
extends ILocalSpatialAudioEngine {
    private static final String TAG = LocalSpatialAudioImpl.class.getSimpleName();
    private long mNativeHandle = 0L;

    static String getChannelId(RtcConnection connection) {
        return connection != null ? connection.channelId : null;
    }

    static int getUserId(RtcConnection connection) {
        return connection != null ? connection.localUid : 0;
    }

    @Override
    public int initialize(LocalSpatialAudioConfig config) {
        if (config.mRtcEngine == null) {
            return -2;
        }
        this.mNativeHandle = this.nativeObjectInit(config, config.mRtcEngine.getNativeHandle());
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return 0;
    }

    @Override
    protected int release() {
        if (this.mNativeHandle != 0L) {
            LocalSpatialAudioImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        return 0;
    }

    @Override
    public int setMaxAudioRecvCount(int maxCount) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.max_hear_count\":%d}", maxCount));
    }

    @Override
    public int setAudioRecvRange(float range) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.hear_range\":%f}", Float.valueOf(range)));
    }

    @Override
    public int setDistanceUnit(float unit) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.distance_unit\":%f}", Float.valueOf(unit)));
    }

    @Override
    public int updatePlayerPositionInfo(int playerId, RemoteVoicePositionInfo positionInfo) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (positionInfo == null || positionInfo.position == null || positionInfo.position.length != 3 || positionInfo.forward != null && positionInfo.forward.length != 3) {
            return -2;
        }
        return this.nativeUpdatePlayerPositionInfo(this.mNativeHandle, playerId, positionInfo);
    }

    @Override
    public int updateSelfPosition(float[] position, float[] axisForward, float[] axisRight, float[] axisUp) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (position.length != 3 || axisForward.length != 3 || axisRight.length != 3 || axisUp.length != 3) {
            return -2;
        }
        return this.nativeUpdateSelfPosition(this.mNativeHandle, position, axisForward, axisRight, axisUp);
    }

    @Override
    public int updateSelfPositionEx(float[] position, float[] axisForward, float[] axisRight, float[] axisUp, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (position.length != 3 || axisForward.length != 3 || axisRight.length != 3 || axisUp.length != 3) {
            return -2;
        }
        return this.nativeUpdateSelfPositionEx(this.mNativeHandle, position, axisForward, axisRight, axisUp, LocalSpatialAudioImpl.getChannelId(connection), LocalSpatialAudioImpl.getUserId(connection));
    }

    @Override
    public int muteLocalAudioStream(boolean mute) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.mute_local_stream\":%s}", mute ? "true" : "false"));
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean mute) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetParameters(this.mNativeHandle, String.format(Locale.US, "{\"rtc.local_spatial_audio.mute_all_remote_audio_streams\":%s}", mute ? "true" : "false"));
    }

    @Override
    public int updateRemotePosition(int uid, RemoteVoicePositionInfo posInfo) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (posInfo == null || posInfo.position == null || posInfo.position.length != 3) {
            return -2;
        }
        if (posInfo.forward == null) {
            posInfo.forward = new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.nativeUpdateRemotePosition(this.mNativeHandle, uid, posInfo.position, posInfo.forward);
    }

    @Override
    public int updateRemotePositionEx(int uid, RemoteVoicePositionInfo posInfo, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (posInfo == null || posInfo.position == null || posInfo.position.length != 3) {
            return -2;
        }
        if (posInfo.forward == null) {
            posInfo.forward = new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.nativeUpdateRemotePositionEx(this.mNativeHandle, uid, posInfo.position, posInfo.forward, LocalSpatialAudioImpl.getChannelId(connection), LocalSpatialAudioImpl.getUserId(connection));
    }

    @Override
    public int removeRemotePosition(int uid) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveRemotePosition(this.mNativeHandle, uid);
    }

    @Override
    public int removeRemotePositionEx(int uid, RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveRemotePositionEx(this.mNativeHandle, uid, LocalSpatialAudioImpl.getChannelId(connection), LocalSpatialAudioImpl.getUserId(connection));
    }

    @Override
    public int clearRemotePositions() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeClearRemotePositions(this.mNativeHandle);
    }

    @Override
    public int clearRemotePositionsEx(RtcConnection connection) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeClearRemotePositionsEx(this.mNativeHandle, LocalSpatialAudioImpl.getChannelId(connection), LocalSpatialAudioImpl.getUserId(connection));
    }

    @Override
    public int setZones(SpatialAudioZone[] zones) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        if (zones == null || zones.length <= 0) {
            return -2;
        }
        for (int a = 0; a < zones.length; ++a) {
            if (zones[a] == null) {
                return -2;
            }
            if (zones[a].position == null || zones[a].position.length != 3) {
                return -2;
            }
            if (zones[a].forward == null || zones[a].forward.length != 3) {
                return -2;
            }
            if (zones[a].right == null || zones[a].right.length != 3) {
                return -2;
            }
            if (zones[a].up != null && zones[a].up.length == 3) continue;
            return -2;
        }
        return this.nativeSetZones(this.mNativeHandle, zones);
    }

    @Override
    public int setPlayerAttenuation(int playerId, double attenuation, boolean forceSet) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetPlayerAttenuation(this.mNativeHandle, playerId, attenuation, forceSet);
    }

    @Override
    public int muteRemoteAudioStream(int uid, boolean mute) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeMuteRemoteAudioStream(this.mNativeHandle, uid, mute);
    }

    @Override
    public int setRemoteAudioAttenuation(int uid, double attenuation, boolean forceSet) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetRemoteAudioAttenuation(this.mNativeHandle, uid, attenuation, forceSet);
    }

    private native int nativeSetZones(long var1, SpatialAudioZone[] var3);

    private native int nativeSetPlayerAttenuation(long var1, int var3, double var4, boolean var6);

    private native int nativeMuteRemoteAudioStream(long var1, int var3, boolean var4);

    private native int nativeSetRemoteAudioAttenuation(long var1, int var3, double var4, boolean var6);

    private native long nativeObjectInit(LocalSpatialAudioConfig var1, long var2);

    private static native int nativeDestroy(long var0);

    private native int nativeSetParameters(long var1, String var3);

    private native int nativeUpdatePlayerPositionInfo(long var1, int var3, RemoteVoicePositionInfo var4);

    private native int nativeUpdateSelfPosition(long var1, float[] var3, float[] var4, float[] var5, float[] var6);

    private native int nativeUpdateSelfPositionEx(long var1, float[] var3, float[] var4, float[] var5, float[] var6, String var7, int var8);

    private native int nativeUpdateRemotePosition(long var1, int var3, float[] var4, float[] var5);

    private native int nativeUpdateRemotePositionEx(long var1, int var3, float[] var4, float[] var5, String var6, int var7);

    private native int nativeRemoveRemotePosition(long var1, int var3);

    private native int nativeRemoveRemotePositionEx(long var1, int var3, String var4, int var5);

    private native int nativeClearRemotePositions(long var1);

    private native int nativeClearRemotePositionsEx(long var1, String var3, int var4);
}

