/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils;

import android.os.AsyncTask;
import android.util.Base64;
import io.agora.utils.HttpAsyncTaskParam;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HttpAsyncTask
extends AsyncTask<HttpAsyncTaskParam, Void, Void> {
    private long nativeHandle = -1L;
    private static final int SIZE_FOR_CALLBACK = 16384;

    public HttpAsyncTask(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(HttpAsyncTaskParam ... params) {
        if (params.length < 1) {
            return this.notifyNativeResponse(404, 1, null, null);
        }
        HttpAsyncTaskParam param = params[0];
        try {
            URL url = new URL(param.fullUrl);
            HttpURLConnection connection = null;
            connection = param.httpProxy != null ? (HttpURLConnection)url.openConnection(param.httpProxy) : (HttpURLConnection)url.openConnection();
            if (param.headers != null) {
                for (Map.Entry<String, String> entry : param.headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (param.user != null && !param.user.isEmpty() && param.pass != null && !param.pass.isEmpty()) {
                String encoded = Base64.encodeToString((byte[])(param.user + ":" + param.pass).getBytes(), (int)0);
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
            if (param.agent != null && !param.agent.isEmpty()) {
                connection.setRequestProperty("User-Agent", param.agent);
            }
            connection.setRequestMethod(param.method);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(false);
            if (param.timeout_millsec > 0) {
                connection.setConnectTimeout(param.timeout_millsec);
                connection.setReadTimeout(param.timeout_millsec);
            }
            if ("POST".equals(param.method)) {
                connection.setDoOutput(true);
            }
            if (param.body != null) {
                DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
                writer.write(param.body);
                writer.flush();
            }
            int status = connection.getResponseCode();
            byte[] output = null;
            Map<String, List<String>> hdrs = connection.getHeaderFields();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (hdrs != null) {
                for (Map.Entry<String, List<String>> entry : hdrs.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue().get(0);
                    headers.put(key != null ? key : "", value != null ? value : "");
                }
            }
            if (status / 100 == 2 || status / 100 == 3) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                DataInputStream reader = null;
                try {
                    int n;
                    reader = new DataInputStream(connection.getInputStream());
                    while ((n = reader.read(buffer)) > 0) {
                        baos.write(buffer, 0, n);
                        if (baos.size() < 16384) continue;
                        output = baos.toByteArray();
                        this.notifyNativeResponse(status, 0, output, headers);
                        baos.reset();
                    }
                    output = baos.toByteArray();
                }
                catch (Exception exception) {
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            } else {
                String message = connection.getResponseMessage();
                if (message != null) {
                    output = message.getBytes();
                }
            }
            return this.notifyNativeResponse(status, 1, output, headers);
        }
        catch (Exception exception) {
            return this.notifyNativeResponse(404, 1, null, null);
        }
    }

    private Void notifyNativeResponse(int status, int errorCode, byte[] body, Map<String, String> headers) {
        HttpAsyncTask.nativeNotifyResponse(this.nativeHandle, status, errorCode, body, body != null ? body.length : 0, headers);
        return null;
    }

    private static native void nativeNotifyResponse(long var0, int var2, int var3, byte[] var4, int var5, Map<String, String> var6);
}

