/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import io.agora.base.NV12Buffer;
import io.agora.base.NV21Buffer;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.RendererCommon;
import java.lang.reflect.Field;

public class TextureBufferUtil {
    private static final String TAG = TextureBufferUtil.class.getSimpleName();

    @CalledByNative
    public static int getVideoFrameBufferType(VideoFrame.Buffer buffer) {
        if (buffer instanceof VideoFrame.I420Buffer) {
            return 0;
        }
        if (buffer instanceof NV12Buffer) {
            return 4;
        }
        if (buffer instanceof NV21Buffer) {
            return 3;
        }
        if (buffer instanceof VideoFrame.TextureBuffer) {
            VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
            if (VideoFrame.TextureBuffer.Type.OES.equals((Object)textureBuffer.getType())) {
                return 1;
            }
            if (VideoFrame.TextureBuffer.Type.RGB.equals((Object)textureBuffer.getType())) {
                return 2;
            }
        } else {
            if (buffer instanceof VideoFrame.I422Buffer) {
                return 5;
            }
            if (buffer instanceof VideoFrame.RgbaBuffer) {
                return 6;
            }
        }
        throw new IllegalStateException("unknown buffer type");
    }

    @CalledByNative
    private static void replaceTextureBuffer(Object buffer, int width, int height, int type, int id, float[] matrix) {
        TextureBufferUtil.modifyFinalField(buffer, "width", width);
        TextureBufferUtil.modifyFinalField(buffer, "height", height);
        TextureBufferUtil.modifyFinalField(buffer, "type", (Object)(type == 0 ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB));
        TextureBufferUtil.modifyFinalField(buffer, "id", id);
        TextureBufferUtil.modifyFinalField(buffer, "transformMatrix", RendererCommon.convertMatrixToAndroidGraphicsMatrix(matrix));
    }

    private static boolean modifyFinalField(Object obj, String fieldStr, Object value) {
        boolean result = false;
        Field modifiersField = null;
        try {
            modifiersField = Field.class.getDeclaredField("accessFlags");
        }
        catch (NoSuchFieldException e) {
            Logging.e(TAG, "NoSuchFieldException: accessFlags");
        }
        if (modifiersField == null) {
            try {
                modifiersField = Field.class.getDeclaredField("modifiers");
            }
            catch (NoSuchFieldException e) {
                Logging.e(TAG, "NoSuchFieldException: modifiers");
            }
        }
        if (modifiersField != null) {
            try {
                modifiersField.setAccessible(true);
            }
            catch (SecurityException e) {
                Logging.e(TAG, "SecurityException: setAccessible");
                return false;
            }
            try {
                Field field = TextureBuffer.class.getDeclaredField(fieldStr);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.setAccessible(true);
                field.set(obj, value);
                result = true;
            }
            catch (NoSuchFieldException e) {
                Logging.e(TAG, "NoSuchFieldException: " + fieldStr);
            }
            catch (IllegalAccessException e) {
                Logging.e(TAG, "IllegalAccessException: " + fieldStr);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "IllegalArgumentException: " + fieldStr);
            }
            catch (SecurityException e) {
                Logging.e(TAG, "SecurityException: " + fieldStr);
            }
        }
        return result;
    }

    public static @interface BufferType {
        public static final int I420 = 0;
        public static final int OES_TEXTURE = 1;
        public static final int RGB_TEXTURE = 2;
        public static final int NV21 = 3;
        public static final int NV12 = 4;
        public static final int I422 = 5;
        public static final int RGBA = 6;
    }
}

