/*
 * Decompiled with CFR 0.152.
 */
package io.agora.musiccontentcenter.internal;

import android.net.Uri;
import android.view.View;
import io.agora.mediaplayer.Constants;
import io.agora.mediaplayer.IMediaPlayerAudioFrameObserver;
import io.agora.mediaplayer.IMediaPlayerCustomDataProvider;
import io.agora.mediaplayer.IMediaPlayerObserver;
import io.agora.mediaplayer.IMediaPlayerVideoFrameObserver;
import io.agora.mediaplayer.data.MediaPlayerSource;
import io.agora.mediaplayer.data.MediaStreamInfo;
import io.agora.musiccontentcenter.IAgoraMusicPlayer;
import io.agora.rtc2.SpatialAudioParams;
import io.agora.rtc2.audio.IAudioSpectrumObserver;
import io.agora.rtc2.internal.RtcEngineImpl;
import io.agora.utils2.internal.CommonUtility;
import io.agora.utils2.internal.Logging;
import java.util.concurrent.atomic.AtomicBoolean;

public class AgoraMusicPlayerImpl
implements IAgoraMusicPlayer {
    private static final String TAG = "AgoraMusicPlayerImpl";
    private long mNativeHandle = 0L;
    private final AtomicBoolean mIsDestroying = new AtomicBoolean(false);
    private final int mNativeMediaPlayerSourceId;
    private final RtcEngineImpl mRtcEngineImpl;

    AgoraMusicPlayerImpl(RtcEngineImpl rtcEngineImpl, long playerHandle, int sourceId) {
        this.mNativeHandle = playerHandle;
        this.mNativeMediaPlayerSourceId = sourceId;
        this.mRtcEngineImpl = rtcEngineImpl;
    }

    @Override
    public int getMediaPlayerId() {
        return this.mNativeMediaPlayerSourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(Uri uri, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (open with uri)");
                return -7;
            }
            String procPath = CommonUtility.getContentFilePath(this.mRtcEngineImpl.getContext(), uri);
            if (procPath == null || procPath.equals("")) {
                Logging.e(TAG, "AgoraMusicPlayer Can not open incorrect Uri Param");
                return -2;
            }
            return this.nativeOpenWithUrl(this.mNativeHandle, procPath, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(long songCode, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (open with songCode)");
                return -7;
            }
            return this.nativeOpen(this.mNativeHandle, songCode, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int open(String url, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (open with url)");
                return -7;
            }
            return this.nativeOpenWithUrl(this.mNativeHandle, url, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int openWithCustomSource(long startPos, IMediaPlayerCustomDataProvider provider) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (openWithCustomSource)");
                return -7;
            }
            return this.nativeOpenWithCustomProviderData(this.mNativeHandle, startPos, provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openWithMediaSource(MediaPlayerSource source) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (openWithMediaSource)");
                return -7;
            }
            return this.nativeOpenWithSource(this.mNativeHandle, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int play() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (play)");
                return -7;
            }
            return this.nativePlay(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pause() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (pause)");
                return -7;
            }
            return this.nativePause(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stop() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (stop)");
                return -7;
            }
            return this.nativeStop(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resume() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (resume)");
                return -7;
            }
            return this.nativeResume(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int seek(long newPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (seek)");
                return -7;
            }
            return this.nativeSeek(this.mNativeHandle, newPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setAudioPitch(int pitch) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setAudioPitch)");
                return -7;
            }
            return this.nativeSetAudioPitch(this.mNativeHandle, pitch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mute(boolean muted) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (mute)");
                return -7;
            }
            return this.nativeMute(this.mNativeHandle, muted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMute() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return false;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getMute)");
                return false;
            }
            return this.nativeGetMute(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPlayPosition() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8L;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getPlayPosition)");
                return -7L;
            }
            return this.nativeGetPlayPosition(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDuration() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8L;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getDuration)");
                return -7L;
            }
            return this.nativeGetDuration(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constants.MediaPlayerState getState() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return Constants.MediaPlayerState.PLAYER_STATE_UNKNOWN;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getState)");
                return Constants.MediaPlayerState.PLAYER_STATE_UNKNOWN;
            }
            return Constants.MediaPlayerState.getStateByValue(this.nativeGetState(this.mNativeHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStreamCount() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getStreamCount)");
                return -7;
            }
            return this.nativeGetStreamCount(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setView(View videoView) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setView)");
                return -7;
            }
            return this.nativeSetView(this.mNativeHandle, videoView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setRenderMode(int mode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setRenderMode)");
                return -7;
            }
            return this.nativeSetRenderMode(this.mNativeHandle, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaStreamInfo getStreamInfo(int index) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getStreamInfo)");
                return null;
            }
            return this.nativeGetStreamInfo(this.mNativeHandle, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setLoopCount(int loopCount) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setLoopCount)");
                return -7;
            }
            return this.nativeSetLoopCount(this.mNativeHandle, loopCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPlaybackSpeed(int speed) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setPlaybackSpeed)");
                return -7;
            }
            return this.nativeChangePlaybackSpeed(this.mNativeHandle, speed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectAudioTrack(int index) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (selectAudioTrack)");
                return -7;
            }
            return this.nativeSelectAudioTrack(this.mNativeHandle, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectMultiAudioTrack(int playoutTrackIndex, int publishTrackIndex) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (selectMultiAudioTrack)");
                return -7;
            }
            return this.nativeSelectMultiAudioTrack(this.mNativeHandle, playoutTrackIndex, publishTrackIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPlayerOption(String key, int value) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setPlayerOption)");
                return -7;
            }
            return this.nativeSetPlayerOption(this.mNativeHandle, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPlayerOptionString(String key, String value) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setPlayerOptionString)");
                return -7;
            }
            return this.nativeSetPlayerOptionString(this.mNativeHandle, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int takeScreenshot(String filename) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (takeScreenshot)");
                return -7;
            }
            return this.nativeTakeScreenshot(this.mNativeHandle, filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int selectInternalSubtitle(int index) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (selectInternalSubtitle)");
                return -7;
            }
            return this.nativeSelectInternalSubtitle(this.mNativeHandle, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExternalSubtitle(String url) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setExternalSubtitle)");
                return -7;
            }
            return this.nativeSetExternalSubtitle(this.mNativeHandle, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int adjustPlayoutVolume(int volume) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (adjustPlayoutVolume)");
                return -7;
            }
            return this.nativeAdjustPlayoutVolume(this.mNativeHandle, volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPlayoutVolume() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getPlayoutVolume)");
                return -7;
            }
            return this.nativeGetPlayoutVolume(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int adjustPublishSignalVolume(int volume) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (adjustPublishSignalVolume)");
                return -7;
            }
            return this.nativeAdjustPublishSignalVolume(this.mNativeHandle, volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPublishSignalVolume() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getPublishSignalVolume)");
                return -7;
            }
            return this.nativeGetPublishSignalVolume(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlaySrc() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getPlaySrc)");
                return null;
            }
            return this.nativeGetPlaySrc(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int switchSrc(String src, boolean syncPts) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (switchSrc)");
                return -7;
            }
            return this.nativeSwitchSrc(this.mNativeHandle, src, syncPts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int preloadSrc(String src, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (preloadSrc)");
                return -7;
            }
            return this.nativePreloadSrc(this.mNativeHandle, src, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unloadSrc(String src) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (unloadSrc)");
                return -7;
            }
            return this.nativeUnloadSrc(this.mNativeHandle, src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int playPreloadedSrc(String src) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (playPreloadedSrc)");
                return -7;
            }
            return this.nativePlayPreloadedSrc(this.mNativeHandle, src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int destroy() {
        if (null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (destroy)");
                return -7;
            }
            this.mIsDestroying.set(true);
            int ret = AgoraMusicPlayerImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
            this.mIsDestroying.set(false);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerPlayerObserver(IMediaPlayerObserver playerObserver) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (registerPlayerObserver)");
                return -7;
            }
            return this.nativeRegisterPlayerObserver(this.mNativeHandle, playerObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unRegisterPlayerObserver(IMediaPlayerObserver playerObserver) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (unRegisterPlayerObserver)");
                return -7;
            }
            return this.nativeUnRegisterPlayerObserver(this.mNativeHandle, playerObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerAudioFrameObserver(IMediaPlayerAudioFrameObserver audioFrameObserver, int mode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (registerAudioFrameObserver)");
                return -7;
            }
            return this.nativeRegisterAudioFrameObserver(this.mNativeHandle, audioFrameObserver, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerMediaPlayerAudioSpectrumObserver(IAudioSpectrumObserver observer, int intervalInMS) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (registerMediaPlayerAudioSpectrumObserver)");
                return -7;
            }
            return this.nativeRegisterAudioSpectrumObserver(this.mNativeHandle, observer, intervalInMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unregisterMediaPlayerAudioSpectrumObserver(IAudioSpectrumObserver observer) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (unregisterMediaPlayerAudioSpectrumObserver)");
                return -7;
            }
            return this.nativeUnRegisterAudioSpectrumObserver(this.mNativeHandle, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setAudioDualMonoMode(int mode) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setAudioDualMonoMode)");
                return -7;
            }
            return this.nativeSetAudioDualMonoMode(this.mNativeHandle, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerVideoFrameObserver(IMediaPlayerVideoFrameObserver videoFrameObserver) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (registerVideoFrameObserver)");
                return -7;
            }
            return this.nativeRegisterVideoFrameObserver(this.mNativeHandle, videoFrameObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openWithAgoraCDNSrc(String src, long startPos) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (openWithAgoraCDNSrc)");
                return -7;
            }
            return this.nativeOpenWithAgoraCDNSrc(this.mNativeHandle, src, startPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAgoraCDNLineCount() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getAgoraCDNLineCount)");
                return -7;
            }
            return this.nativeGetAgoraCDNLineCount(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int switchAgoraCDNLineByIndex(int index) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (switchAgoraCDNLineByIndex)");
                return -7;
            }
            return this.nativeSwitchAgoraCDNLineByIndex(this.mNativeHandle, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentAgoraCDNIndex() {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (getCurrentAgoraCDNIndex)");
                return -7;
            }
            return this.nativeGetCurrentAgoraCDNIndex(this.mNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableAutoSwitchAgoraCDN(boolean enable) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (enableAutoSwitchAgoraCDN)");
                return -7;
            }
            return this.nativeEnableAutoSwitchAgoraCDN(this.mNativeHandle, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renewAgoraCDNSrcToken(String token, long ts) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (renewAgoraCDNSrcToken)");
                return -7;
            }
            return this.nativeRenewAgoraCDNSrcToken(this.mNativeHandle, token, ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int switchAgoraCDNSrc(String src, boolean syncPts) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (switchAgoraCDNSrc)");
                return -7;
            }
            return this.nativeSwitchAgoraCDNSrc(this.mNativeHandle, src, syncPts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSpatialAudioParams(SpatialAudioParams params) {
        if (this.mIsDestroying.get() || null == this.mRtcEngineImpl) {
            return -8;
        }
        RtcEngineImpl rtcEngineImpl = this.mRtcEngineImpl;
        synchronized (rtcEngineImpl) {
            if (this.mNativeHandle == 0L) {
                Logging.e(TAG, "AgoraMusicPlayer does not initialize or it may be destroyed (setSpatialAudioParams)");
                return -7;
            }
            return this.nativeSetSpatialAudioParams(this.mNativeHandle, params);
        }
    }

    private native int nativeOpen(long var1, long var3, long var5);

    private native int nativeOpenWithUrl(long var1, String var3, long var4);

    private native int nativeOpenWithCustomProviderData(long var1, long var3, IMediaPlayerCustomDataProvider var5);

    private native int nativeOpenWithSource(long var1, MediaPlayerSource var3);

    private native int nativePlay(long var1);

    private native int nativePause(long var1);

    private native int nativeStop(long var1);

    private native int nativeResume(long var1);

    private native int nativeSeek(long var1, long var3);

    private native int nativeSetAudioPitch(long var1, int var3);

    private native int nativeMute(long var1, boolean var3);

    private native boolean nativeGetMute(long var1);

    private native long nativeGetPlayPosition(long var1);

    private native long nativeGetDuration(long var1);

    private native int nativeGetState(long var1);

    private native int nativeGetStreamCount(long var1);

    private native int nativeSetView(long var1, View var3);

    private native int nativeSetRenderMode(long var1, int var3);

    private native MediaStreamInfo nativeGetStreamInfo(long var1, int var3);

    private native int nativeSetLoopCount(long var1, int var3);

    private native int nativeChangePlaybackSpeed(long var1, int var3);

    private native int nativeSelectAudioTrack(long var1, int var3);

    private native int nativeSelectMultiAudioTrack(long var1, int var3, int var4);

    private native int nativeSetPlayerOption(long var1, String var3, int var4);

    private native int nativeSetPlayerOptionString(long var1, String var3, String var4);

    private native int nativeTakeScreenshot(long var1, String var3);

    private native int nativeSelectInternalSubtitle(long var1, int var3);

    private native int nativeSetExternalSubtitle(long var1, String var3);

    private native int nativeAdjustPlayoutVolume(long var1, int var3);

    private native int nativeGetPlayoutVolume(long var1);

    private native int nativeAdjustPublishSignalVolume(long var1, int var3);

    private native int nativeGetPublishSignalVolume(long var1);

    private native String nativeGetPlaySrc(long var1);

    private native int nativeSwitchSrc(long var1, String var3, boolean var4);

    private native int nativePreloadSrc(long var1, String var3, long var4);

    private native int nativeUnloadSrc(long var1, String var3);

    private native int nativePlayPreloadedSrc(long var1, String var3);

    private static native int nativeDestroy(long var0);

    private native int nativeRegisterPlayerObserver(long var1, IMediaPlayerObserver var3);

    private native int nativeUnRegisterPlayerObserver(long var1, IMediaPlayerObserver var3);

    private native int nativeRegisterAudioFrameObserver(long var1, IMediaPlayerAudioFrameObserver var3, int var4);

    private native int nativeRegisterVideoFrameObserver(long var1, IMediaPlayerVideoFrameObserver var3);

    private native int nativeRegisterAudioSpectrumObserver(long var1, IAudioSpectrumObserver var3, int var4);

    private native int nativeUnRegisterAudioSpectrumObserver(long var1, IAudioSpectrumObserver var3);

    private native int nativeSetAudioDualMonoMode(long var1, int var3);

    private native int nativeOpenWithAgoraCDNSrc(long var1, String var3, long var4);

    private native int nativeGetAgoraCDNLineCount(long var1);

    private native int nativeSwitchAgoraCDNLineByIndex(long var1, int var3);

    private native int nativeGetCurrentAgoraCDNIndex(long var1);

    private native int nativeEnableAutoSwitchAgoraCDN(long var1, boolean var3);

    private native int nativeRenewAgoraCDNSrcToken(long var1, String var3, long var4);

    private native int nativeSwitchAgoraCDNSrc(long var1, String var3, boolean var4);

    private native int nativeSetSpatialAudioParams(long var1, SpatialAudioParams var3);
}

