/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.text.TextUtils;
import io.agora.utils2.internal.HardwareEarMonitorController;
import io.agora.utils2.internal.Logging;

public class VolumeChangeReceiver
extends BroadcastReceiver {
    private static final String TAG = VolumeChangeReceiver.class.getSimpleName();
    static final String ACTION_VOLUME_CHANGED = "android.media.VOLUME_CHANGED_ACTION";

    public void onReceive(Context context, Intent intent) {
        int streamType;
        if (!TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)ACTION_VOLUME_CHANGED)) {
            Logging.w(TAG, "not volume change action");
            return;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        int audioMode = audioManager.getMode();
        Logging.d(TAG, "current audio mode is: " + audioMode);
        if (audioMode == 3) {
            streamType = 0;
        } else if (audioMode == 0) {
            streamType = 3;
        } else {
            Logging.w(TAG, "invalid audio mode");
            return;
        }
        int currentVolume = audioManager.getStreamVolume(streamType);
        Logging.d(TAG, "current volume is: " + currentVolume);
        int volume = currentVolume * 100 / 15;
        HardwareEarMonitorController.getInstance().setHardwareEarMonitorVolume(volume);
    }
}

