/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.os.Build;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.VideoEncoder;
import java.util.Arrays;

class BitrateAdjusterHelper {
    private static final String TAG = "BitrateAdjusterHelper";
    private static final String[] H264_HW_QCOM_EXCEPTION_MODELS = new String[]{"mi note lte", "redmi note 4x", "1605-a01", "aosp on hammerhead", "lm-x210", "oppo r9s"};
    private static final String[] MTK_NO_ADJUSTMENT_MODELS = new String[]{"vivo y83a", "vivo x21i", "vivo X21i A"};

    BitrateAdjusterHelper() {
    }

    public static VideoEncoder.EncoderStyle getEncoderStyle(String codecName) {
        VideoEncoder.EncoderStyle encoderStyle = new VideoEncoder.EncoderStyle();
        if (codecName.startsWith("OMX.qcom.") || codecName.toLowerCase().contains("c2.qti.")) {
            if (Arrays.asList(H264_HW_QCOM_EXCEPTION_MODELS).contains(Build.MODEL.toLowerCase())) {
                Logging.w(TAG, "Qcom Exception Model: " + Build.MODEL);
                encoderStyle.isNeedResetWhenDownBps = true;
            }
            encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
        } else if (codecName.startsWith("OMX.MTK.") || codecName.toLowerCase().startsWith("c2.mtk.")) {
            Logging.v(TAG, "MTK hardware: " + Build.HARDWARE);
            if (Build.HARDWARE.equalsIgnoreCase("mt6763") || Build.HARDWARE.equalsIgnoreCase("mt6763t")) {
                encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            } else if (Arrays.asList(MTK_NO_ADJUSTMENT_MODELS).contains(Build.MODEL)) {
                encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            } else if (Build.HARDWARE.equalsIgnoreCase("mt6735")) {
                encoderStyle.bitrateAdjustment = 2;
                encoderStyle.highProfileSupported = false;
            } else {
                encoderStyle.bitrateAdjustment = 2;
                encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            }
        } else if (codecName.startsWith("OMX.Exynos.") || codecName.toLowerCase().startsWith("c2.exynos.")) {
            if (Build.MODEL.equalsIgnoreCase("MX4 Pro")) {
                encoderStyle.bitrateAdjustment = 2;
                encoderStyle.highProfileSupported = false;
            } else if (Build.MANUFACTURER.equalsIgnoreCase("vivo") && Build.MODEL.equalsIgnoreCase("V1938CT")) {
                encoderStyle.bitrateAdjustment = 2;
                encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            } else if (Build.VERSION.SDK_INT > 28) {
                encoderStyle.bitrateAdjustment = 2;
                encoderStyle.highProfileSupported = true;
            } else {
                encoderStyle.bitrateAdjustment = 1;
                encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
            }
        } else if (codecName.startsWith("OMX.IMG.TOPAZ.") || codecName.toLowerCase().startsWith("c2.img.")) {
            if (Build.HARDWARE.equalsIgnoreCase("hi6250")) {
                encoderStyle.bitrateAdjustment = 2;
            } else {
                encoderStyle.highProfileSupported = false;
                encoderStyle.bitrateAdjustment = 1;
            }
        } else if (codecName.startsWith("OMX.hisi.") || codecName.toLowerCase().startsWith("c2.hisi.")) {
            encoderStyle.highProfileSupported = false;
            encoderStyle.bitrateAdjustment = 2;
        } else if (codecName.startsWith("OMX.k3.") || codecName.toLowerCase().startsWith("c2.k3.")) {
            encoderStyle.bitrateAdjustment = 1;
            encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 21;
        } else if (codecName.startsWith("OMX.amlogic.") || codecName.toLowerCase().startsWith("c2.amlogic.")) {
            Logging.v(TAG, "getChipProperties for amlogic");
            encoderStyle.bitrateAdjustment = 1;
            encoderStyle.highProfileSupported = false;
        } else if (codecName.startsWith("OMX.rk.") || codecName.toLowerCase().startsWith("c2.rk.")) {
            encoderStyle.bitrateAdjustment = 1;
            encoderStyle.highProfileSupported = false;
        } else {
            Logging.v(TAG, "getChipProperties from unsupported chip list");
            encoderStyle.highProfileSupported = Build.VERSION.SDK_INT >= 23;
        }
        return encoderStyle;
    }
}

