/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine;

import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.Logging;
import io.agora.base.internal.voiceengine.HardwareEarMonitorListener;
import io.agora.base.internal.voiceengine.HuaweiHardwareEarMonitor;
import io.agora.base.internal.voiceengine.IHardwareEarMonitor;

public class HardwareEarMonitorController
implements HardwareEarMonitorListener {
    private static final String TAG = HardwareEarMonitorController.class.getSimpleName();
    private static final String MANUFACTURER_HUAWEI = "huawei";
    @Nullable
    private IHardwareEarMonitor mHardwareEarMonitor = null;
    private final int HARDWARE_EARMONITOR_STATE_NOT_INITIALIZED = 0;
    private final int HARDWARE_EARMONITOR_STATE_INITIALIZING = 1;
    private final int HARDWARE_EARMONITOR_STATE_KIT_NOT_INSTALL = 2;
    private final int HARDWARE_EARMONITOR_STATE_READY = 3;
    private int mHardwareEarMonitorState = 0;
    private boolean mHardwareEarMonitorSupport = false;

    public HardwareEarMonitorController(boolean enable) {
        String build = Build.MANUFACTURER;
        if (!enable) {
            Logging.w(TAG, "config to disable hw earmonitor success");
            return;
        }
        if (build.trim().toLowerCase().contains(MANUFACTURER_HUAWEI)) {
            this.mHardwareEarMonitor = new HuaweiHardwareEarMonitor(this);
        }
    }

    public void initialize() {
        if (this.mHardwareEarMonitor != null) {
            this.mHardwareEarMonitor.initialize();
            this.mHardwareEarMonitorState = 1;
        }
    }

    @VisibleForTesting
    void setHardwareEarMonitor(IHardwareEarMonitor mHardwareEarMonitor) {
        this.mHardwareEarMonitor = mHardwareEarMonitor;
    }

    public boolean isHardwareEarMonitorSupported() {
        if (this.mHardwareEarMonitorState == 3) {
            return this.mHardwareEarMonitorSupport;
        }
        if (this.mHardwareEarMonitorState == 1) {
            Logging.w(TAG, "HwAudioKit is intializing, check it later plz");
        } else if (this.mHardwareEarMonitorState == 2) {
            Logging.w(TAG, "HwAudioKit is not installed");
        }
        return false;
    }

    public int enableHardwareEarMonitor(boolean enable) {
        if (this.mHardwareEarMonitor != null) {
            return this.mHardwareEarMonitor.enableHardwareEarMonitor(enable);
        }
        return -7;
    }

    public int setHardwareEarMonitorVolume(int vol) {
        if (this.mHardwareEarMonitor != null) {
            return this.mHardwareEarMonitor.setHardwareEarMonitorVolume(vol);
        }
        return -7;
    }

    public void terminate() {
        if (this.mHardwareEarMonitor != null) {
            this.mHardwareEarMonitor.destroy();
            this.mHardwareEarMonitor = null;
        }
    }

    @Override
    public void onInitResult(int res) {
        this.mHardwareEarMonitorState = 3;
        if (res == 2) {
            this.mHardwareEarMonitorState = 2;
            this.mHardwareEarMonitorSupport = false;
        }
    }

    @Override
    public void onKaraokeSupport(boolean support) {
        this.mHardwareEarMonitorSupport = support;
    }
}

