/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.voiceengine.HardwareEarMonitorListener;
import io.agora.base.internal.voiceengine.IHardwareEarMonitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class HuaweiHardwareEarMonitor
implements IHardwareEarMonitor {
    private static final String TAG = HuaweiHardwareEarMonitor.class.getSimpleName();
    private AudioKitCallbackImpl mAudioKitCallbackImpl = new AudioKitCallbackImpl();
    @Nullable
    private HardwareEarMonitorListener mListener;
    @Nullable
    private Context mContext;
    @Nullable
    private Object mHwAudioKit = null;
    @Nullable
    private Object mHwAudioKaraokeFeatureKit = null;
    private Class<?> mHwAudioKaraokeFeatureKitClass;
    private Class<?> mHwAudioKitClass;
    private Class<?> mParamNameClass;
    private volatile boolean mInitialized = false;
    private volatile boolean mIsDestroyed = false;
    private volatile boolean mEarMonitorEnabled = false;

    public HuaweiHardwareEarMonitor(HardwareEarMonitorListener listener) {
        Logging.d(TAG, ">>ctor");
        this.mListener = listener;
        this.mContext = ContextUtils.getApplicationContext();
    }

    @VisibleForTesting
    void setHwAudioKaraokeFeatureKit(Object hwAudioKaraokeFeatureKit) {
        this.mHwAudioKaraokeFeatureKit = hwAudioKaraokeFeatureKit;
    }

    @VisibleForTesting
    InvocationHandler getInvocationHandler() {
        return this.mAudioKitCallbackImpl;
    }

    @Override
    public void initialize() {
        Logging.d(TAG, "HwAudioKit initialize");
        if (this.mContext == null) {
            Logging.e(TAG, "mContext is null!");
            return;
        }
        if (this.mInitialized) {
            Logging.w(TAG, "already initialized, ignore");
            return;
        }
        try {
            this.mHwAudioKaraokeFeatureKitClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit");
            this.mHwAudioKitClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
            Class<?> iAudioKitCallbackClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback");
            Class<?> featureTypeClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKit$FeatureType");
            this.mParamNameClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit$ParameName");
            Object audioKitCallback = Proxy.newProxyInstance(iAudioKitCallbackClass.getClassLoader(), new Class[]{iAudioKitCallbackClass}, (InvocationHandler)this.mAudioKitCallbackImpl);
            Class[] types = new Class[]{Context.class, iAudioKitCallbackClass};
            Constructor<?> hwAudioKitCon = this.mHwAudioKitClass.getConstructor(types);
            this.mHwAudioKit = hwAudioKitCon.newInstance(this.mContext, audioKitCallback);
            Method initializeMethod = this.mHwAudioKitClass.getDeclaredMethod("initialize", new Class[0]);
            initializeMethod.invoke(this.mHwAudioKit, new Object[0]);
            Method createFeatureMethod = this.mHwAudioKitClass.getDeclaredMethod("createFeature", featureTypeClass);
            this.mHwAudioKaraokeFeatureKit = createFeatureMethod.invoke(this.mHwAudioKit, featureTypeClass.getEnumConstants()[0]);
            this.mInitialized = true;
            Logging.d(TAG, "HwAudioKit initialize success");
        }
        catch (Exception e) {
            Logging.e(TAG, "HwAudioKit initialize failed");
        }
    }

    @Override
    public boolean isHardwareEarMonitorSupported() {
        Logging.d(TAG, ">>isHardwareEarMonitorSupported");
        try {
            Method isKaraokeFeatureSupportMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("isKaraokeFeatureSupport", new Class[0]);
            boolean isSupported = (Boolean)isKaraokeFeatureSupportMethod.invoke(this.mHwAudioKaraokeFeatureKit, new Object[0]);
            Logging.d(TAG, "Karaoke earmonitor is" + (isSupported ? " " : "not ") + "support ");
            return isSupported;
        }
        catch (Exception e) {
            Logging.e(TAG, "isHardwareEarMonitorSupported false ", e);
            return false;
        }
    }

    @Override
    public int setHardwareEarMonitorVolume(int vol) {
        if (!this.mEarMonitorEnabled) {
            return -7;
        }
        Logging.d(TAG, ">>setHardwareEarMonitorVolume " + vol);
        if (vol < 0) {
            vol = 0;
        } else if (vol > 100) {
            vol = 100;
        }
        try {
            Method setParameterMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("setParameter", this.mParamNameClass, Integer.TYPE);
            int ret = (Integer)setParameterMethod.invoke(this.mHwAudioKaraokeFeatureKit, this.mParamNameClass.getEnumConstants()[1], vol);
            Logging.d(TAG, "setParameter ret " + ret);
            if (ret != 0) {
                return -1;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "setHardwareEarMonitorVolume failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public int enableHardwareEarMonitor(boolean enable) {
        Logging.d(TAG, ">>enableHardwareEarMonitor " + enable);
        try {
            Method enableKaraokeFeatureMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("enableKaraokeFeature", Boolean.TYPE);
            int ret = (Integer)enableKaraokeFeatureMethod.invoke(this.mHwAudioKaraokeFeatureKit, enable);
            if (ret != 0) {
                Logging.e(TAG, "enableKaraokeFeature failed ret " + ret);
                return -1;
            }
            this.mEarMonitorEnabled = enable;
            if (this.mEarMonitorEnabled) {
                Method getKaraokeLatencyMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("getKaraokeLatency", new Class[0]);
                int latency = (Integer)getKaraokeLatencyMethod.invoke(this.mHwAudioKaraokeFeatureKit, new Object[0]);
                Logging.d(TAG, "latency: " + latency);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "enableHardwareEarMonitor failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public void destroy() {
        Logging.d(TAG, "karaoke kit destroy");
        this.mListener = null;
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        this.mIsDestroyed = true;
        this.destroyImpl();
    }

    private void destroyImpl() {
        try {
            Method hwAudioKaraokeFeatureKitDestroyMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("destroy", new Class[0]);
            hwAudioKaraokeFeatureKitDestroyMethod.invoke(this.mHwAudioKaraokeFeatureKit, new Object[0]);
            Method hwAudioKitDestroyMethod = this.mHwAudioKitClass.getDeclaredMethod("destroy", new Class[0]);
            hwAudioKitDestroyMethod.invoke(this.mHwAudioKit, new Object[0]);
            Logging.d(TAG, "karaoke kit destroy call.");
        }
        catch (Exception e) {
            Logging.e(TAG, "destroy failed ", e);
        }
    }

    private class AudioKitCallbackImpl
    implements InvocationHandler {
        private AudioKitCallbackImpl() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            block12: {
                try {
                    if (!"onResult".equals(method.getName())) break block12;
                    int result = (Integer)args[0];
                    Logging.d(TAG, "onResult: " + result);
                    if (HuaweiHardwareEarMonitor.this.mIsDestroyed) {
                        Logging.d(TAG, "ignore result after destroy");
                        if (result == 0 || result == 1000) {
                            HuaweiHardwareEarMonitor.this.destroyImpl();
                        }
                        return proxy;
                    }
                    switch (result) {
                        case 0: {
                            if (HuaweiHardwareEarMonitor.this.mListener != null) {
                                HuaweiHardwareEarMonitor.this.mListener.onInitResult(0);
                            }
                            Logging.d(TAG, "IAudioKitCallback: HwAudioKit init success");
                            break;
                        }
                        case 2: {
                            Logging.d(TAG, "IAudioKitCallback: HwAudioKit not installed");
                            if (HuaweiHardwareEarMonitor.this.mListener != null) {
                                HuaweiHardwareEarMonitor.this.mListener.onInitResult(2);
                            }
                            break;
                        }
                        case 1000: {
                            boolean support = HuaweiHardwareEarMonitor.this.isHardwareEarMonitorSupported();
                            if (HuaweiHardwareEarMonitor.this.mListener != null) {
                                HuaweiHardwareEarMonitor.this.mListener.onKaraokeSupport(support);
                            }
                            Logging.d(TAG, "IAudioKitCallback: Karaoke feature created");
                            break;
                        }
                        default: {
                            Logging.e(TAG, "IAudioKitCallback: onResult error number " + result);
                        }
                    }
                }
                catch (Exception e) {
                    Logging.e(TAG, "AudioKitCallbackImpl invoke failed ", e);
                }
            }
            return proxy;
        }
    }
}

