/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2;

import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import io.agora.utils2.HttpAsyncTaskParam;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HttpAsyncTask
extends AsyncTask<HttpAsyncTaskParam, Void, Void> {
    private static final String TAG = "HttpAsyncTask";
    private static final int RESPONSE_COMPLETED_REASON_NONE = 0;
    private static final int RESPONSE_COMPLETED_REASON_SUCCESS = 1;
    private static final int RESPONSE_COMPLETED_REASON_UNKNOWN_HOST = 2;
    private static final int RESPONSE_COMPLETED_REASON_SOCKET_TIMEOUT = 3;
    private static final int RESPONSE_COMPLETED_REASON_OTHER_ERROR = 4;
    private static final int RESPONSE_ON_GOING = 0;
    private static final int RESPONSE_COMPLETED = 1;
    private long nativeHandle = -1L;
    private static final int SIZE_FOR_CALLBACK = 16384;

    public HttpAsyncTask(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(HttpAsyncTaskParam ... params) {
        int completedReason = 0;
        if (params.length < 1) {
            completedReason = 4;
            this.notifyNativeResponse(404, 1, completedReason, null, null);
            return null;
        }
        HttpAsyncTaskParam param = params[0];
        try {
            URL url = new URL(param.fullUrl);
            HttpURLConnection connection = null;
            connection = param.httpProxy != null ? (HttpURLConnection)url.openConnection(param.httpProxy) : (HttpURLConnection)url.openConnection();
            if (param.headers != null) {
                for (Map.Entry<String, String> entry : param.headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (param.user != null && !param.user.isEmpty() && param.pass != null && !param.pass.isEmpty()) {
                String encoded = Base64.encodeToString((byte[])(param.user + ":" + param.pass).getBytes(), (int)0);
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
            if (param.agent != null && !param.agent.isEmpty()) {
                connection.setRequestProperty("User-Agent", param.agent);
            }
            connection.setRequestMethod(param.method);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(false);
            if (param.timeout_millsec > 0) {
                connection.setConnectTimeout(param.timeout_millsec);
                connection.setReadTimeout(param.timeout_millsec);
            }
            if ("POST".equals(param.method)) {
                connection.setDoOutput(true);
            }
            if (param.body != null) {
                DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
                writer.write(param.body);
                writer.flush();
            }
            int status = connection.getResponseCode();
            byte[] output = null;
            Map<String, List<String>> hdrs = connection.getHeaderFields();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (hdrs != null) {
                for (Map.Entry<String, List<String>> entry : hdrs.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue().get(0);
                    headers.put(key != null ? key : "", value != null ? value : "");
                }
            }
            Log.i((String)TAG, (String)("resp code: " + status));
            if (status / 100 == 2 || status / 100 == 3 || status / 100 == 4) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                try (FilterInputStream reader = null;){
                    int n;
                    reader = status / 100 == 4 ? new DataInputStream(connection.getErrorStream()) : new DataInputStream(connection.getInputStream());
                    while ((n = ((DataInputStream)reader).read(buffer)) > 0) {
                        baos.write(buffer, 0, n);
                        if (baos.size() < 16384) continue;
                        output = baos.toByteArray();
                        if (this.notifyNativeResponse(status, 0, completedReason, output, headers) != 0) break;
                        baos.reset();
                    }
                    output = baos.toByteArray();
                    completedReason = 1;
                }
            } else {
                String message = connection.getResponseMessage();
                if (message != null) {
                    output = message.getBytes();
                }
            }
            this.notifyNativeResponse(status, 1, completedReason, output, headers);
            return null;
        }
        catch (UnknownHostException ex) {
            Log.e((String)TAG, (String)"got unknown host exception");
            completedReason = 2;
        }
        catch (SocketTimeoutException ex) {
            Log.e((String)TAG, (String)"got time out exception");
            completedReason = 3;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("got exception " + ex.toString()));
            completedReason = 4;
        }
        this.notifyNativeResponse(404, 1, completedReason, null, null);
        return null;
    }

    private int notifyNativeResponse(int status, int isCompleted, int completedReason, byte[] body, Map<String, String> headers) {
        return HttpAsyncTask.nativeNotifyResponse(this.nativeHandle, status, isCompleted, completedReason, body, body != null ? body.length : 0, headers);
    }

    private static native int nativeNotifyResponse(long var0, int var2, int var3, int var4, byte[] var5, int var6, Map<String, String> var7);
}

