/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import androidx.annotation.Nullable;
import io.agora.base.JavaI420Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.RefCountDelegate;
import java.nio.ByteBuffer;

public class JavaI010Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final RefCountDelegate refCountDelegate;
    private static final int BYTE_PER_CHANNEL = 2;

    public JavaI010Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, @Nullable Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.strideY = strideY;
        this.strideU = strideU;
        this.strideV = strideV;
        this.dataY = dataY;
        this.dataU = dataU;
        this.dataV = dataV;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    private static void checkCapacity(ByteBuffer data, int width, int height, int stride) {
        int minCapacity = (stride * (height - 1) + width) * 2;
        if (data.capacity() < minCapacity) {
            throw new IllegalArgumentException("I010 Buffer must be at least " + minCapacity + " bytes, but was " + data.capacity() + "in i010");
        }
    }

    public static JavaI010Buffer wrap(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, @Nullable Runnable releaseCallback) {
        if (dataY == null || dataU == null || dataV == null) {
            throw new IllegalArgumentException("Data i010 buffers cannot be null.");
        }
        if (!(dataY.isDirect() && dataU.isDirect() && dataV.isDirect())) {
            throw new IllegalArgumentException("Data i010 buffers must be direct byte buffers.");
        }
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = (height + 1) / 2;
        dataY = dataY.slice();
        dataU = dataU.slice();
        dataV = dataV.slice();
        JavaI010Buffer.checkCapacity(dataY, width, height, strideY);
        JavaI010Buffer.checkCapacity(dataU, chromaWidth, chromaHeight, strideU);
        JavaI010Buffer.checkCapacity(dataV, chromaWidth, chromaHeight, strideV);
        return new JavaI010Buffer(width, height, dataY, strideY, dataU, strideU, dataV, strideV, releaseCallback);
    }

    public static JavaI010Buffer allocate(int width, int height) {
        int chromaHeight = (height + 1) / 2;
        int strideUV = (width + 1) / 2;
        int yPos = 0;
        int uPos = yPos + width * height * 2;
        int vPos = uPos + strideUV * chromaHeight * 2;
        final ByteBuffer i010Buffer = JniCommon.nativeAllocateByteBuffer((width * height + 2 * strideUV * chromaHeight) * 2);
        i010Buffer.position(yPos);
        i010Buffer.limit(uPos);
        ByteBuffer dataY = i010Buffer.slice();
        i010Buffer.position(uPos);
        i010Buffer.limit(vPos);
        ByteBuffer dataU = i010Buffer.slice();
        i010Buffer.position(vPos);
        i010Buffer.limit(vPos + strideUV * chromaHeight * 2);
        ByteBuffer dataV = i010Buffer.slice();
        return new JavaI010Buffer(width, height, dataY, width, dataU, strideUV, dataV, strideUV, new Runnable(){

            @Override
            public void run() {
                JniCommon.nativeFreeByteBuffer(i010Buffer);
            }
        });
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return JavaI010Buffer.i010BufferToI420(this);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    @Nullable
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer rotate(int frameRotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        return null;
    }

    @Override
    @Nullable
    public VideoFrame.Buffer mirror(int frameRotation) {
        return null;
    }

    public static VideoFrame.I420Buffer i010BufferToI420(JavaI010Buffer buffer) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(buffer.width, buffer.height);
        JavaI010Buffer.nativeI010toI420(buffer.getDataY(), buffer.getStrideY(), buffer.getDataU(), buffer.getStrideU(), buffer.getDataV(), buffer.getStrideV(), buffer.width, buffer.height, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV(), newBuffer.getWidth(), newBuffer.getHeight());
        return newBuffer;
    }

    private static native void nativeI010toI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, ByteBuffer var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, int var14, int var15);
}

