/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.VideoCodecProfile;
import io.agora.base.internal.video.VideoCodecType;
import java.util.Arrays;
import java.util.List;

public class VideoDecoderUtils {
    private static final String TAG = "HardwareVideoDecoderUtils";
    private static final List<String> H264_HWDEC_EXCEPTION_MODELS = Arrays.asList("ASUS_T00J");
    private static MediaCodecInfo vp8CodecInfo;
    private static MediaCodecInfo vp9CodecInfo;
    private static MediaCodecInfo h264CodecInfo;
    private static MediaCodecInfo h265CodecInfo;

    @CalledByNative
    static boolean isSupportHwDecoderByType(String codecType) {
        return VideoCodecType.contains(codecType) && VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType)) != null;
    }

    @CalledByNative
    static boolean isSupportHwDecoderByTypeAndProfile(String codecType, String profile) {
        Logging.w(TAG, "isSupportHwDecoderByTypeAndProfile " + codecType + ":" + profile);
        MediaCodecInfo info = null;
        if (VideoCodecType.contains(codecType) && (info = VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType))) != null) {
            try {
                if (VideoCodecProfile.contains(profile) && VideoDecoderUtils.isSupportedProfile(info.getCapabilitiesForType(VideoCodecType.valueOf(codecType).mimeType()), VideoCodecProfile.valueOf(profile))) {
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return false;
    }

    @CalledByNative
    static boolean IsSupportDecodeHEVC10Bit() {
        MediaCodecInfo info = VideoDecoderUtils.findCodecForType(VideoCodecType.H265);
        if (info == null) {
            return false;
        }
        try {
            MediaCodecInfo.CodecCapabilities codecCapabilities = info.getCapabilitiesForType(VideoCodecType.H265.mimeType());
            if (codecCapabilities == null || codecCapabilities.profileLevels == null) {
                return false;
            }
            for (MediaCodecInfo.CodecProfileLevel profileLevels : codecCapabilities.profileLevels) {
                if (profileLevels.profile != 2 && profileLevels.profile != 4096 && profileLevels.profile != 8192) continue;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            ThrowableExtension.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    static MediaCodecInfo findCodecForType(VideoCodecType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (type == VideoCodecType.VP8 && vp8CodecInfo != null) {
            return vp8CodecInfo;
        }
        if (type == VideoCodecType.VP9 && vp9CodecInfo != null) {
            return vp9CodecInfo;
        }
        if (type == VideoCodecType.H264 && h264CodecInfo != null) {
            return h264CodecInfo;
        }
        if (type == VideoCodecType.H265 && h265CodecInfo != null) {
            return h265CodecInfo;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || info.isEncoder() || !VideoDecoderUtils.isSupportedCodec(info, type)) continue;
            Logging.d(TAG, "found available decodec: " + info.getName());
            if (type == VideoCodecType.VP8) {
                vp8CodecInfo = info;
            } else if (type == VideoCodecType.VP9) {
                vp9CodecInfo = info;
            } else if (type == VideoCodecType.H264) {
                h264CodecInfo = info;
            } else if (type == VideoCodecType.H265) {
                h265CodecInfo = info;
            }
            return info;
        }
        return null;
    }

    static boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        try {
            if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
                Logging.w(TAG, "selectColorFormat is null");
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            ThrowableExtension.printStackTrace((Throwable)e);
            return false;
        }
        if (MediaCodecUtils.checkInvalidDecoder(info.getName())) {
            return false;
        }
        return VideoDecoderUtils.isHardwareSupported(info, type);
    }

    static boolean isHardwareSupported(MediaCodecInfo info, VideoCodecType type) {
        String name = info.getName();
        switch (type) {
            case VP8: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Intel.") || name.startsWith("OMX.Exynos.") || name.startsWith("OMX.Nvidia.");
            }
            case VP9: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.");
            }
            case H264: {
                return !H264_HWDEC_EXCEPTION_MODELS.contains(Build.MODEL);
            }
            case H265: {
                return Build.VERSION.SDK_INT >= 21;
            }
        }
        return false;
    }

    static int getSupportedDecoders() {
        int supportCodecs = 0;
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (info.isEncoder()) continue;
            for (String mimeType : info.getSupportedTypes()) {
                if (mimeType.equals(VideoCodecType.VP8.mimeType())) {
                    supportCodecs |= 1;
                    continue;
                }
                if (mimeType.equals(VideoCodecType.H264.mimeType())) {
                    supportCodecs |= 2;
                    continue;
                }
                if (!mimeType.equals(VideoCodecType.H265.mimeType())) continue;
                supportCodecs |= 4;
            }
        }
        return supportCodecs;
    }

    static boolean isSupportedProfile(MediaCodecInfo.CodecCapabilities cap, VideoCodecProfile profile) {
        if (cap != null) {
            for (int i = 0; i < cap.profileLevels.length; ++i) {
                Logging.d(TAG, "device decoder profile:" + cap.profileLevels[i].profile);
                if (cap.profileLevels[i].profile != profile.profile()) continue;
                Logging.d(TAG, "match decoder profile:" + cap.profileLevels[i].profile);
                return true;
            }
        }
        return false;
    }

    @CalledByNative
    static int getMaxSupportedInstances(String codecType) {
        MediaCodecInfo info = null;
        if (VideoCodecType.contains(codecType) && (info = VideoDecoderUtils.findCodecForType(VideoCodecType.valueOf(codecType))) != null) {
            try {
                MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(VideoCodecType.valueOf(codecType).mimeType());
                if (capabilities == null) {
                    return -1;
                }
                return capabilities.getMaxSupportedInstances();
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
        return -1;
    }
}

