/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import io.agora.base.internal.CalledByNative;

public class ScreenCaptureParameters {
    public boolean captureAudio = false;
    public VideoCaptureParameters videoCaptureParameters = new VideoCaptureParameters();
    public boolean captureVideo = true;
    public AudioCaptureParameters audioCaptureParameters = new AudioCaptureParameters();

    @CalledByNative
    public boolean isCaptureAudio() {
        return this.captureAudio;
    }

    @CalledByNative
    public VideoCaptureParameters getVideoCaptureParameters() {
        return this.videoCaptureParameters;
    }

    @CalledByNative
    public boolean isCaptureVideo() {
        return this.captureVideo;
    }

    @CalledByNative
    public AudioCaptureParameters getAudioCaptureParameters() {
        return this.audioCaptureParameters;
    }

    public String toString() {
        return "ScreenCaptureParameters{captureAudio=" + this.captureAudio + ", videoCaptureParameters=" + this.videoCaptureParameters + ", captureVideo=" + this.captureVideo + ", audioCaptureParameters=" + this.audioCaptureParameters + '}';
    }

    public static class AudioCaptureParameters {
        public int sampleRate = 16000;
        public int channels = 2;
        public int captureSignalVolume = 100;
        public boolean allowCaptureCurrentApp = true;

        @CalledByNative(value="AudioCaptureParameters")
        public int getSampleRate() {
            return this.sampleRate;
        }

        @CalledByNative(value="AudioCaptureParameters")
        public int getChannels() {
            return this.channels;
        }

        @CalledByNative(value="AudioCaptureParameters")
        public int getCaptureSignalVolume() {
            return this.captureSignalVolume;
        }

        public String toString() {
            return "AudioCaptureParameters{sampleRate=" + this.sampleRate + ", channels=" + this.channels + ", captureSignalVolume=" + this.captureSignalVolume + ", allowCaptureCurrentApp=" + this.allowCaptureCurrentApp + '}';
        }
    }

    public static class VideoCaptureParameters {
        public int bitrate = 0;
        public int framerate = 15;
        public int width = 1280;
        public int height = 720;
        public int contentHint = 1;

        @CalledByNative(value="VideoCaptureParameters")
        public int getBitrate() {
            return this.bitrate;
        }

        @CalledByNative(value="VideoCaptureParameters")
        public int getFramerate() {
            return this.framerate;
        }

        @CalledByNative(value="VideoCaptureParameters")
        public int getWidth() {
            return this.width;
        }

        @CalledByNative(value="VideoCaptureParameters")
        public int getHeight() {
            return this.height;
        }

        @CalledByNative(value="VideoCaptureParameters")
        public int getContentHint() {
            return this.contentHint;
        }

        public String toString() {
            return "VideoCaptureParameters{bitrate=" + this.bitrate + ", framerate=" + this.framerate + ", width=" + this.width + ", height=" + this.height + ", contentHint=" + this.contentHint + '}';
        }
    }
}

