/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.rte.Constants;
import io.agora.rte.Rect;

public class CanvasConfig {
    private long mNativeHandle = this.nativeCreateCanvasConfig();

    protected void finalize() {
        this.Release();
    }

    public void Release() {
        this.nativeReleaseCanvasConfig(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    public long GetNativeHandle() {
        return this.mNativeHandle;
    }

    public void SetVideoRenderMode(Constants.VideoRenderMode mode) {
        this.nativeSetVideoRenderMode(this.mNativeHandle, Constants.VideoRenderMode.getValue(mode));
    }

    public Constants.VideoRenderMode GetVideoRenderMode() {
        return Constants.VideoRenderMode.fromInt(this.nativeGetVideoRenderMode(this.mNativeHandle));
    }

    public void SetVideoMirrorMode(Constants.VideoMirrorMode mode) {
        this.nativeSetVideoMirrorMode(this.mNativeHandle, Constants.VideoMirrorMode.getValue(mode));
    }

    public Constants.VideoMirrorMode GetVideoMirrorMode() {
        return Constants.VideoMirrorMode.fromInt(this.nativeGetVideoMirrorMode(this.mNativeHandle));
    }

    public void SetCropArea(Rect rect) {
        this.nativeSetCropArea(this.mNativeHandle, rect);
    }

    public Rect GetCropArea() {
        return this.nativeGetCropArea(this.mNativeHandle);
    }

    private native long nativeCreateCanvasConfig();

    private native void nativeReleaseCanvasConfig(long var1);

    private native void nativeSetVideoRenderMode(long var1, int var3);

    private native int nativeGetVideoRenderMode(long var1);

    private native void nativeSetVideoMirrorMode(long var1, int var3);

    private native int nativeGetVideoMirrorMode(long var1);

    private native void nativeSetCropArea(long var1, Rect var3);

    private native Rect nativeGetCropArea(long var1);
}

