/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

public class Constants {

    public static enum VideoMirrorMode {
        AUTO(0),
        ENABLED(1),
        DISABLED(2);

        private int value;

        private VideoMirrorMode(int value) {
            this.value = value;
        }

        public static int getValue(VideoMirrorMode type) {
            return type.value;
        }

        public static VideoMirrorMode fromInt(int v) {
            for (VideoMirrorMode type : VideoMirrorMode.values()) {
                if (VideoMirrorMode.getValue(type) != v) continue;
                return type;
            }
            return null;
        }
    }

    public static enum VideoRenderMode {
        HIDDEN(0),
        FIT(1);

        private int value;

        private VideoRenderMode(int value) {
            this.value = value;
        }

        public static int getValue(VideoRenderMode type) {
            return type.value;
        }

        public static VideoRenderMode fromInt(int v) {
            for (VideoRenderMode type : VideoRenderMode.values()) {
                if (VideoRenderMode.getValue(type) != v) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ErrorCode {
        OK(0),
        DEFAULT(1),
        INVALID_ARGUMENT(2),
        INVALID_OPERATION(3),
        NETWORK_ERROR(4),
        AUTHENTICATION_FAILED(5),
        STREAM_NOT_FOUND(6);

        private int value;

        private ErrorCode(int value) {
            this.value = value;
        }

        public static int getValue(ErrorCode type) {
            return type.value;
        }

        public static ErrorCode fromInt(int v) {
            for (ErrorCode type : ErrorCode.values()) {
                if (ErrorCode.getValue(type) != v) continue;
                return type;
            }
            return null;
        }
    }

    public static enum PlayerEvent {
        SEEK_BEGIN(0),
        SEEK_COMPLETE(1),
        SEEK_ERROR(2),
        BUFFER_LOW(3),
        BUFFER_RECOVER(4),
        FREEZE_START(5),
        FREEZE_STOP(6),
        ONE_LOOP_PLAYBACK_COMPLETED(7),
        AUTHENTICATION_WILL_EXPIRE(8);

        private int value;

        private PlayerEvent(int value) {
            this.value = value;
        }

        public static int getValue(PlayerEvent type) {
            return type.value;
        }

        public static PlayerEvent fromInt(int v) {
            for (PlayerEvent type : PlayerEvent.values()) {
                if (PlayerEvent.getValue(type) != v) continue;
                return type;
            }
            return null;
        }
    }

    public static enum PlayerState {
        IDLE(0),
        OPENING(1),
        OPEN_COMPLETED(2),
        PLAYING(3),
        PAUSED(4),
        PLAYBACK_COMPLETED(5),
        STOPPED(6),
        FAILED(7);

        private int value;

        private PlayerState(int value) {
            this.value = value;
        }

        public static int getValue(PlayerState type) {
            return type.value;
        }

        public static PlayerState fromInt(int v) {
            for (PlayerState type : PlayerState.values()) {
                if (PlayerState.getValue(type) != v) continue;
                return type;
            }
            return null;
        }
    }
}

